/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.util;

import com.sun.jbi.httpsoapbc.HttpSoapComponentContext;
import com.sun.jbi.internationalization.Messages;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class TransactionsUtil {
    private static final Messages mMessages = Messages.getMessages(TransactionsUtil.class);
    private static final Logger mLogger = Messages.getLogger(TransactionsUtil.class);

    private TransactionsUtil() {
    }

    private static TransactionManager getTransactionManager() {
        return (TransactionManager)HttpSoapComponentContext.getInstance().getContext().getTransactionManager();
    }

    public static Transaction suspendTransaction() throws SystemException {
        Transaction transaction = null;
        TransactionManager tm = TransactionsUtil.getTransactionManager();
        if (tm != null) {
            try {
                transaction = tm.getTransaction();
                if (transaction != null) {
                    tm.suspend();
                    if (mLogger.isLoggable(Level.FINE)) {
                        mLogger.log(Level.FINE, "Suspended transaction [" + transaction + "]");
                    }
                }
            }
            catch (SystemException t) {
                String errmsg2 = mMessages.getString("HTTPBC-E00680.Transaction_suspend_failed");
                mLogger.log(Level.SEVERE, errmsg2, t);
                throw t;
            }
        }
        return transaction;
    }

    public static boolean resumeTransaction(Transaction transaction) {
        TransactionManager tm;
        boolean txResumed = false;
        if (transaction != null && (tm = TransactionsUtil.getTransactionManager()) != null) {
            try {
                tm.resume(transaction);
                txResumed = true;
                if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "Resumed transaction [" + transaction + "]");
                }
            }
            catch (Throwable t) {
                String errmsg2 = mMessages.getString("HTTPBC-E00681.Transaction_resume_failed", new Object[]{transaction});
                mLogger.log(Level.SEVERE, errmsg2, t);
            }
        }
        return txResumed;
    }

    public static boolean setRollbackOnlyOnTransaction(Transaction transaction) {
        boolean success = false;
        if (transaction != null) {
            try {
                transaction.setRollbackOnly();
                success = true;
                if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "Called setRollbackOnly on transaction [" + transaction + "]");
                }
            }
            catch (Throwable t) {
                String errmsg2 = mMessages.getString("HTTPBC-E00683.Transaction_setRollbackOnly_failed", new Object[]{transaction});
                mLogger.log(Level.SEVERE, errmsg2, t);
            }
        }
        return success;
    }
}

