/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.util.DebugLog;
import com.sun.jbi.httpsoapbc.util.WSDLUtilities;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.nms.wsdl11wrapper.util.WrapperUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class HttpNormalizer {
    private static Messages mMessages = Messages.getMessages(HttpNormalizer.class);
    private static Logger mLog = Messages.getLogger(HttpNormalizer.class);
    DocumentBuilder mBuilder = null;

    private Document newDocument() throws ParserConfigurationException {
        Document doc = null;
        doc = this.mBuilder.newDocument();
        return doc;
    }

    public HttpNormalizer() throws MessagingException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            this.mBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new MessagingException(mMessages.getString("HttpNormalizer.Could_not_create_HttpNormalizer_failed_to_create_document_builder", (Object)ex.getMessage()), (Throwable)ex);
        }
    }

    public NormalizedMessage normalize(Source msgContent, MessageExchange exchange, OperationMetaData meta, boolean inMsg) throws MessagingException {
        NormalizedMessage normalMsg = exchange.createMessage();
        try {
            Document normalDoc = this.mBuilder.newDocument();
            Object normalRoot = null;
            String name = null;
            Message msg = null;
            if (inMsg) {
                name = meta.getInMsgName();
                msg = meta.getInputMessage();
            } else {
                name = meta.getOutMsgName();
                msg = meta.getOutputMessage();
            }
            Element jbiMessageWrapper = WrapperUtil.createJBIMessageWrapper((Document)normalDoc, (QName)msg.getQName(), (String)name);
            normalDoc.appendChild(jbiMessageWrapper);
            Node part = msgContent instanceof StreamSource && this.isSimpleMessageType(msg) ? this.createRootElement(normalDoc, msgContent) : this.getRootElement(msgContent);
            Element jbiMessagePart = WrapperUtil.importJBIWrappedPart((Document)normalDoc, (Node)part);
            jbiMessageWrapper.appendChild(jbiMessagePart);
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "Normalized message", normalDoc);
            }
            normalMsg.setContent((Source)new DOMSource(normalDoc));
        }
        catch (Exception ex) {
            throw new MessagingException((Throwable)ex);
        }
        return normalMsg;
    }

    public NormalizedMessage normalize(DataSource msgContent, MessageExchange exchange, OperationMetaData meta, boolean inMsg) throws MessagingException {
        NormalizedMessage normalMsg = exchange.createMessage();
        try {
            Document normalDoc = this.mBuilder.newDocument();
            Object normalRoot = null;
            String name = null;
            Message msg = null;
            if (inMsg) {
                name = meta.getInMsgName();
                msg = meta.getInputMessage();
            } else {
                name = meta.getOutMsgName();
                msg = meta.getOutputMessage();
            }
            Element jbiMessageWrapper = WrapperUtil.createJBIMessageWrapper((Document)normalDoc, (QName)msg.getQName(), (String)name);
            normalDoc.appendChild(jbiMessageWrapper);
            Node part = this.createRootElement(normalDoc, msgContent);
            Element jbiMessagePart = WrapperUtil.importJBIWrappedPart((Document)normalDoc, (Node)part);
            jbiMessageWrapper.appendChild(jbiMessagePart);
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "Normalized message", normalDoc);
            }
            normalMsg.setContent((Source)new DOMSource(normalDoc));
        }
        catch (Exception ex) {
            throw new MessagingException((Throwable)ex);
        }
        return normalMsg;
    }

    private Element getRootElement(Source source) throws Exception {
        Element root = null;
        if (source instanceof DOMSource) {
            Node sourceNode = ((DOMSource)source).getNode();
            if (sourceNode instanceof Element) {
                root = (Element)sourceNode;
            } else if (sourceNode instanceof Document) {
                root = ((Document)sourceNode).getDocumentElement();
            }
        } else {
            try {
                DOMResult result = new DOMResult();
                Transformer trans = TransformerFactory.newInstance().newTransformer();
                trans.transform(source, result);
                root = ((Document)result.getNode()).getDocumentElement();
            }
            catch (Exception e) {
                throw new Exception(mMessages.getString("HTTPBC-E00798.Normalize_fail"), e);
            }
        }
        return root;
    }

    private Node createRootElement(Document normalDoc, Source msgContent) throws IOException {
        Object root = null;
        int CHARBUF_SIZE = 8192;
        StreamSource streamSource = (StreamSource)msgContent;
        InputStreamReader streamReader = new InputStreamReader(streamSource.getInputStream(), "UTF-8");
        char[] charBuf = new char[8192];
        StringBuffer dataBuf = new StringBuffer();
        int readcnt = 0;
        while ((readcnt = streamReader.read(charBuf)) != -1) {
            dataBuf.append(charBuf, 0, readcnt);
        }
        String content = dataBuf.toString();
        if ("".equals(content)) {
            throw new IOException(mMessages.getString("HTTPBC-E00784.Blank_message"));
        }
        return normalDoc.createTextNode(content);
    }

    private Node createRootElement(Document normalDoc, DataSource msgContent) throws IOException {
        Text root = null;
        int CHARBUF_SIZE = 8192;
        InputStreamReader streamReader = new InputStreamReader(msgContent.getInputStream(), "UTF-8");
        char[] charBuf = new char[8192];
        StringBuffer dataBuf = new StringBuffer();
        int readcnt = 0;
        while ((readcnt = streamReader.read(charBuf)) != -1) {
            dataBuf.append(charBuf, 0, readcnt);
        }
        root = normalDoc.createTextNode(dataBuf.toString());
        return root;
    }

    private boolean isSimpleMessageType(Message msgDef) {
        boolean isSimple = true;
        List partsList = msgDef.getOrderedParts(null);
        ListIterator iter = partsList.listIterator();
        do {
            Part p;
            boolean bl = isSimple = (p = (Part)iter.next()).getElementName() == null && WSDLUtilities.isBuiltInType(p.getTypeName().getNamespaceURI());
        } while (isSimple && iter.hasNext());
        return isSimple;
    }
}

