/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.validator.soapvalidators;

import com.sun.jbi.httpsoapbc.validator.Visitable;
import com.sun.jbi.httpsoapbc.validator.Visitor;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.HttpSoapHeaderFaultValidator;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.HttpSoapHeaderValidator;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.MessagePart;
import com.sun.jbi.httpsoapbc.validator.soapvalidators.ValidatorObserver;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.wsdlvalidator.ValidationException;
import com.sun.jbi.wsdlvalidator.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSoapBodyValidator
implements Validator,
ValidatorObserver,
Visitable,
Visitor {
    private static final Messages mMessages = Messages.getMessages(HttpSoapBodyValidator.class);
    private final List<ValidatorObserver> mObservers = new LinkedList<ValidatorObserver>();
    private final List<MessagePart> mParts = Collections.synchronizedList(new LinkedList());

    public void validate(ExtensibilityElement element) throws ValidationException {
        SOAPBody body = (SOAPBody)element;
        String use = body.getUse();
        if (use != null && !use.equals("literal") && !use.equals("encoded")) {
            throw new ValidationException(mMessages.getString("HTTPBC-E00284.Unsupported_use_attribute", new Object[]{"<soap:body>", use}));
        }
        List parts = body.getParts();
        if (parts != null && parts.size() != 0) {
            this.mParts.clear();
            for (Object part : parts) {
                String value = part == null ? null : part.toString();
                if (value == null || "".equals(value)) continue;
                MessagePart aPart = new MessagePart(null, value);
                this.mParts.add(aPart);
            }
            this.notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachObserver(ValidatorObserver observer) {
        if (observer != null) {
            List<ValidatorObserver> list = this.mObservers;
            synchronized (list) {
                this.mObservers.remove(observer);
                this.mObservers.add(observer);
            }
        }
    }

    @Override
    public void notify(Object subject) throws ValidationException {
        if (subject instanceof Visitable) {
            Visitable visitable = (Visitable)subject;
            visitable.accept(this);
        }
    }

    @Override
    public void accept(Visitor visitor) throws ValidationException {
        visitor.visit(this);
    }

    @Override
    public void visit(Validator subject) throws ValidationException {
        if (subject instanceof HttpSoapHeaderValidator) {
            HttpSoapHeaderValidator validator = (HttpSoapHeaderValidator)subject;
            String subjectName = "<soap:header>";
        } else if (subject instanceof HttpSoapHeaderFaultValidator) {
            HttpSoapHeaderFaultValidator validator = (HttpSoapHeaderFaultValidator)subject;
            String subjectName = "<soap:headerfault>";
            this.checkPart(validator.getPart(), subjectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MessagePart> getParts() {
        ArrayList<MessagePart> list;
        List<MessagePart> list2 = this.mParts;
        synchronized (list2) {
            list = new ArrayList<MessagePart>(this.mParts);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObservers() throws ValidationException {
        List<ValidatorObserver> list = this.mObservers;
        synchronized (list) {
            for (ValidatorObserver o : this.mObservers) {
                o.notify(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPart(MessagePart part, String subject) throws ValidationException {
        if (part != null) {
            List<MessagePart> list = this.mParts;
            synchronized (list) {
                if (this.mParts.isEmpty()) {
                    throw new ValidationException(mMessages.getString("HTTPBC-E00285.Part_in_use", new Object[]{part.getPartName(), "<soap:body>", subject}));
                }
                for (MessagePart value : this.mParts) {
                    if (!part.getPartName().equals(value.getPartName())) continue;
                    throw new ValidationException(mMessages.getString("HTTPBC-E00285.Part_in_use", new Object[]{part.getPartName(), "<soap:body>", subject}));
                }
            }
        }
    }
}

