/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Map;

public class StringUtil {
    private static final int STREAM_READ_CHUNK_SIZE = 2048;
    private static Map<Character, String> XMLEntitiesToNamesMap = new HashMap<Character, String>();

    private StringUtil() {
    }

    public static String replaceAll(String s, String match, String replacement) {
        StringBuffer sb = new StringBuffer();
        String temp = s;
        while (true) {
            int i;
            if ((i = temp.indexOf(match)) < 0) {
                sb.append(temp);
                return sb.toString();
            }
            sb.append(temp.substring(0, i));
            sb.append(replacement);
            temp = temp.substring(i + match.length());
        }
    }

    public static String streamToString(InputStream stream, String encoding) throws UnsupportedEncodingException, IOException {
        InputStreamReader isr = new InputStreamReader(stream, encoding);
        StringBuffer sb = new StringBuffer();
        char[] cb = new char[2048];
        int cnt = 0;
        while ((cnt = isr.read(cb)) != -1) {
            sb.append(cb, 0, cnt);
        }
        return sb.toString();
    }

    public static String escapeXML(String str) {
        String result = null;
        boolean foundEntity = false;
        if (str != null) {
            StringBuffer buffer = new StringBuffer(str.length());
            StringCharacterIterator iter = new StringCharacterIterator(str);
            char ch = iter.first();
            while (ch != '\uffff') {
                String name = XMLEntitiesToNamesMap.get(Character.valueOf(ch));
                buffer.append(name != null ? name : Character.valueOf(ch));
                foundEntity = foundEntity || name != null;
                ch = iter.next();
            }
            result = !foundEntity ? str : buffer.toString();
        }
        return result;
    }

    static {
        XMLEntitiesToNamesMap.put(Character.valueOf('<'), "&lt;");
        XMLEntitiesToNamesMap.put(Character.valueOf('>'), "&gt;");
        XMLEntitiesToNamesMap.put(Character.valueOf('\''), "&apos;");
        XMLEntitiesToNamesMap.put(Character.valueOf('\"'), "&quot;");
        XMLEntitiesToNamesMap.put(Character.valueOf('&'), "&amp;");
    }
}

