/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hulp.profiler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import net.java.hulp.measure.internal.FactoryV2;
import net.sf.hulp.measure.Measurement;
import net.sf.hulp.profiler.RealProfiler;
import net.sf.hulp.profiler.VoidProfiler;
import net.sf.hulp.util.Markup;
import net.sf.hulp.util.MarkupHtml;

public abstract class Profiler
implements Measurement.Factory,
FactoryV2 {
    private static Profiler s_singleton;
    public static final String PROVIDER = "net.sf.hulp.profiler.Provider";
    public static final String DUMPONEXITTO = "net.sf.hulp.profiler.dumpto";
    public static final String H_SOURCE = "source";
    public static final String H_TOPIC = "topic";
    public static final String H_SUBTOPIC = "sub topic";
    public static final String H_N = "n";
    public static final String H_TOTALTIME = "total time (ms)";
    public static final String H_AVERAGEPRIME = "average' (ms)";
    public static final String H_MEDIAN = "median (ms)";
    public static final String H_ACT = "act";
    public static final String H_FIRST = "first (ms)";
    public static final String H_AVERAGE = "average (ms)";
    public static final String H_THROUGHPUT = "throughput (s-1)";
    public static final String H_TIMESPAN = "last-first (ms)";
    public static final String H_LOAD = "load";
    public static final String H_HISTPREFIX = "h ";

    private static synchronized void load() {
        block7: {
            if (s_singleton != null) {
                return;
            }
            try {
                Profiler p = null;
                String classname = System.getProperty(PROVIDER, RealProfiler.class.getName());
                if (classname == null || "".equals(classname)) {
                    p = new VoidProfiler();
                    s_singleton = p;
                    break block7;
                }
                try {
                    Class<?> dynclass = Class.forName(classname);
                    p = (Profiler)dynclass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error loading profiler provider [" + classname + "]: " + e, e);
                }
                String dumpto = System.getProperty(DUMPONEXITTO, null);
                if (dumpto != null && dumpto.length() > 0) {
                    Thread t = new Thread((Runnable)new DumpOnExit(p, new File(dumpto)), "Profiler dump on exit");
                    Runtime.getRuntime().addShutdownHook(t);
                }
                s_singleton = p;
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading profiler provider: " + e, e);
            }
        }
    }

    public static Profiler get() {
        if (s_singleton == null) {
            Profiler.load();
        }
        return s_singleton;
    }

    public abstract void dump(PrintWriter var1, Markup var2) throws IOException;

    public abstract Map[] dump();

    public abstract void help(PrintWriter var1, Markup var2);

    public abstract Map dump(String var1);

    public abstract void clear();

    public static class DumpOnExit
    implements Runnable {
        private Profiler mProfiler;
        private File mDumpTo;

        public DumpOnExit(Profiler dumpWhat, File dumpToDirectory) {
            this.mProfiler = dumpWhat;
            this.mDumpTo = dumpToDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            OutputStream out = null;
            try {
                File f = File.createTempFile("profiler", ".html", this.mDumpTo);
                out = new BufferedOutputStream(new FileOutputStream(f));
                PrintWriter o = new PrintWriter(out);
                MarkupHtml m = new MarkupHtml();
                o.println(((Markup)m).beginPage());
                o.println(((Markup)m).beginTable(2));
                this.mProfiler.dump(o, m);
                o.println(((Markup)m).endTable());
                o.println(((Markup)m).endPage());
                o.flush();
            }
            catch (Exception e) {
                System.out.println("Could not dump profiler data in shutdown handler to " + this.mDumpTo.getAbsolutePath());
                e.printStackTrace();
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

