/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.RedeliveryListener;
import com.sun.jbi.httpsoapbc.ReplyListener;
import com.sun.jbi.internationalization.Messages;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;

public class MessageExchangeSupport {
    private static final Messages mMessages = Messages.getMessages(MessageExchangeSupport.class);
    private static final Logger mLogger = Messages.getLogger(MessageExchangeSupport.class);
    static Map<String, ReplyListener> replyListeners = Collections.synchronizedMap(new HashMap());
    static Map<String, RedeliveryListener> redeliveryListeners = Collections.synchronizedMap(new HashMap());

    public static void addReplyListener(String messageExchangeId, ReplyListener listener, Object clientContext) {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Adding reply listener for messsage exchange:" + messageExchangeId);
        }
        listener.setMessageExchangeId(messageExchangeId, clientContext);
        replyListeners.put(messageExchangeId, listener);
    }

    public static void removeReplyListener(String messageExchangeId) {
        ReplyListener listener = replyListeners.remove(messageExchangeId);
    }

    public static void removeReplyListener(String messageExchangeId, boolean isRedelivered) {
        ReplyListener listener = replyListeners.remove(messageExchangeId);
        if (isRedelivered) {
            listener.removeMessageExchangeId(messageExchangeId);
        }
    }

    public static void notifyOfReply(MessageExchange mep) throws MessagingException {
        String messageExchangeId = mep.getExchangeId();
        ReplyListener listener = replyListeners.get(messageExchangeId);
        if (listener == null) {
            throw new MessagingException("Cannot process reply exchange " + messageExchangeId + " because no reply listener has been registered");
        }
        listener.onReply(mep);
    }

    public static void addRedeliveryListener(String messageExchangeId, RedeliveryListener listener, OperationMetaData exchangeMetaData, Object clientContext) {
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Adding redelivery listener for messsage exchange:" + messageExchangeId);
        }
        listener.setMessageExchangeId(messageExchangeId, exchangeMetaData, clientContext);
        redeliveryListeners.put(messageExchangeId, listener);
    }

    public static void removeRedeliveryListener(String messageExchangeId) {
        RedeliveryListener listener = redeliveryListeners.remove(messageExchangeId);
    }

    public static void notifyOfRedelivery(MessageExchange mep) throws MessagingException {
        String messageExchangeId = mep.getExchangeId();
        RedeliveryListener listener = redeliveryListeners.get(messageExchangeId);
        if (listener == null) {
            throw new MessagingException("Cannot redelivery the message exchange " + messageExchangeId + " because no redelivery listener has been registered");
        }
        listener.onRedelivery(mep);
    }
}

