/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.jaxwssupport;

import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.HttpEndpoint;
import com.sun.jbi.httpsoapbc.HttpSoapEndpoint;
import com.sun.jbi.httpsoapbc.jaxwssupport.AsyncJBIProvider;
import com.sun.jbi.httpsoapbc.jaxwssupport.AsyncXmlHttpJBIProvider;
import com.sun.jbi.httpsoapbc.jaxwssupport.InvokerImpl;
import com.sun.jbi.httpsoapbc.jaxwssupport.NewWebServiceContextImpl;
import com.sun.jbi.internationalization.Messages;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.AsyncProvider;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;

public class JAXWSEndpointFactory {
    private static final Messages mMessages = Messages.getMessages(JAXWSEndpointFactory.class);
    private static final Logger mLogger = Messages.getLogger(JAXWSEndpointFactory.class);

    public WSEndpoint createWSEndpoint(int port, String urlContext, Endpoint endpoint) throws Exception {
        BindingID bindingID;
        String lexicalBindingType;
        Class serviceEndpointClass = AsyncJBIProvider.class;
        AsyncProvider<SOAPMessage> serviceEndpoint = new AsyncJBIProvider(endpoint);
        boolean processHandlerAnnotation = false;
        if (endpoint instanceof HttpSoapEndpoint) {
            serviceEndpointClass = AsyncJBIProvider.class;
            serviceEndpoint = new AsyncJBIProvider(endpoint);
        } else if (endpoint instanceof HttpEndpoint) {
            serviceEndpointClass = AsyncXmlHttpJBIProvider.class;
            serviceEndpoint = new AsyncXmlHttpJBIProvider(endpoint);
        } else {
            String msg = mMessages.getString("HTTPBC-E00633.Unsupported_endpoint_type", new Object[]{endpoint.getEndpointName(), endpoint.getClass().toString()});
            throw new IllegalArgumentException(msg);
        }
        NewWebServiceContextImpl wsc = new NewWebServiceContextImpl();
        InvokerImpl invoker = new InvokerImpl(serviceEndpoint, wsc);
        QName serviceName = endpoint.getServiceName();
        QName portName = new QName(endpoint.getServiceName().getNamespaceURI(), endpoint.getEndpointName());
        Container container = null;
        WSBinding binding = null;
        if (endpoint instanceof HttpSoapEndpoint) {
            lexicalBindingType = "http://schemas.xmlsoap.org/wsdl/soap/http";
            bindingID = BindingID.parse((String)lexicalBindingType);
            binding = bindingID.createBinding();
        } else if (endpoint instanceof HttpEndpoint) {
            lexicalBindingType = "http://www.w3.org/2004/08/wsdl/http";
            bindingID = BindingID.parse((String)lexicalBindingType);
            binding = bindingID.createBinding();
        }
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Creating WSEndpoint with primary WSDL URL: " + endpoint.getOriginalWSDL().toURL());
        }
        SDDocumentSource primaryWsdl = SDDocumentSource.create((URL)endpoint.getOriginalWSDL().toURL());
        ArrayList<SDDocumentSource> docs = null;
        if (endpoint.getWSDLImports() != null) {
            docs = new ArrayList<SDDocumentSource>();
            for (URL entry : endpoint.getWSDLImports()) {
                if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "Adding imported WSDL document with URL: " + entry + " to the list of SDDocumentSource...");
                }
                SDDocumentSource importedDoc = SDDocumentSource.create((URL)entry);
                docs.add(importedDoc);
            }
        }
        URL catalogURL = null;
        File catalog = new File(endpoint.getServiceUnitRootPath() + File.separator + "meta-inf" + File.separator + "catalog.xml");
        if (catalog.exists()) {
            catalogURL = catalog.toURL();
        }
        WSEndpoint wsep = WSEndpoint.create(serviceEndpointClass, (boolean)processHandlerAnnotation, (Invoker)invoker, (QName)serviceName, (QName)portName, container, (WSBinding)binding, (SDDocumentSource)primaryWsdl, docs, (URL)catalogURL);
        endpoint.setWSEndpoint(wsep);
        return wsep;
    }
}

