/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.common.qos.messaging.MessagingChannel;
import com.sun.jbi.common.qos.redelivery.Redelivery;
import com.sun.jbi.common.qos.redelivery.RedeliveryConfig;
import com.sun.jbi.common.qos.redelivery.RedeliveryStatus;
import com.sun.jbi.eManager.provider.EndpointStatus;
import com.sun.jbi.httpsoapbc.AbstractEndpoint;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.HttpEndpoint;
import com.sun.jbi.httpsoapbc.HttpNormalizer;
import com.sun.jbi.httpsoapbc.HttpSoapEndpoint;
import com.sun.jbi.httpsoapbc.MessageExchangeSupport;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.SoapDenormalizer;
import com.sun.jbi.httpsoapbc.SoapNormalizer;
import com.sun.jbi.httpsoapbc.StringDataSourceImpl;
import com.sun.jbi.httpsoapbc.management.HTTPManagementMBean;
import com.sun.jbi.httpsoapbc.util.AlertsUtil;
import com.sun.jbi.httpsoapbc.util.DebugLog;
import com.sun.jbi.httpsoapbc.util.StringUtil;
import com.sun.jbi.httpsoapbc.util.TransactionsUtil;
import com.sun.jbi.httpsoapbc.util.TransformerPool;
import com.sun.jbi.httpsoapbc.util.Util;
import com.sun.jbi.httpsoapbc.util.WSDLUtilities;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.nms.exchange.ExchangePattern;
import com.sun.jbi.nms.wsdl11wrapper.HelperFactory;
import com.sun.jbi.nms.wsdl11wrapper.WrapperParser;
import com.sun.jbi.nms.wsdl11wrapper.WrapperProcessingException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import net.java.hulp.measure.Probe;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutboundMessageProcessor {
    private static final Messages mMessages = Messages.getMessages(OutboundMessageProcessor.class);
    private static final Logger mLog = Messages.getLogger(OutboundMessageProcessor.class);
    private static final TransformerPool cTransformerPool = new TransformerPool();
    private static final String URL_DECODE_ENCODING = "UTF-8";
    private final String COMPONENT_NAME = "sun-http-binding";
    private Map mEndpoints;
    private MessagingChannel mChannel;
    private MessageFactory mSoapMessageFactory;
    private SOAPConnectionFactory mConnFact;
    private SOAPConnection mConn;
    private SoapNormalizer mNormalizer;
    private SoapDenormalizer mDenormalizer;
    private Map mInboundExchanges;
    private HTTPManagementMBean mManagementMBean;
    private HttpNormalizer mHttpNormalizer;
    private DocumentBuilderFactory mBuilderFactory;
    private DocumentBuilder mBuilder;
    private boolean mIsHeaderCopyEnabled = false;
    private Probe mDCReceiveToSoapCallMeasurement = null;

    public OutboundMessageProcessor(MessagingChannel chnl, Map endpoints, Map inboundExchanges, HTTPManagementMBean managementMBean) {
        this.mChannel = chnl;
        this.mEndpoints = endpoints;
        this.mManagementMBean = managementMBean;
        try {
            this.mNormalizer = new SoapNormalizer();
            this.mDenormalizer = new SoapDenormalizer();
        }
        catch (Exception e) {
            String text = mMessages.getString("HTTPBC-E00776.Failed_create_soap_normalizer");
            AlertsUtil.getAlerter().critical(text, "sun-http-binding", null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00776");
            throw new IllegalStateException(text, e);
        }
        try {
            this.mHttpNormalizer = new HttpNormalizer();
        }
        catch (Exception e) {
            String text = mMessages.getString("HTTPBC-E00777.Failed_create_http_normalizer");
            AlertsUtil.getAlerter().critical(text, "sun-http-binding", null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00777");
            throw new IllegalStateException(text, e);
        }
        this.mInboundExchanges = inboundExchanges;
        try {
            this.mConnFact = SOAPConnectionFactory.newInstance();
            this.mConn = this.mConnFact.createConnection();
            this.mSoapMessageFactory = MessageFactory.newInstance();
            this.mBuilderFactory = DocumentBuilderFactory.newInstance();
            this.mBuilder = this.mBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            String text = mMessages.getString("HTTPBC-E00778.Failed_create_outbound_processor");
            AlertsUtil.getAlerter().critical(text, "sun-http-binding", null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00778");
            throw new IllegalStateException(text, e);
        }
    }

    public void processMessage(MessageExchange exchange) {
        this.mDCReceiveToSoapCallMeasurement = Probe.fine(this.getClass(), (String)"processMessageExchange");
        String exchangeId = exchange.getExchangeId();
        boolean inbound = exchange.getRole().equals(MessageExchange.Role.CONSUMER);
        if (inbound) {
            Long invocationTime = (Long)this.mInboundExchanges.remove(exchangeId);
            if (mLog.isLoggable(Level.FINE) && invocationTime != null) {
                long difference = System.currentTimeMillis() - invocationTime;
                mLog.log(Level.FINE, "Response for exchange " + exchangeId + " received (" + Long.valueOf(difference) + " ms}");
            }
        }
        URI pattern = exchange.getPattern();
        if (mLog.isLoggable(Level.FINE)) {
            if (inbound) {
                mLog.log(Level.FINE, "Processing message exchange " + exchange.getExchangeId() + " as inbound; pattern is " + pattern.toString());
            } else {
                mLog.log(Level.FINE, "Processing message exchange " + exchange.getExchangeId() + " as outbound; pattern is " + pattern.toString());
            }
        }
        switch (ExchangePattern.valueOf((MessageExchange)exchange)) {
            case IN_OUT: {
                if (inbound) {
                    this.processRequestReplyInbound((InOut)exchange);
                    break;
                }
                this.processRequestReplyOutbound((InOut)exchange);
                break;
            }
            case IN_ONLY: {
                if (inbound) {
                    this.processOneWayInbound((InOnly)exchange);
                    break;
                }
                this.processOneWayOutbound((InOnly)exchange);
                break;
            }
            case ROBUST_IN_ONLY: {
                String msg = mMessages.getString("HTTPBC-E00751.MEP_robust_inonly_not_supported", (Object)exchange.getExchangeId());
                mLog.log(Level.SEVERE, msg);
                try {
                    this.setErrorUnsupportedExchangePattern(exchange, msg, null);
                    Endpoint epb = this.getInboundEndpoint(exchange);
                    this.mChannel.send(exchange);
                    if (epb == null) break;
                    this.updateTallySends(epb, false);
                }
                catch (MessagingException ex) {
                    String text = mMessages.getString("HTTPBC-E00775.Exception_during_exchange_processing", (Object)exchange.getExchangeId());
                    mLog.log(Level.SEVERE, text, ex);
                    Endpoint epb = this.getInboundEndpoint(exchange);
                    AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00775");
                }
                break;
            }
            default: {
                String msg = mMessages.getString("HTTPBC-E00752.Invalid_MEP", new Object[]{exchange.getExchangeId(), pattern.toString()});
                mLog.log(Level.SEVERE, msg);
                try {
                    this.setErrorUnsupportedExchangePattern(exchange, msg, null);
                    Endpoint epb = this.getInboundEndpoint(exchange);
                    this.mChannel.send(exchange);
                    if (epb != null) {
                        this.updateTallySends(epb, false);
                    }
                }
                catch (MessagingException ex) {
                    String text = mMessages.getString("HTTPBC-E00775.Exception_during_exchange_processing", (Object)exchange.getExchangeId());
                    mLog.log(Level.SEVERE, text, ex);
                    Endpoint epb = this.getInboundEndpoint(exchange);
                    AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00775");
                }
                return;
            }
        }
    }

    public void processRequestReplyInbound(InOut inout) {
        String text;
        Endpoint epb;
        boolean success;
        block20: {
            success = true;
            boolean isRetry = this.isRedeliveryConfigured((MessageExchange)inout);
            epb = this.getInboundEndpoint((MessageExchange)inout);
            if (isRetry && epb == null) {
                epb = this.getInboundEndpoint((MessageExchange)inout, true);
            }
            if (inout.getOutMessage() != null) {
                this.updateTallyReceivedReplies(epb);
                if (isRetry) {
                    MessageExchangeSupport.removeRedeliveryListener(inout.getExchangeId());
                }
            } else if (ExchangeStatus.ERROR.equals(inout.getStatus())) {
                String msg;
                String errorMsg;
                this.updateTallyReceives(epb, false);
                String string = errorMsg = inout.getError() != null ? inout.getError().getMessage() : null;
                if (errorMsg != null) {
                    msg = mMessages.getString("HTTPBC-E00720.Message_exchange_error", new Object[]{String.valueOf(epb.getServiceName()), epb.getEndpointName(), errorMsg});
                    mLog.log(Level.SEVERE, msg);
                    AlertsUtil.getAlerter().warning(msg, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00720");
                } else {
                    msg = mMessages.getString("HTTPBC-E00721.Message_exchange_error_no_detail", new Object[]{String.valueOf(epb.getServiceName()), epb.getEndpointName()});
                    mLog.log(Level.SEVERE, msg);
                    AlertsUtil.getAlerter().warning(msg, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00721");
                }
                RedeliveryStatus retryStatus = Redelivery.getRedeliveryStatus((MessageExchange)inout);
                RedeliveryConfig retryConfig = epb.getRedeliveryConfiguration();
                if (retryStatus != null && retryConfig != null) {
                    RedeliveryConfig.Failure onFailureOption = retryConfig.getFailure();
                    if (!(retryStatus.hasFailed() || onFailureOption != RedeliveryConfig.Failure.suspend && onFailureOption != RedeliveryConfig.Failure.error)) {
                        this.handleRedelivery((MessageExchange)inout, epb);
                        return;
                    }
                    if (onFailureOption == RedeliveryConfig.Failure.suspend) {
                        try {
                            this.mManagementMBean.suspend(epb.getUniqueName());
                            String msg2 = mMessages.getString("HTTPBC-E00806.About_to_suspend_endpoint", new Object[]{String.valueOf(epb.getServiceName()), epb.getEndpointName()});
                            mLog.log(Level.WARNING, msg2);
                            AlertsUtil.getAlerter().warning(msg2, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00806");
                        }
                        catch (MBeanException e) {
                            errorMsg = e.getTargetException().getMessage();
                            if (errorMsg == null) break block20;
                            String msg3 = mMessages.getString("HTTPBC-E00805.Failed_to_suspend_endpoint", new Object[]{String.valueOf(epb.getServiceName()), epb.getEndpointName(), errorMsg});
                            mLog.log(Level.SEVERE, msg3);
                            AlertsUtil.getAlerter().warning(msg3, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00805");
                        }
                    }
                }
            }
        }
        try {
            MessageExchangeSupport.notifyOfReply((MessageExchange)inout);
        }
        catch (Exception ex) {
            if (mLog.isLoggable(Level.WARNING)) {
                text = mMessages.getString("HTTPBC-E00759.Exception_during_reply_processing", (Object)ex.getLocalizedMessage());
                mLog.log(Level.WARNING, text, ex);
                AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00759");
            }
            success = false;
        }
        try {
            if (inout.getStatus() == ExchangeStatus.ACTIVE) {
                if (success) {
                    inout.setStatus(ExchangeStatus.DONE);
                } else {
                    inout.setStatus(ExchangeStatus.ERROR);
                }
                this.mChannel.send((MessageExchange)inout);
                this.updateTallySends(epb, success);
            }
        }
        catch (MessagingException ex) {
            text = mMessages.getString("HTTPBC-E00759.Exception_during_reply_processing", (Object)ex.getLocalizedMessage());
            mLog.log(Level.SEVERE, text, ex);
            AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00759");
        }
    }

    public void processOneWayInbound(InOnly inonly) {
        block18: {
            Map nameToMeta;
            OperationMetaData meta;
            Endpoint epb;
            boolean replyAfterProcessing;
            block17: {
                replyAfterProcessing = true;
                boolean isRetry = this.isRedeliveryConfigured((MessageExchange)inonly);
                epb = this.getInboundEndpoint((MessageExchange)inonly);
                if (isRetry && epb == null) {
                    epb = this.getInboundEndpoint((MessageExchange)inonly, true);
                }
                if (ExchangeStatus.DONE.equals(inonly.getStatus())) {
                    this.updateTallyReceives(epb, true);
                    if (isRetry) {
                        MessageExchangeSupport.removeRedeliveryListener(inonly.getExchangeId());
                    }
                } else if (ExchangeStatus.ERROR.equals(inonly.getStatus())) {
                    String msg;
                    String errorMsg;
                    this.updateTallyReceives(epb, false);
                    String string = errorMsg = inonly.getError() != null ? inonly.getError().getMessage() : null;
                    if (errorMsg != null) {
                        msg = mMessages.getString("HTTPBC-E00720.Message_exchange_error", new Object[]{String.valueOf(epb.getServiceName()), epb.getEndpointName(), errorMsg});
                        mLog.log(Level.SEVERE, msg);
                        AlertsUtil.getAlerter().warning(msg, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00759");
                    } else {
                        msg = mMessages.getString("HTTPBC-E00721.Message_exchange_error_no_detail", new Object[]{String.valueOf(epb.getServiceName()), epb.getEndpointName()});
                        mLog.log(Level.SEVERE, msg);
                        AlertsUtil.getAlerter().warning(msg, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00721");
                    }
                    RedeliveryStatus retryStatus = Redelivery.getRedeliveryStatus((MessageExchange)inonly);
                    RedeliveryConfig retryConfig = epb.getRedeliveryConfiguration();
                    if (retryStatus != null && retryConfig != null) {
                        if (!retryStatus.hasFailed()) {
                            this.handleRedelivery((MessageExchange)inonly, epb);
                            return;
                        }
                        RedeliveryConfig.Failure onFailureOption = retryConfig.getFailure();
                        if (onFailureOption == RedeliveryConfig.Failure.suspend) {
                            try {
                                this.mManagementMBean.suspend(epb.getUniqueName());
                                String msg2 = mMessages.getString("HTTPBC-E00806.About_to_suspend_endpoint", new Object[]{String.valueOf(epb.getServiceName()), epb.getEndpointName()});
                                mLog.log(Level.WARNING, msg2);
                                AlertsUtil.getAlerter().warning(msg2, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00806");
                            }
                            catch (MBeanException e) {
                                errorMsg = e.getTargetException().getMessage();
                                if (errorMsg == null) break block17;
                                String msg3 = mMessages.getString("HTTPBC-E00805.Failed_to_suspend_endpoint", new Object[]{String.valueOf(epb.getServiceName()), epb.getEndpointName(), errorMsg});
                                mLog.log(Level.SEVERE, msg3);
                                AlertsUtil.getAlerter().warning(msg3, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00805");
                            }
                        }
                    }
                }
            }
            if ((meta = (OperationMetaData)(nameToMeta = epb.getOperationNameToMetaData()).get(inonly.getOperation())) == null && (meta = (OperationMetaData)nameToMeta.get(inonly.getOperation().getLocalPart())) == null && mLog.isLoggable(Level.WARNING)) {
                String msg = mMessages.getString("HTTPBC-W00751.Operation_lookup_failed", (Object)inonly.getOperation().toString());
                mLog.log(Level.WARNING, msg);
                AlertsUtil.getAlerter().warning(msg, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W00751");
            }
            if (meta != null) {
                replyAfterProcessing = meta.getOneWayReplyAfterProcessing();
            }
            if (replyAfterProcessing) {
                try {
                    MessageExchangeSupport.notifyOfReply((MessageExchange)inonly);
                }
                catch (Exception ex) {
                    if (!mLog.isLoggable(Level.WARNING)) break block18;
                    String text = mMessages.getString("HTTPBC-E00759.Exception_during_reply_processing", (Object)ex.getLocalizedMessage());
                    mLog.log(Level.WARNING, text, ex);
                    AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00759");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processRequestReplyOutbound(InOut inout) {
        block25: {
            Probe soapToDCSendMeasurement;
            Endpoint epb = null;
            epb = this.getOutboundEndpoint((MessageExchange)inout);
            Transaction transaction = (Transaction)inout.getProperty("javax.jbi.transaction.jta");
            if (inout.getStatus() == ExchangeStatus.DONE) {
                this.updateTallyReceives(epb, true);
            } else if (inout.getStatus() == ExchangeStatus.ERROR) {
                if (transaction != null) {
                    this.setTransactionRollbackOnly(transaction);
                }
                this.updateTallyReceives(epb, false);
            } else {
                block23: {
                    soapToDCSendMeasurement = Probe.fine(this.getClass(), (String)epb.getUniqueName(), (String)"soapToDCSend");
                    this.updateTallyReceivedRequests(epb);
                    Map nameToMeta = epb.getOperationNameToMetaData();
                    if (inout.getOperation() == null) {
                        throw new MessagingException(mMessages.getString("HTTPBC-E00808.No_operation_defined_in_ME", (Object)inout.getExchangeId()));
                    }
                    OperationMetaData meta = (OperationMetaData)nameToMeta.get(inout.getOperation().getLocalPart());
                    if (meta == null) {
                        throw new MessagingException(mMessages.getString("HTTPBC-E00700.Operation_not_defined", new Object[]{inout.getOperation(), inout.getExchangeId(), inout.getPattern().toString()}));
                    }
                    Logger.getLogger("com.sun.EnterContext").fine(epb.getServiceUnitID() + "-" + inout.getOperation());
                    if (epb instanceof HttpSoapEndpoint) {
                        this.dispatch((HttpSoapEndpoint)epb, inout, meta);
                    }
                    if (!(epb instanceof HttpEndpoint)) break block23;
                    this.dispatch((HttpEndpoint)epb, inout, meta);
                }
                Object var9_10 = null;
                Logger.getLogger("com.sun.ExitContext").fine(epb.getServiceUnitID() + "-" + inout.getOperation());
                try {
                    this.mChannel.send((MessageExchange)inout);
                    if (soapToDCSendMeasurement != null) {
                        soapToDCSendMeasurement.end();
                    }
                    this.updateTallySentReplies(epb);
                }
                catch (MessagingException ex2) {
                    String text = mMessages.getString("HTTPBC-E00779.Exception_send_reply");
                    mLog.log(Level.SEVERE, text, ex2);
                    AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00779");
                }
            }
            break block25;
            {
                catch (Exception ex) {
                    block24: {
                        if (mLog.isLoggable(Level.WARNING)) {
                            String text = mMessages.getString("HTTPBC-E00759.Exception_during_reply_processing", (Object)ex.getLocalizedMessage());
                            mLog.log(Level.WARNING, text, ex);
                        }
                        try {
                            this.setErrorServerException((MessageExchange)inout, ex, (String)null);
                        }
                        catch (MessagingException e) {
                            if (!mLog.isLoggable(Level.WARNING)) break block24;
                            String text = mMessages.getString("HTTPBC-E00759.Exception_during_reply_processing", (Object)ex.getLocalizedMessage());
                            mLog.log(Level.WARNING, text, ex);
                            AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00759");
                        }
                    }
                    if (transaction != null) {
                        this.setTransactionRollbackOnly(transaction);
                    }
                    Object var9_11 = null;
                    Logger.getLogger("com.sun.ExitContext").fine(epb.getServiceUnitID() + "-" + inout.getOperation());
                    try {
                        this.mChannel.send((MessageExchange)inout);
                        if (soapToDCSendMeasurement != null) {
                            soapToDCSendMeasurement.end();
                        }
                        this.updateTallySentReplies(epb);
                    }
                    catch (MessagingException ex2) {
                        String text = mMessages.getString("HTTPBC-E00779.Exception_send_reply");
                        mLog.log(Level.SEVERE, text, ex2);
                        AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00779");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                Logger.getLogger("com.sun.ExitContext").fine(epb.getServiceUnitID() + "-" + inout.getOperation());
                try {
                    this.mChannel.send((MessageExchange)inout);
                    if (soapToDCSendMeasurement != null) {
                        soapToDCSendMeasurement.end();
                    }
                    this.updateTallySentReplies(epb);
                }
                catch (MessagingException ex2) {
                    String text = mMessages.getString("HTTPBC-E00779.Exception_send_reply");
                    mLog.log(Level.SEVERE, text, ex2);
                    AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00779");
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processOneWayOutbound(InOnly inonly) {
        block33: {
            Transaction transaction;
            Endpoint epb;
            block31: {
                epb = null;
                transaction = (Transaction)inonly.getProperty("javax.jbi.transaction.jta");
                epb = this.getOutboundEndpoint((MessageExchange)inonly);
                this.updateTallyReceivedRequests(epb);
                if (!(epb instanceof HttpSoapEndpoint)) break block31;
                if (inonly.getOperation() == null) {
                    throw new MessagingException(mMessages.getString("HTTPBC-E00808.No_operation_defined_in_ME", (Object)inonly.getExchangeId()));
                }
                Map nameToMeta = epb.getOperationNameToMetaData();
                OperationMetaData meta = (OperationMetaData)nameToMeta.get(inonly.getOperation());
                if (meta == null && (meta = (OperationMetaData)nameToMeta.get(inonly.getOperation().getLocalPart())) == null) {
                    throw new MessagingException(mMessages.getString("HTTPBC-E00700.Operation_not_defined", new Object[]{inonly.getOperation(), inonly.getExchangeId(), inonly.getPattern().toString()}));
                }
                this.outboundCall(inonly.getInMessage(), meta, (HttpSoapEndpoint)epb, (MessageExchange)inonly);
            }
            Object var8_15 = null;
            try {
                if (inonly.getStatus() != ExchangeStatus.ERROR) {
                    inonly.setStatus(ExchangeStatus.DONE);
                }
                this.mChannel.send((MessageExchange)inonly);
                this.updateTallySends(epb, inonly.getStatus() == ExchangeStatus.DONE);
            }
            catch (MessagingException ex) {
                String text = mMessages.getString("HTTPBC-E00780.Exception_set_status");
                mLog.log(Level.SEVERE, text, ex);
                AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00780");
            }
            break block33;
            {
                catch (MessagingException e) {
                    block32: {
                        if (mLog.isLoggable(Level.WARNING)) {
                            String text = mMessages.getString("HTTPBC-W00758.Exception_during_request_processing", (Object)e.getLocalizedMessage());
                            mLog.log(Level.WARNING, text, e);
                        }
                        try {
                            this.setErrorClientException((MessageExchange)inonly, (Exception)((Object)e), null);
                        }
                        catch (MessagingException ex) {
                            if (!mLog.isLoggable(Level.WARNING)) break block32;
                            String text = mMessages.getString("HTTPBC-W00758.Exception_during_request_processing", (Object)ex.getLocalizedMessage());
                            mLog.log(Level.WARNING, text, ex);
                            AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00758");
                        }
                    }
                    if (transaction != null) {
                        this.setTransactionRollbackOnly(transaction);
                    }
                    Object var8_16 = null;
                    try {
                        if (inonly.getStatus() != ExchangeStatus.ERROR) {
                            inonly.setStatus(ExchangeStatus.DONE);
                        }
                        this.mChannel.send((MessageExchange)inonly);
                        this.updateTallySends(epb, inonly.getStatus() == ExchangeStatus.DONE);
                    }
                    catch (MessagingException ex) {
                        String text = mMessages.getString("HTTPBC-E00780.Exception_set_status");
                        mLog.log(Level.SEVERE, text, ex);
                        AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00780");
                    }
                    break block33;
                }
                catch (SOAPException e) {
                    block34: {
                        if (mLog.isLoggable(Level.WARNING)) {
                            String text = mMessages.getString("HTTPBC-W00758.Exception_during_request_processing", (Object)e.getLocalizedMessage());
                            mLog.log(Level.WARNING, text, e);
                        }
                        try {
                            this.setErrorClientException((MessageExchange)inonly, (Exception)((Object)e), null);
                        }
                        catch (MessagingException ex) {
                            if (!mLog.isLoggable(Level.WARNING)) break block34;
                            String text = mMessages.getString("HTTPBC-W00758.Exception_during_request_processing", (Object)ex.getLocalizedMessage());
                            mLog.log(Level.WARNING, text, ex);
                            AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00758");
                        }
                    }
                    if (transaction != null) {
                        this.setTransactionRollbackOnly(transaction);
                    }
                    Object var8_17 = null;
                    try {
                        if (inonly.getStatus() != ExchangeStatus.ERROR) {
                            inonly.setStatus(ExchangeStatus.DONE);
                        }
                        this.mChannel.send((MessageExchange)inonly);
                        this.updateTallySends(epb, inonly.getStatus() == ExchangeStatus.DONE);
                    }
                    catch (MessagingException ex) {
                        String text = mMessages.getString("HTTPBC-E00780.Exception_set_status");
                        mLog.log(Level.SEVERE, text, ex);
                        AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00780");
                    }
                    break block33;
                }
                catch (Exception e) {
                    block35: {
                        if (mLog.isLoggable(Level.WARNING)) {
                            String text = mMessages.getString("HTTPBC-W00758.Exception_during_request_processing", (Object)e.getLocalizedMessage());
                            mLog.log(Level.WARNING, text, e);
                        }
                        try {
                            this.setErrorServerException((MessageExchange)inonly, e, (String)null);
                        }
                        catch (MessagingException ex) {
                            if (!mLog.isLoggable(Level.WARNING)) break block35;
                            String text = mMessages.getString("HTTPBC-W00758.Exception_during_request_processing", (Object)e.getLocalizedMessage());
                            mLog.log(Level.WARNING, text, e);
                            AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00758");
                        }
                    }
                    if (transaction != null) {
                        this.setTransactionRollbackOnly(transaction);
                    }
                    Object var8_18 = null;
                    try {
                        if (inonly.getStatus() != ExchangeStatus.ERROR) {
                            inonly.setStatus(ExchangeStatus.DONE);
                        }
                        this.mChannel.send((MessageExchange)inonly);
                        this.updateTallySends(epb, inonly.getStatus() == ExchangeStatus.DONE);
                    }
                    catch (MessagingException ex) {
                        String text = mMessages.getString("HTTPBC-E00780.Exception_set_status");
                        mLog.log(Level.SEVERE, text, ex);
                        AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00780");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_19 = null;
                try {
                    if (inonly.getStatus() != ExchangeStatus.ERROR) {
                        inonly.setStatus(ExchangeStatus.DONE);
                    }
                    this.mChannel.send((MessageExchange)inonly);
                    this.updateTallySends(epb, inonly.getStatus() == ExchangeStatus.DONE);
                }
                catch (MessagingException ex) {
                    String text = mMessages.getString("HTTPBC-E00780.Exception_set_status");
                    mLog.log(Level.SEVERE, text, ex);
                    AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00780");
                }
                throw throwable;
            }
        }
    }

    Endpoint getOutboundEndpoint(MessageExchange outboundExchange) {
        String serviceName = outboundExchange.getEndpoint().getServiceName().toString();
        String endpointName = outboundExchange.getEndpoint().getEndpointName();
        if (mLog.isLoggable(Level.FINER)) {
            mLog.log(Level.FINER, "Getting outbound info for " + serviceName + " " + endpointName);
        }
        Endpoint epb = (Endpoint)this.mEndpoints.get(AbstractEndpoint.getUniqueName(outboundExchange.getEndpoint().getServiceName().getNamespaceURI(), outboundExchange.getEndpoint().getServiceName().getLocalPart(), endpointName, false));
        return epb;
    }

    Endpoint getInboundEndpoint(MessageExchange inboundExchange) {
        String serviceName = inboundExchange.getEndpoint().getServiceName().toString();
        String endpointName = inboundExchange.getEndpoint().getEndpointName();
        if (mLog.isLoggable(Level.FINER)) {
            mLog.log(Level.FINER, "Getting inbound info for " + serviceName + " " + endpointName);
        }
        Endpoint epb = (Endpoint)this.mEndpoints.get(HttpSoapEndpoint.getUniqueName(inboundExchange.getEndpoint().getServiceName().getNamespaceURI(), inboundExchange.getEndpoint().getServiceName().getLocalPart(), endpointName, true));
        return epb;
    }

    Endpoint getInboundEndpoint(MessageExchange inboundExchange, boolean isRetry) {
        if (isRetry) {
            ServiceEndpoint actualEndpoint = Redelivery.getEndpoint((MessageExchange)inboundExchange);
            QName serviceName = actualEndpoint.getServiceName();
            String endpointName = actualEndpoint.getEndpointName();
            if (mLog.isLoggable(Level.FINER)) {
                mLog.log(Level.FINER, "Getting inbound info for " + serviceName + " " + endpointName);
            }
            Endpoint epb = (Endpoint)this.mEndpoints.get(HttpSoapEndpoint.getUniqueName(serviceName.getNamespaceURI(), serviceName.getLocalPart(), endpointName, true));
            return epb;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SOAPMessage outboundCall(NormalizedMessage normalizedMessage, OperationMetaData meta, HttpSoapEndpoint endpointMeta, MessageExchange outboundExchange) throws SOAPException, MessagingException, Exception {
        if (mLog.isLoggable(Level.FINE)) {
            DebugLog.debugLog(mLog, Level.FINE, "Normalized message content", normalizedMessage.getContent());
        }
        Probe denormalizationMeasurement = Probe.info(this.getClass(), (String)endpointMeta.getUniqueName(), (String)"Denormalization");
        SOAPMessage soapMsg = null;
        try {
            soapMsg = this.mDenormalizer.denormalize(normalizedMessage, outboundExchange, meta, this.mSoapMessageFactory, true);
        }
        catch (MessagingException t) {
            throw t;
        }
        finally {
            if (denormalizationMeasurement != null) {
                denormalizationMeasurement.end();
            }
        }
        soapMsg.saveChanges();
        if (mLog.isLoggable(Level.FINE)) {
            DebugLog.debugLog(mLog, Level.FINE, "Sending SOAP envelope", (Element)soapMsg.getSOAPPart().getEnvelope());
        }
        Probe createDispatchMeasurement = Probe.fine(this.getClass(), (String)endpointMeta.getUniqueName(), (String)"createDispatch");
        Transaction transaction = (Transaction)outboundExchange.getProperty("javax.jbi.transaction.jta");
        boolean txResumed = false;
        if (transaction != null) {
            if (mLog.isLoggable(Level.FINE)) {
                mLog.log(Level.FINE, "Got transaction context from message exchange " + outboundExchange.getExchangeId() + ". About to resume transaction before the Dispatch call...");
            }
            txResumed = TransactionsUtil.resumeTransaction(transaction);
        }
        try {
            Dispatch<SOAPMessage> dispatch = endpointMeta.createDispatch(meta.getSoapActionURL());
            Map requestContext = dispatch.getRequestContext();
            this.putBasicAuthCredential(requestContext, endpointMeta);
            if (this.mIsHeaderCopyEnabled) {
                this.setupHTTPHeaders(requestContext, normalizedMessage);
            }
            if (createDispatchMeasurement != null) {
                createDispatchMeasurement.end();
            }
            if (this.mDCReceiveToSoapCallMeasurement != null) {
                this.mDCReceiveToSoapCallMeasurement.end();
            }
            SOAPMessage replySoapMsg = null;
            Probe callDispatchMeasurement = Probe.fine(this.getClass(), (String)endpointMeta.getUniqueName(), (String)"invokeDispatch");
            if (outboundExchange instanceof InOnly) {
                dispatch.invokeOneWay((Object)soapMsg);
            } else {
                replySoapMsg = (SOAPMessage)dispatch.invoke((Object)soapMsg);
            }
            if (callDispatchMeasurement != null) {
                callDispatchMeasurement.end();
            }
            if (replySoapMsg != null && mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "Reply received", (Element)replySoapMsg.getSOAPPart().getEnvelope());
            }
            SOAPMessage sOAPMessage = replySoapMsg;
            return sOAPMessage;
        }
        finally {
            if (txResumed) {
                if (mLog.isLoggable(Level.FINE)) {
                    mLog.log(Level.FINE, "Transction was resumed before the Dispatch call. Successfully received a SOAP response. About to suspend the transaction before sending the reply in the message exchange...");
                }
                TransactionsUtil.suspendTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(HttpSoapEndpoint endpoint, InOut inout, OperationMetaData opmetadata) throws Exception {
        SOAPMessage response = null;
        SOAPFault soapFault = null;
        try {
            response = this.outboundCall(inout.getInMessage(), opmetadata, endpoint, (MessageExchange)inout);
        }
        catch (MessagingException e) {
            this.setErrorClientException((MessageExchange)inout, (Exception)((Object)e), null);
            throw e;
        }
        catch (SOAPException e) {
            this.setErrorClientException((MessageExchange)inout, (Exception)((Object)e), null);
            throw e;
        }
        catch (SOAPFaultException e) {
            mLog.log(Level.FINE, "A fault occured, possibly a specified service fault.", e);
            soapFault = e.getFault();
        }
        if (response == null && soapFault == null && mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "SOAP response is null");
        }
        if (response != null) {
            SOAPBody responseSoapBody;
            if (mLog.isLoggable(Level.FINE)) {
                DebugLog.debugLog(mLog, Level.FINE, "SOAP response", (Element)response.getSOAPPart().getEnvelope());
            }
            if ((responseSoapBody = response.getSOAPBody()).hasFault()) {
                soapFault = responseSoapBody.getFault();
            } else {
                Probe normalizationMeasurement = Probe.info(this.getClass(), (String)endpoint.getUniqueName(), (String)"Normalization");
                NormalizedMessage inMsg = null;
                try {
                    inMsg = this.mNormalizer.normalize(response, (MessageExchange)inout, opmetadata, false, null);
                }
                catch (MessagingException t) {
                    throw t;
                }
                finally {
                    if (normalizationMeasurement != null) {
                        normalizationMeasurement.end();
                    }
                }
                inout.setOutMessage(inMsg);
            }
        }
        if (soapFault != null) {
            Probe normalizationMeasurement = Probe.info(this.getClass(), (String)endpoint.getUniqueName(), (String)"Normalization");
            Fault fault = null;
            try {
                fault = this.mNormalizer.normalizeFault(soapFault, (MessageExchange)inout, opmetadata, true);
            }
            finally {
                if (normalizationMeasurement != null) {
                    normalizationMeasurement.end();
                }
            }
            if (fault != null) {
                inout.setFault(fault);
            } else {
                String msg = mMessages.getString("HTTPBC-W00759.Reply_fault_unexpected_or_empty", (Object)inout.getOperation().toString());
                MessagingException e = new MessagingException(msg);
                this.setErrorServerException((MessageExchange)inout, (Exception)((Object)e), soapFault);
                throw e;
            }
        }
    }

    private List extractPartsValueList(InOut inout, OperationMetaData opmetadata, boolean stringify) throws Exception {
        List partNameList = opmetadata.getCachedInputPartNameList();
        ArrayList partValueList = new ArrayList();
        if (!partNameList.isEmpty()) {
            NormalizedMessage request = inout.getInMessage();
            Document doc = (Document)Util.messageAsDom(request);
            Element rootNode = doc.getDocumentElement();
            if (mLog.isLoggable(Level.FINE)) {
                mLog.log(Level.FINE, "Request: " + Util.toXml(rootNode, URL_DECODE_ENCODING, false));
            }
            partValueList.addAll(this.createPartValueList(doc, opmetadata.getInputMessage(), stringify));
        }
        return partValueList;
    }

    private String composeGetQueryString(String urlContext, String urlEncoding, String httpOperationLocation, List partNameList, List partValueList) throws Exception {
        StringBuffer buffer = new StringBuffer();
        if ("urlEncoded".equals(urlEncoding)) {
            for (int i = 0; i < partNameList.size(); ++i) {
                String n = (String)partNameList.get(i);
                buffer.append(URLEncoder.encode(n, URL_DECODE_ENCODING) + "=");
                String v = (String)partValueList.get(i);
                buffer.append(URLEncoder.encode(v, URL_DECODE_ENCODING));
                if (i == partNameList.size() - 1) continue;
                buffer.append("&");
            }
        } else if ("urlReplacement".equals(urlEncoding)) {
            String tempLocation = httpOperationLocation;
            for (int i = 0; i < partNameList.size(); ++i) {
                String n = "(" + (String)partNameList.get(i) + ")";
                String v = (String)partValueList.get(i);
                tempLocation = StringUtil.replaceAll(tempLocation, n, v);
            }
            buffer.append(this.mergePath(new String[]{urlContext, tempLocation}));
        } else {
            throw new Exception(mMessages.getString("HTTPBC-E00747.Invalid_WSDL_HTTP_URL_encoding", (Object)urlEncoding));
        }
        return buffer.toString();
    }

    private void dispatchHttpGet(HttpEndpoint endpoint, String queryString, InOut inout, OperationMetaData opmetadata) throws Exception {
        block12: {
            String httpAddressLocation = endpoint.getEndpointUrl().toString();
            String httpBindingVerb = endpoint.getHttpBindingVerb();
            String httpOperationLocation = opmetadata.getHttpOperationLocation();
            String httpUrlEncoding = opmetadata.getHttpUrlEncoding();
            Service service = Service.create((QName)endpoint.getServiceName());
            QName portQName = new QName(endpoint.getServiceName().getNamespaceURI(), endpoint.getEndpointName());
            String url = this.mergePath(new String[]{httpAddressLocation, httpOperationLocation});
            service.addPort(portQName, "http://www.w3.org/2004/08/wsdl/http", url);
            Dispatch dispatch = service.createDispatch(portQName, Source.class, Service.Mode.MESSAGE);
            Map requestContext = dispatch.getRequestContext();
            requestContext.put("javax.xml.ws.http.request.method", httpBindingVerb);
            this.putBasicAuthCredential(requestContext, endpoint);
            if ("urlEncoded".equals(httpUrlEncoding)) {
                requestContext.put("javax.xml.ws.http.request.querystring", queryString);
            } else if ("urlReplacement".equals(httpUrlEncoding)) {
                requestContext.put("javax.xml.ws.http.request.pathinfo", queryString);
            } else {
                throw new Exception(mMessages.getString("HTTPBC-E00747.Invalid_WSDL_HTTP_URL_encoding", (Object)httpUrlEncoding));
            }
            try {
                Source response = (Source)dispatch.invoke(null);
                if (response == null) break block12;
                Probe normalizationMeasurement = Probe.info(this.getClass(), (String)endpoint.getUniqueName(), (String)"Normalization");
                NormalizedMessage outMsg = null;
                try {
                    outMsg = this.mHttpNormalizer.normalize(response, (MessageExchange)inout, opmetadata, false);
                }
                catch (MessagingException t) {
                    throw t;
                }
                finally {
                    if (normalizationMeasurement != null) {
                        normalizationMeasurement.end();
                    }
                }
                inout.setOutMessage(outMsg);
            }
            catch (Exception e) {
                String msg = mMessages.getString("HTTPBC-E00753.Message_dispatch_failed", new Object[]{httpBindingVerb, url, "urlEncoded".equals(httpUrlEncoding) ? queryString : "", "urlReplacement".equals(httpUrlEncoding) ? queryString : "", portQName.toString(), e.getLocalizedMessage()});
                throw new Exception(msg, e);
            }
        }
    }

    private void dispatchHttpPost(HttpEndpoint endpoint, Object payload, InOut inout, OperationMetaData opmetadata) throws Exception {
        block15: {
            String httpAddressLocation = endpoint.getEndpointUrl().toString();
            String httpBindingVerb = endpoint.getHttpBindingVerb();
            String httpOperationLocation = opmetadata.getHttpOperationLocation();
            String httpUrlEncoding = opmetadata.getHttpUrlEncoding();
            Service service = Service.create((QName)endpoint.getServiceName());
            QName portQName = new QName(endpoint.getServiceName().getNamespaceURI(), endpoint.getEndpointName());
            String url = this.mergePath(new String[]{httpAddressLocation, httpOperationLocation});
            service.addPort(portQName, "http://www.w3.org/2004/08/wsdl/http", url);
            try {
                if (payload instanceof Node) {
                    Dispatch dispatch = service.createDispatch(portQName, Source.class, Service.Mode.MESSAGE);
                    Map requestContext = dispatch.getRequestContext();
                    requestContext.put("javax.xml.ws.http.request.method", httpBindingVerb);
                    this.putBasicAuthCredential(requestContext, endpoint);
                    DOMSource request = new DOMSource((Node)payload);
                    Source response = (Source)dispatch.invoke((Object)request);
                    if (response == null) break block15;
                    Probe normalizationMeasurement = Probe.info(this.getClass(), (String)endpoint.getUniqueName(), (String)"Normalization");
                    NormalizedMessage outMsg = null;
                    try {
                        outMsg = this.mHttpNormalizer.normalize(response, (MessageExchange)inout, opmetadata, false);
                    }
                    catch (MessagingException t) {
                        throw t;
                    }
                    finally {
                        if (normalizationMeasurement != null) {
                            normalizationMeasurement.end();
                        }
                    }
                    inout.setOutMessage(outMsg);
                    break block15;
                }
                Dispatch dispatch = service.createDispatch(portQName, DataSource.class, Service.Mode.MESSAGE);
                Map requestContext = dispatch.getRequestContext();
                requestContext.put("javax.xml.ws.http.request.method", httpBindingVerb);
                this.putBasicAuthCredential(requestContext, endpoint);
                StringDataSourceImpl request = new StringDataSourceImpl(opmetadata.getInputMessage().getQName(), payload.toString());
                DataSource response = (DataSource)dispatch.invoke((Object)request);
                if (response == null) break block15;
                Probe normalizationMeasurement = Probe.info(this.getClass(), (String)endpoint.getUniqueName(), (String)"Normalization");
                NormalizedMessage outMsg = null;
                try {
                    outMsg = this.mHttpNormalizer.normalize(response, (MessageExchange)inout, opmetadata, false);
                }
                catch (MessagingException t) {
                    throw t;
                }
                finally {
                    if (normalizationMeasurement != null) {
                        normalizationMeasurement.end();
                    }
                }
                inout.setOutMessage(outMsg);
            }
            catch (Exception e) {
                String msg = mMessages.getString("HTTPBC-E00753.Message_dispatch_failed", new Object[]{httpBindingVerb, url, "", "", portQName.toString(), e.getLocalizedMessage()});
                throw new Exception(msg, e);
            }
        }
    }

    private void dispatch(HttpEndpoint endpoint, InOut inout, OperationMetaData opmetadata) throws Exception {
        String httpBindingVerb = endpoint.getHttpBindingVerb();
        String httpUrlEncoding = opmetadata.getHttpUrlEncoding();
        String httpOperationLocation = opmetadata.getHttpOperationLocation();
        if ("GET".equals(httpBindingVerb)) {
            List partValueList = this.extractPartsValueList(inout, opmetadata, true);
            List partNameList = opmetadata.getCachedInputPartNameList();
            if (partValueList.size() < partNameList.size()) {
                String errMsg;
                if (mLog.isLoggable(Level.FINE)) {
                    NormalizedMessage request = inout.getInMessage();
                    Document doc = (Document)Util.messageAsDom(request);
                    Element rootNode = doc.getDocumentElement();
                    errMsg = mMessages.getString("HTTPBC-E00781.Bad_content_detail", (Object)Util.toXml(rootNode, URL_DECODE_ENCODING, false));
                } else {
                    errMsg = mMessages.getString("HTTPBC-E00781.Bad_content");
                }
                Exception ex = new Exception(errMsg);
                this.setErrorClientException((MessageExchange)inout, ex, null);
                throw ex;
            }
            String queryString = this.composeGetQueryString(endpoint.getUrlContext(), httpUrlEncoding, httpOperationLocation, partNameList, partValueList);
            this.dispatchHttpGet(endpoint, queryString, inout, opmetadata);
        } else if ("POST".equals(httpBindingVerb)) {
            Node msgNode;
            List partValueList = this.extractPartsValueList(inout, opmetadata, false);
            if (partValueList.size() > 1 || partValueList.size() == 0) {
                NormalizedMessage request = inout.getInMessage();
                Document doc = (Document)Util.messageAsDom(request);
                Element rootNode = doc.getDocumentElement();
                String errMsg = partValueList.size() > 1 ? mMessages.getString("HTTPBC-E00782.Multipart_POST_Unsupported_detail", (Object)Util.toXml(rootNode, URL_DECODE_ENCODING, false)) : mMessages.getString("HTTPBC-E00781.Bad_content_detail", (Object)Util.toXml(rootNode, URL_DECODE_ENCODING, false));
                Exception ex = new Exception(errMsg);
                this.setErrorClientException((MessageExchange)inout, ex, null);
                throw ex;
            }
            Object value = partValueList.get(0);
            Node node = value instanceof String ? Util.textAsDom((String)value) : (msgNode = value instanceof Document ? ((Document)value).getDocumentElement() : null);
            if (msgNode == null && !(value instanceof String)) {
                NormalizedMessage request = inout.getInMessage();
                Document doc = (Document)Util.messageAsDom(request);
                Element rootNode = doc.getDocumentElement();
                String errMsg = mMessages.getString("HTTPBC-E00781.Bad_content_detail", (Object)Util.toXml(rootNode, URL_DECODE_ENCODING, false));
                Exception ex = new Exception(errMsg);
                this.setErrorClientException((MessageExchange)inout, ex, null);
                throw ex;
            }
            this.dispatchHttpPost(endpoint, msgNode != null ? msgNode : value, inout, opmetadata);
        } else {
            throw new Exception(mMessages.getString("HTTPBC-E00749.Invalid_HTTP_verb", (Object)httpBindingVerb));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List createPartValueList(Document normalizedMsg, Message msgDef, boolean stringify) throws WrapperProcessingException, TransformerException, UnsupportedEncodingException {
        ArrayList<Object> partValueList = new ArrayList<Object>();
        WrapperParser parser = null;
        Transformer transformer = null;
        try {
            parser = HelperFactory.createParser();
            parser.parse(normalizedMsg, msgDef);
            transformer = cTransformerPool.retrieve();
            String[] partNames = parser.getPartNames();
            for (int i = 0; i < partNames.length; ++i) {
                Node node;
                int n;
                int N;
                NodeList nodeList;
                String partName = partNames[i];
                if (this.isSimpleMessagePart(msgDef, partName)) {
                    StringBuffer contentBuffer = new StringBuffer();
                    nodeList = parser.getPartNodes(partName);
                    N = nodeList.getLength();
                    for (n = 0; n < N; ++n) {
                        node = nodeList.item(n);
                        contentBuffer.append(node.getTextContent());
                    }
                    partValueList.add(contentBuffer.toString());
                    contentBuffer.delete(0, contentBuffer.length());
                    continue;
                }
                Document document = this.mBuilder.newDocument();
                nodeList = parser.getPartNodes(partNames[i]);
                N = nodeList.getLength();
                for (n = 0; n < N; ++n) {
                    node = nodeList.item(n);
                    if (node == null) continue;
                    this.copyNode(document, node);
                }
                if (stringify) {
                    StringWriter writer = new StringWriter();
                    StreamResult dest = new StreamResult(writer);
                    DOMSource source = new DOMSource(document);
                    transformer.transform(source, dest);
                    writer.flush();
                    partValueList.add(writer.toString());
                    continue;
                }
                partValueList.add(document);
            }
            cTransformerPool.relinquish(transformer);
        }
        catch (Throwable throwable) {
            cTransformerPool.relinquish(transformer);
            throw throwable;
        }
        return partValueList;
    }

    private boolean isSimpleMessagePart(Message msgDef, String partName) {
        Part p = msgDef.getPart(partName);
        boolean isSimple = p.getElementName() == null && WSDLUtilities.isBuiltInType(p.getTypeName().getNamespaceURI());
        return isSimple;
    }

    private void setErrorUnsupportedExchangePattern(MessageExchange exchange, String msg, String detail) throws MessagingException {
        if (exchange.getStatus() != ExchangeStatus.ERROR) {
            if (detail == null) {
                detail = "";
            }
            IllegalArgumentException ex = new IllegalArgumentException(msg);
            exchange.setError((Exception)ex);
            exchange.setStatus(ExchangeStatus.ERROR);
            exchange.setProperty("com.sun.jbi.crl.faultcode", (Object)"VersionMismatch");
            exchange.setProperty("com.sun.jbi.crl.faultstring", (Object)msg);
            exchange.setProperty("com.sun.jbi.crl.faultactor", (Object)"sun-http-binding");
            exchange.setProperty("com.sun.jbi.crl.faultdetail", (Object)detail);
        }
    }

    private void setErrorServerException(MessageExchange exchange, Exception ex, String detail) throws MessagingException {
        if (exchange.getStatus() != ExchangeStatus.ERROR) {
            if (detail == null) {
                detail = "";
            }
            exchange.setError(ex);
            exchange.setStatus(ExchangeStatus.ERROR);
            exchange.setProperty("com.sun.jbi.crl.faultcode", (Object)"Server");
            exchange.setProperty("com.sun.jbi.crl.faultstring", (Object)ex.getLocalizedMessage());
            exchange.setProperty("com.sun.jbi.crl.faultactor", (Object)"sun-http-binding");
            exchange.setProperty("com.sun.jbi.crl.faultdetail", (Object)detail);
        }
    }

    private void setErrorServerException(MessageExchange exchange, Exception ex, SOAPFault fault) throws MessagingException {
        if (exchange.getStatus() != ExchangeStatus.ERROR) {
            String faultActor;
            String faultString;
            String faultCode = fault.getFaultCode();
            if (faultCode == null) {
                faultCode = "Server";
            }
            if ((faultString = fault.getFaultString()) == null) {
                faultString = "";
            }
            try {
                faultActor = fault.getFaultActor();
                if (faultActor == null) {
                    faultActor = "";
                }
            }
            catch (UnsupportedOperationException e) {
                faultActor = "";
            }
            StringBuffer faultDetail = new StringBuffer();
            Detail details = fault.getDetail();
            if (details != null) {
                Iterator detailsIteration = details.getDetailEntries();
                while (detailsIteration.hasNext()) {
                    DetailEntry detailEntry = (DetailEntry)detailsIteration.next();
                    try {
                        faultDetail.append(Util.toXml((Node)detailEntry, URL_DECODE_ENCODING, true));
                    }
                    catch (Exception e) {
                        if (faultDetail.length() == 0) {
                            faultDetail.append(faultString);
                        }
                        break;
                    }
                }
            } else {
                faultDetail.append(faultString);
            }
            exchange.setError(ex);
            exchange.setStatus(ExchangeStatus.ERROR);
            exchange.setProperty("com.sun.jbi.crl.faultcode", (Object)faultCode);
            exchange.setProperty("com.sun.jbi.crl.faultstring", (Object)faultString);
            exchange.setProperty("com.sun.jbi.crl.faultactor", (Object)faultActor);
            exchange.setProperty("com.sun.jbi.crl.faultdetail", (Object)faultDetail.toString());
        }
    }

    private void setErrorClientException(MessageExchange exchange, Exception ex, String detail) throws MessagingException {
        if (exchange.getStatus() != ExchangeStatus.ERROR) {
            if (detail == null) {
                detail = "";
            }
            exchange.setError(ex);
            exchange.setStatus(ExchangeStatus.ERROR);
            exchange.setProperty("com.sun.jbi.crl.faultcode", (Object)"Client");
            exchange.setProperty("com.sun.jbi.crl.faultstring", (Object)ex.getLocalizedMessage());
            exchange.setProperty("com.sun.jbi.crl.faultactor", (Object)"sun-http-binding");
            exchange.setProperty("com.sun.jbi.crl.faultdetail", (Object)detail);
        }
    }

    private void copyNode(Document document, Node node) {
        node = document.importNode(node, true);
        document.appendChild(node);
        NamedNodeMap attrs = node.getAttributes();
        NamedNodeMap destAttrs = document.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                Node n = document.importNode(attr, true);
                if (destAttrs == null) continue;
                destAttrs.setNamedItemNS(n);
            }
        }
    }

    private void updateTallyReceivedReplies(Endpoint e) {
        EndpointStatus status;
        if (e != null && (status = e.getEndpointStatus()) != null) {
            status.incrementReceivedReplies();
        }
    }

    private void updateTallyReceivedRequests(Endpoint e) {
        EndpointStatus status;
        if (e != null && (status = e.getEndpointStatus()) != null) {
            status.incrementReceivedRequests();
        }
    }

    private void updateTallySentReplies(Endpoint e) {
        EndpointStatus status;
        if (e != null && (status = e.getEndpointStatus()) != null) {
            status.incrementSentReplies();
        }
    }

    private void updateTallySentRequests(Endpoint e) {
        EndpointStatus status;
        if (e != null && (status = e.getEndpointStatus()) != null) {
            status.incrementSentRequests();
        }
    }

    private void updateTallyReceives(Endpoint e, boolean successfulReceive) {
        EndpointStatus status;
        if (e != null && (status = e.getEndpointStatus()) != null) {
            if (successfulReceive) {
                status.incrementReceivedDones();
            } else {
                status.incrementReceivedErrors();
            }
        }
    }

    private void updateTallySends(Endpoint e, boolean successfulSend) {
        EndpointStatus status;
        if (e != null && (status = e.getEndpointStatus()) != null) {
            if (successfulSend) {
                status.incrementSentDones();
            } else {
                status.incrementSentErrors();
            }
        }
    }

    private String mergePath(String[] segments) {
        StringBuffer pathBuffer = new StringBuffer();
        StringBuffer segBuffer = new StringBuffer();
        for (String seg : segments) {
            if (seg == null) continue;
            segBuffer.append(seg);
            while (segBuffer.length() > 0 && segBuffer.charAt(0) == '/') {
                segBuffer.deleteCharAt(0);
            }
            while (segBuffer.length() > 0 && segBuffer.charAt(segBuffer.length() - 1) == '/') {
                segBuffer.deleteCharAt(segBuffer.length() - 1);
            }
            pathBuffer.append(segBuffer).append("/");
            segBuffer.delete(0, segBuffer.length());
        }
        return pathBuffer.substring(0, pathBuffer.length() - 1);
    }

    private void putBasicAuthCredential(Map<String, Object> requestContext, Endpoint endpoint) {
        if (endpoint.getBasicAuthCredential() != null) {
            if (endpoint.getBasicAuthCredential().getName() != null) {
                requestContext.put("javax.xml.ws.security.auth.username", endpoint.getBasicAuthCredential().getName());
            }
            if (endpoint.getBasicAuthCredential().getPassword() != null) {
                requestContext.put("javax.xml.ws.security.auth.password", new String(endpoint.getBasicAuthCredential().getPassword()));
            }
        }
    }

    private void setupHTTPHeaders(Map<String, Object> requestContext, NormalizedMessage normalizedMessage) {
        Map httpHeaderProperty = (Map)normalizedMessage.getProperty("com.sun.jbi.headers.http");
        HashMap headers = new HashMap();
        if (httpHeaderProperty != null) {
            for (Map.Entry entry : httpHeaderProperty.entrySet()) {
                headers.put(entry.getKey(), Collections.singletonList(entry.getValue()));
            }
        }
        requestContext.put("javax.xml.ws.http.request.headers", headers);
    }

    private boolean isRedeliveryConfigured(MessageExchange exchange) {
        RedeliveryStatus redeliveryStatus = Redelivery.getRedeliveryStatus((MessageExchange)exchange);
        return redeliveryStatus != null;
    }

    private void handleRedelivery(MessageExchange exchange, Endpoint epb) {
        block2: {
            try {
                MessageExchangeSupport.notifyOfRedelivery(exchange);
            }
            catch (Exception e) {
                String groupId = (String)exchange.getProperty("com.sun.jbi.messaging.groupid");
                String messageId = (String)exchange.getProperty("com.sun.jbi.messaging.messageid");
                if (!mLog.isLoggable(Level.WARNING)) break block2;
                String text = mMessages.getString("HTTPBC-E01036.Failed_to_process_redelivery", new Object[]{groupId, messageId});
                mLog.log(Level.WARNING, text, e);
                AlertsUtil.getAlerter().warning(text, "sun-http-binding", epb.getServiceUnitID(), AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E01036");
            }
        }
    }

    private void setTransactionRollbackOnly(Transaction transaction) {
        boolean txResumed = false;
        if (transaction != null) {
            txResumed = TransactionsUtil.resumeTransaction(transaction);
        }
        if (txResumed) {
            TransactionsUtil.setRollbackOnlyOnTransaction(transaction);
            try {
                TransactionsUtil.suspendTransaction();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
    }
}

