/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.bridge;

import com.sun.enterprise.jbi.serviceengine.bridge.EndpointHelper;
import com.sun.enterprise.jbi.serviceengine.bridge.JAXRPCMessageProcessor;
import com.sun.enterprise.jbi.serviceengine.bridge.JAXWSMessageProcessor;
import com.sun.enterprise.jbi.serviceengine.bridge.ServiceEngineFacadeImpl;
import com.sun.enterprise.jbi.serviceengine.comm.MessageProcessor;
import com.sun.enterprise.jbi.serviceengine.core.Bridge;
import com.sun.enterprise.jbi.serviceengine.core.DescriptorEndpointInfo;
import com.sun.enterprise.jbi.serviceengine.core.EndpointRegistry;
import com.sun.enterprise.jbi.serviceengine.core.ServiceEngineEndpoint;
import com.sun.enterprise.webservice.ServiceEngineFacade;
import com.sun.enterprise.webservice.ServiceEngineRtObjectFactory;
import com.sun.enterprise.webservice.ServiceEngineUtil;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;

public class AppServerBridge
implements Bridge {
    public void initialize() {
        ServiceEngineRtObjectFactory.getInstance().setFacade((ServiceEngineFacade)ServiceEngineFacadeImpl.getInstance());
        EndpointHelper.getInstance().initialize();
        EndpointRegistry registry = EndpointRegistry.getInstance();
        ServiceEngineUtil.getListener().mergeEndpointRegistry(registry.getWSEndpoints());
    }

    public MessageProcessor getMessageProcessor(MessageExchange me) {
        QName jbiServiceName = me.getEndpoint().getServiceName();
        String jbiEndpointName = me.getEndpoint().getEndpointName();
        String key = DescriptorEndpointInfo.getDEIKey(jbiServiceName, jbiEndpointName);
        DescriptorEndpointInfo dei = EndpointRegistry.getInstance().getWSDLEndpts().get(key);
        QName actualServiceName = dei != null ? dei.getServiceName() : jbiServiceName;
        String actualEndpointName = dei != null ? dei.getEndpointName() : jbiEndpointName;
        ServiceEngineEndpoint seEndpoint = EndpointRegistry.getInstance().get(actualServiceName, actualEndpointName);
        if (seEndpoint.isJAXWSEndpoint()) {
            return new JAXWSMessageProcessor();
        }
        return new JAXRPCMessageProcessor();
    }

    public void destroy() {
        EndpointHelper.getInstance().destroy();
    }
}

