/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.util;

import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class DocumentBuilderPool {
    private static final DocumentBuilderFactory mBuilderFactory = DocumentBuilderFactory.newInstance();
    private final LinkedList<DocumentBuilder> mDocumentBuilders;

    public DocumentBuilderPool() {
        mBuilderFactory.setNamespaceAware(true);
        this.mDocumentBuilders = new LinkedList();
    }

    public DocumentBuilderPool(int size) throws ParserConfigurationException {
        this();
        for (int i = 0; i < size; ++i) {
            this.mDocumentBuilders.addFirst(mBuilderFactory.newDocumentBuilder());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentBuilder retrieve() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderPool documentBuilderPool = this;
        synchronized (documentBuilderPool) {
            documentBuilder = !this.mDocumentBuilders.isEmpty() ? this.mDocumentBuilders.removeFirst() : mBuilderFactory.newDocumentBuilder();
        }
        return documentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean relinquish(DocumentBuilder documentBuilder) {
        boolean success = false;
        if (documentBuilder != null) {
            DocumentBuilderPool documentBuilderPool = this;
            synchronized (documentBuilderPool) {
                if (!this.mDocumentBuilders.contains(documentBuilder)) {
                    this.mDocumentBuilders.addFirst(documentBuilder);
                    success = true;
                }
            }
        }
        return success;
    }
}

