/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.qos.config;

import com.sun.jbi.common.descriptor.model.Identification;
import com.sun.jbi.common.descriptor.parsers.IdentificationParser;
import com.sun.jbi.common.qos.I18n;
import com.sun.jbi.common.qos.config.AbstractConfig;
import com.sun.jbi.common.qos.config.AppConfig;
import com.sun.jbi.common.qos.config.AppVar;
import com.sun.jbi.common.qos.config.ConfigParser;
import com.sun.jbi.common.qos.config.Property;
import com.sun.jbi.common.util.Util;
import com.sun.jbi.common.xml.StackableParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.management.DeploymentException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentConfig
extends AbstractConfig {
    public static final String CONFIG_NS = "http://www.sun.com/jbi/Configuration/V1.0";
    public static final String CONFIGURATION_ELEM = "Configuration";
    public static final String PROPERTY_ELEM = "Property";
    public static final String PROPERTY_GROUP_ELEM = "PropertyGroup";
    public static final String CONSTRAINT_ELEM = "Constraint";
    public static final String APPL_CONFIG_ELEM = "ApplicationConfiguration";
    public static final String APPL_VARS_ELEM = "ApplicationVariable";
    public static final String DEFAULT_VALUE_ATTR = "defaultValue";
    public static final String MAX_OCCURS_ATTR = "maxOccurs";
    public static final String REQUIRED_ATTR = "required";
    public static final String TYPE_ATTR = "type";
    public static final String NAME_ATTR = "name";
    public static final String FACET_ATTR = "facet";
    public static final String VALUE_ATTR = "value";
    private static SAXParserFactory mFactory = SAXParserFactory.newInstance();
    private static Logger mLogger = Logger.getLogger(ComponentConfig.class.getName());
    private Identification mId;
    private Property[] mConfigMetadata;
    private Map<String, AppConfig> mAppConfig;
    private Map<String, AppVar> mAppVars;

    ComponentConfig() {
    }

    @Override
    public String getName() {
        return this.mId.getName();
    }

    void setId(Identification id) {
        this.mId = id;
    }

    public Iterator<String> appConfigNames() {
        this.checkAppConfigSupport();
        return this.mAppConfig.keySet().iterator();
    }

    public Iterator<String> appVarNames() {
        this.checkAppVarSupport();
        return this.mAppVars.keySet().iterator();
    }

    public AppConfig getAppConfig(String name) {
        this.checkAppConfigSupport();
        return this.mAppConfig.get(name);
    }

    public Property[] getAppConfigDefs() {
        if (this.mConfigMetadata == null || this.mConfigMetadata.length == 0) {
            return new Property[0];
        }
        int len = this.mConfigMetadata.length;
        Property[] copy = new Property[len];
        System.arraycopy(this.mConfigMetadata, 0, copy, 0, len);
        return copy;
    }

    public AppVar getAppVar(String name) {
        this.checkAppVarSupport();
        return this.mAppVars.get(name);
    }

    public void putAppConfig(AppConfig config) {
        this.checkAppConfigSupport();
        if (config != null) {
            this.mAppConfig.put(config.getName(), config);
        }
    }

    public void putAppVar(AppVar var) {
        this.checkAppVarSupport();
        if (var != null) {
            this.mAppVars.put(var.getName(), var);
        }
    }

    public boolean supportsAppConfigs() {
        return this.mAppConfig != null;
    }

    public boolean supportsAppVars() {
        return this.mAppVars != null;
    }

    void initializeAppConfig(Property[] metadata) {
        this.mAppConfig = new TreeMap<String, AppConfig>();
        this.mConfigMetadata = metadata;
    }

    void initializeAppVars() {
        this.mAppVars = new TreeMap<String, AppVar>();
    }

    private void checkAppConfigSupport() {
        if (this.mAppConfig == null) {
            throw new UnsupportedOperationException(I18n.loc("QOS-6057: {0} does not support Application Configurations!", this.getName()));
        }
    }

    private void checkAppVarSupport() {
        if (this.mAppVars == null) {
            throw new UnsupportedOperationException(I18n.loc("QOS-6011: {0} does not support Application Variables!", this.getName()));
        }
    }

    public AppConfig removeAppConfig(String name) {
        return name == null ? null : this.mAppConfig.remove(name);
    }

    public AppVar removeAppVar(String name) {
        this.checkAppVarSupport();
        return name == null ? null : this.mAppVars.remove(name);
    }

    String bld(String ... str) {
        StringBuffer buff = new StringBuffer();
        buff.append(str[0]);
        int n = str.length;
        for (int i = 1; i < n; ++i) {
            buff.append(".").append(str[i]);
        }
        return buff.toString();
    }

    public static ComponentConfig parse(String installRoot) throws DeploymentException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(new File(new File(installRoot, "META-INF"), "jbi.xml"));
            ComponentConfig componentConfig = ComponentConfig.parse(new InputSource(stream));
            return componentConfig;
        }
        catch (FileNotFoundException fnfe) {
            throw new DeploymentException(I18n.loc("QOS-6012: Component's JBI descriptor not found: ", fnfe.getMessage()), (Throwable)fnfe);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static ComponentConfig parse(InputSource source) throws DeploymentException {
        try {
            StackableParser root = StackableParser.createRootParser();
            ConfigParser qosParser = new ConfigParser();
            root.declareStackableParser((StackableParser)qosParser, CONFIG_NS, new String[]{CONFIGURATION_ELEM, PROPERTY_ELEM, PROPERTY_GROUP_ELEM, APPL_CONFIG_ELEM, APPL_VARS_ELEM});
            IdentificationParser idParser = new IdentificationParser();
            root.declareStackableParser((StackableParser)idParser, "http://java.sun.com/xml/ns/jbi", new String[]{"identification", NAME_ATTR, "description"});
            SAXParser parser = mFactory.newSAXParser();
            parser.parse(source, (DefaultHandler)root);
            qosParser.getConfig().setId(idParser.getIdentification());
            return qosParser.getConfig();
        }
        catch (ParserConfigurationException pce) {
            throw ComponentConfig.error(I18n.loc("QOS-6013: Failed to obtain SAX parser for component configuration: {0}", pce.getMessage()), pce);
        }
        catch (SAXException se) {
            throw ComponentConfig.error(I18n.loc("QOS-6014: Failed to parse component configuration: {0}", se.getMessage()), se);
        }
        catch (IOException ioe) {
            throw ComponentConfig.error(I18n.loc("QOS-6015: Unexpected I/O error parsing component configuration: {0}", ioe.getMessage()), ioe);
        }
    }

    public static Integer toInteger(String str, Integer defaultValue) {
        try {
            return Util.isEmpty((String)str) ? defaultValue : Integer.valueOf(str);
        }
        catch (Exception e) {
            mLogger.fine(I18n.loc("QOS-3001: Failed to parse Integer: {0}", str));
            return defaultValue;
        }
    }

    private static DeploymentException error(String message, Exception thrown) {
        if (thrown == null) {
            mLogger.warning(message);
            return new DeploymentException(message);
        }
        mLogger.log(Level.WARNING, message, thrown);
        return new DeploymentException(message, (Throwable)thrown);
    }
}

