/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.message;

import com.sun.jbi.management.message.JBIMessageElement;
import com.sun.jbi.management.message.JBIMessageException;
import com.sun.jbi.management.message.MessageLocalizationInfo;
import com.sun.jbi.util.JBIUtils;
import java.util.logging.Logger;

public class ExceptionInfo
extends JBIMessageElement {
    private static final Logger logger = Logger.getLogger(ExceptionInfo.class.getName());
    public static final String ELEMENT_NAME = "exception-info";
    public static final String NESTING_LEVEL_NAME = "nesting-level";
    public static final String STACK_TRACE_NAME = "stack-trace";
    private Throwable throwable;
    private int nestingLevel = -1;
    private MessageLocalizationInfo messageLocalization;

    public ExceptionInfo() {
    }

    public ExceptionInfo(Throwable throwable, MessageLocalizationInfo messageLocalization) throws JBIMessageException {
        this.setException(throwable);
        this.setMessageLocalization(messageLocalization);
    }

    protected String buildString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t\t\t\t\t<");
        buffer.append(ELEMENT_NAME);
        buffer.append(">\n");
        buffer.append("\t\t\t\t\t\t<");
        buffer.append(NESTING_LEVEL_NAME);
        buffer.append(">");
        buffer.append(this.getNestingLevel());
        buffer.append("</");
        buffer.append(NESTING_LEVEL_NAME);
        buffer.append(">\n");
        buffer.append("\t");
        buffer.append(this.messageLocalization.getString());
        buffer.append("\t\t\t\t\t\t<");
        buffer.append(STACK_TRACE_NAME);
        buffer.append(">");
        for (Throwable t = this.throwable; t != null; t = t.getCause()) {
            buffer.append('\n');
            buffer.append(JBIUtils.escape(JBIUtils.stringStackTrace(t)));
        }
        buffer.append("</");
        buffer.append(STACK_TRACE_NAME);
        buffer.append(">\n");
        buffer.append("\t\t\t\t\t</");
        buffer.append(ELEMENT_NAME);
        buffer.append(">\n");
        return buffer.toString();
    }

    public void validate() throws JBIMessageException {
        if (this.throwable == null) {
            logger.warning("Exception not set");
        }
        if (this.messageLocalization == null) {
            logger.warning("Missing message localization");
        }
    }

    public Throwable getException() {
        return this.throwable;
    }

    public void setException(Throwable throwable) throws JBIMessageException {
        if (throwable == null) {
            throw new JBIMessageException("Exception cannot be null");
        }
        this.nestingLevel = -1;
        this.throwable = throwable;
    }

    public int getNestingLevel() {
        if (this.nestingLevel == -1 && this.throwable != null) {
            Throwable t = this.throwable.getCause();
            this.nestingLevel = 0;
            while (t != null) {
                t = t.getCause();
                ++this.nestingLevel;
            }
        }
        return this.nestingLevel;
    }

    public MessageLocalizationInfo getMessageLocalization() {
        if (this.messageLocalization == null) {
            this.messageLocalization = new MessageLocalizationInfo();
        }
        return this.messageLocalization;
    }

    public void setMessageLocalization(MessageLocalizationInfo messageLocalization) throws JBIMessageException {
        if (messageLocalization == null) {
            throw new JBIMessageException("Message localization info cannot be null");
        }
        this.messageLocalization = messageLocalization;
    }
}

