/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class ResourceLocator {
    private URL mLocation;

    public ResourceLocator(int port, String context) throws MalformedURLException {
        String protocol = "http";
        String host = "localhost";
        try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        while (context.indexOf("//") != -1) {
            context = context.replace("//", "/");
        }
        this.mLocation = new URL(protocol, host, port, context);
    }

    public ResourceLocator(int port, String serviceUnitId, String resourceLocation) throws MalformedURLException {
        String protocol = "http";
        String host = "localhost";
        try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        this.mLocation = new URL(protocol, host, port, "/" + serviceUnitId + "/" + resourceLocation);
    }

    public ResourceLocator(String protocol, int port, String serviceUnitId, String resourceLocation) throws MalformedURLException {
        String host = "localhost";
        try {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        this.mLocation = new URL(protocol, host, port, "/" + serviceUnitId + "/" + resourceLocation);
    }

    public URL toURL() {
        return this.mLocation;
    }

    public String toString() {
        return this.mLocation.toString();
    }

    public String getServiceUnitId() {
        String path = this.mLocation.getFile();
        try {
            path = path.substring(1, path.length());
            return path.substring(0, path.indexOf("/"));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getResourceLocation() {
        String path = this.mLocation.getFile();
        try {
            path = path.substring(1, path.length());
            return path.substring(path.indexOf("/") + 1, path.length());
        }
        catch (Exception ex) {
            return null;
        }
    }
}

