/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.wsdlvalidator.impl;

import com.ibm.wsdl.util.xml.QNameUtils;
import com.ibm.wsdl.xml.WSDLReaderImpl;
import com.sun.jbi.wsdlvalidator.ValidatingWSDLReader;
import com.sun.jbi.wsdlvalidator.Validator;
import com.sun.jbi.wsdlvalidator.ValidatorRegistry;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

public class ValidatingWSDLReaderImpl
extends WSDLReaderImpl
implements ValidatingWSDLReader {
    private ValidatorRegistry mValidatorRegistry;

    public ValidatingWSDLReaderImpl() {
    }

    public ValidatingWSDLReaderImpl(EntityResolver resolver) {
        this();
        this.setEntityResolver(resolver);
    }

    public void setValidatorRegistry(ValidatorRegistry validatorRegistry) {
        this.mValidatorRegistry = validatorRegistry;
    }

    public ValidatorRegistry getValidatorRegistry() {
        return this.mValidatorRegistry;
    }

    public Map readWSDL(File currentDir) throws WSDLException {
        HashMap<String, Definition> cumulativeResults = new HashMap<String, Definition>();
        if (currentDir.isFile()) {
            if (currentDir.getName().toLowerCase().endsWith(".wsdl")) {
                Definition def = this.readWSDL(currentDir.getAbsolutePath());
                cumulativeResults.put(currentDir.getName(), def);
                return cumulativeResults;
            }
        } else {
            File[] filesInCurrentDir = currentDir.listFiles();
            for (int ii = 0; ii < filesInCurrentDir.length; ++ii) {
                Map source = this.readWSDL(filesInCurrentDir[ii]);
                if (filesInCurrentDir[ii].isDirectory()) {
                    this.cumulateResults(cumulativeResults, source, filesInCurrentDir[ii].getName());
                    continue;
                }
                this.cumulateResults(cumulativeResults, source, null);
            }
        }
        return cumulativeResults;
    }

    public void cumulateResults(Map orig, Map source, String dir) {
        for (Map.Entry entry : source.entrySet()) {
            String path = (String)entry.getKey();
            if (dir != null) {
                path = dir + File.separator + path;
            }
            orig.put(path, entry.getValue());
        }
    }

    protected ExtensibilityElement parseSchema(Class parentType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        ExtensibilityElement element = super.parseSchema(parentType, el, def, extReg);
        if (this.mValidatorRegistry != null) {
            try {
                QName elementType = QNameUtils.newQName((Node)el);
                Validator validator = this.mValidatorRegistry.queryValidator(parentType, elementType);
                if (validator != null) {
                    validator.validate(element);
                }
            }
            catch (Exception ex) {
                throw new WSDLException("PARSER_ERROR", "Validation error", (Throwable)ex);
            }
        }
        return element;
    }

    protected ExtensibilityElement parseExtensibilityElement(Class parentType, Element el, Definition def) throws WSDLException {
        ExtensibilityElement element = super.parseExtensibilityElement(parentType, el, def);
        if (this.mValidatorRegistry != null) {
            try {
                QName elementType = QNameUtils.newQName((Node)el);
                Validator validator = this.mValidatorRegistry.queryValidator(parentType, elementType);
                if (validator != null) {
                    validator.validate(element);
                }
            }
            catch (Exception ex) {
                throw new WSDLException("PARSER_ERROR", "Validation error", (Throwable)ex);
            }
        }
        return element;
    }
}

