/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.core;

import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.config.ComponentConfiguration;
import com.sun.enterprise.jbi.serviceengine.core.Bridge;
import com.sun.enterprise.jbi.serviceengine.core.EndpointRegistry;
import com.sun.enterprise.jbi.serviceengine.work.WorkManagerImpl;
import com.sun.logging.LogDomains;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;

public class JavaEEServiceEngineContext {
    private ComponentContext jbiContext;
    private EndpointRegistry endpointRegistry;
    private DeliveryChannel seDeliveryChannel;
    private WorkManagerImpl workManager;
    private ComponentConfiguration config;
    private Bridge bridge;
    private static JavaEEServiceEngineContext serviceEngineContext = new JavaEEServiceEngineContext();
    protected static final Logger logger = LogDomains.getLogger((String)"javax.enterprise.system");

    private JavaEEServiceEngineContext() {
    }

    public static JavaEEServiceEngineContext getInstance() {
        return serviceEngineContext;
    }

    public void initialize() throws ServiceEngineException {
        this.endpointRegistry = EndpointRegistry.getInstance();
        this.config = new ComponentConfiguration();
        this.workManager = new WorkManagerImpl(this.config);
        this.bridge = this.config.getBridge();
        this.bridge.initialize();
    }

    public ComponentContext getJBIContext() {
        return this.jbiContext;
    }

    public DeliveryChannel getDeliveryChannel() {
        return this.seDeliveryChannel;
    }

    public WorkManagerImpl getWorkManager() {
        return this.workManager;
    }

    public Bridge getBridge() {
        return this.bridge;
    }

    public void setJBIContext(ComponentContext context) throws MessagingException {
        this.jbiContext = context;
        this.seDeliveryChannel = this.jbiContext.getDeliveryChannel();
        this.debug(Level.FINE, "Delivery Channel is : " + this.seDeliveryChannel);
    }

    public EndpointRegistry getRegistry() {
        return this.endpointRegistry;
    }

    public void activateEndpoints(Iterator endpoints) throws JBIException {
        if (endpoints != null) {
            while (endpoints.hasNext()) {
                ServiceEndpoint endpoint = (ServiceEndpoint)endpoints.next();
                this.jbiContext.activateEndpoint(endpoint.getServiceName(), endpoint.getEndpointName());
            }
        }
    }

    private void debug(Level logLevel, String msgID) {
        logger.log(logLevel, msgID);
    }

    public boolean isSunESB() {
        String ESBRuntimeProp = System.getProperty("com.sun.enterprise.jbi.se.esbruntime");
        return ESBRuntimeProp == null || ESBRuntimeProp.equalsIgnoreCase("sunesb");
    }

    public boolean isServiceMix() {
        String ESBRuntimeProp = System.getProperty("com.sun.enterprise.jbi.se.esbruntime");
        return ESBRuntimeProp != null && ESBRuntimeProp.equalsIgnoreCase("servicemix");
    }
}

