/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.internationalization;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;

public class Messages {
    private static final String MY_BUNDLE_NAME = "com.sun.jbi.internationalization.messages.Bundle";
    private static final String DEFAULT_BUNDLE_NAME = "messages.Bundle";
    private static final Logger logger = Logger.getLogger(Messages.class.getName(), "com.sun.jbi.internationalization.messages.Bundle");
    private static ComponentContext mContext;
    private String mBundleName;
    private ResourceBundle mResourceBundle;

    private Messages(Class clazz, Locale locale) {
        this.mBundleName = Messages.getBundleName(clazz);
        this.mResourceBundle = ResourceBundle.getBundle(this.mBundleName, locale, clazz.getClassLoader());
    }

    private static String getPackageName(Class clazz) {
        Package packageObj = clazz.getPackage();
        if (packageObj != null) {
            return packageObj.getName();
        }
        String fullClassName = clazz.getName();
        int lastIndex = fullClassName.lastIndexOf(".");
        if (lastIndex > 0) {
            return fullClassName.substring(0, lastIndex);
        }
        return "";
    }

    public static Messages getMessages(Class clazz) throws MissingResourceException {
        return new Messages(clazz, Locale.getDefault());
    }

    public static Messages getMessages(Class clazz, Locale locale) throws MissingResourceException {
        return new Messages(clazz, locale);
    }

    public static String getBundleName(Class clazz) throws MissingResourceException {
        String packageName = Messages.getPackageName(clazz);
        String bundleName = DEFAULT_BUNDLE_NAME;
        if (!packageName.equals("")) {
            bundleName = packageName + "." + DEFAULT_BUNDLE_NAME;
        }
        return bundleName;
    }

    public static void registerContext(ComponentContext context) {
        mContext = context;
    }

    public static void unregisterContext() {
        mContext = null;
    }

    public static Logger getLogger(Class clazz) {
        boolean hasBundle = false;
        try {
            ResourceBundle.getBundle(Messages.getBundleName(clazz), Locale.getDefault(), clazz.getClassLoader());
            hasBundle = true;
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        if (mContext != null) {
            try {
                if (hasBundle) {
                    return mContext.getLogger(clazz.getName(), Messages.getBundleName(clazz));
                }
                return mContext.getLogger(clazz.getName(), null);
            }
            catch (JBIException jBIException) {
                // empty catch block
            }
        }
        if (hasBundle) {
            return Logger.getLogger(clazz.getName(), Messages.getBundleName(clazz));
        }
        return Logger.getLogger(clazz.getName());
    }

    public ResourceBundle getBundle() {
        return this.mResourceBundle;
    }

    public String getBundleName() {
        return this.mBundleName;
    }

    public String getString(String key) {
        try {
            return this.mResourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            logger.log(Level.WARNING, "Messages.Resource_entry_is_missing_from_the_resource_bundle", e);
            return '!' + key + '!';
        }
    }

    public String getString(String key, Object arg) {
        return this.getString(key, new Object[]{arg});
    }

    public String getString(String key, Object[] args) {
        String result = null;
        String rawValue = this.getString(key);
        try {
            result = MessageFormat.format(rawValue, args);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, "Messages.Resource_string_could_not_be_formatted", e);
            result = rawValue;
        }
        return result;
    }
}

