/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.EndpointChangeListener;
import com.sun.jbi.httpsoapbc.EndpointChangeSubject;
import com.sun.jbi.httpsoapbc.ResourceLocator;
import com.sun.jbi.httpsoapbc.ServiceUnit;
import com.sun.jbi.httpsoapbc.ServiceUnitImpl;
import com.sun.jbi.httpsoapbc.configuration.RuntimeConfigurationMBean;
import com.sun.jbi.httpsoapbc.security.impl.CredentialValidatorManager;
import com.sun.jbi.httpsoapbc.util.AlertsUtil;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.management.message.DefaultJBITaskMessageBuilder;
import com.sun.jbi.management.message.JBITaskMessageBuilder;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;

public class HttpSoapBindingDeployer
implements ServiceUnitManager,
EndpointChangeSubject {
    private static final Messages mMessages = Messages.getMessages(HttpSoapBindingDeployer.class);
    private ComponentContext mContext;
    private RuntimeConfigurationMBean mRuntimeConfig;
    private Map mServiceUnits;
    private Collection mEndpointChangeListeners;
    private JBITaskMessageBuilder mMsgBuilder;
    private Logger mLogger;
    private CredentialValidatorManager mCredValidatorMgr;

    public HttpSoapBindingDeployer(ComponentContext context, RuntimeConfigurationMBean runtimeConfig) {
        this.mContext = context;
        this.mRuntimeConfig = runtimeConfig;
        this.mMsgBuilder = new DefaultJBITaskMessageBuilder();
        this.mMsgBuilder.setComponentName(this.mContext.getComponentName());
        this.mLogger = Messages.getLogger(this.getClass());
        this.mServiceUnits = new HashMap();
        this.mEndpointChangeListeners = new HashSet();
        this.mCredValidatorMgr = new CredentialValidatorManager(runtimeConfig);
    }

    HttpSoapBindingDeployer(ComponentContext context, RuntimeConfigurationMBean runtimeConfig, Map serviceUnits, Collection endpointChangeListeners) {
        this(context, runtimeConfig);
        this.mServiceUnits = serviceUnits;
        this.mEndpointChangeListeners = endpointChangeListeners;
    }

    public String deploy(String suId, String asaFilePath) throws DeploymentException {
        String taskName = "deploy";
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "HTTPBC-R00201.Deploying_service_unit", new Object[]{suId, asaFilePath});
        }
        ServiceUnit su = null;
        try {
            su = (ServiceUnit)this.mServiceUnits.get(suId);
            if (su == null) {
                su = new ServiceUnitImpl(suId, this.mContext, this.mRuntimeConfig, this.mEndpointChangeListeners, this.mCredValidatorMgr);
            }
            su.deploy(asaFilePath);
        }
        catch (Throwable ex) {
            if (su != null) {
                try {
                    su.stop();
                    su.shutdown();
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            String msg = mMessages.getString("HTTPBC-E00201.Deploy_failed", (Object)ex.getMessage());
            if (this.mLogger.isLoggable(Level.SEVERE)) {
                this.mLogger.log(Level.SEVERE, msg, ex);
            }
            AlertsUtil.getAlerter().critical(msg, "sun-http-binding", suId, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00201");
            this.mMsgBuilder.throwException(taskName, "SOAPBC_DEPLOY_2", msg, null, ex);
        }
        this.mServiceUnits.put(suId, su);
        return this.mMsgBuilder.createSuccessMessage(taskName);
    }

    public void init(String suId, String path) throws DeploymentException {
        String taskName = "init";
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "HTTPBC-R00202.Initializing_service_unit", new Object[]{suId, path});
        }
        ServiceUnit su = null;
        try {
            su = (ServiceUnit)this.mServiceUnits.get(suId);
            if (su == null) {
                su = new ServiceUnitImpl(suId, this.mContext, this.mRuntimeConfig, this.mEndpointChangeListeners, this.mCredValidatorMgr);
                this.mServiceUnits.put(suId, su);
            }
            su.init(path);
            if (this.mLogger.isLoggable(Level.FINE)) {
                this.mLogger.log(Level.FINE, "HTTPBC-R00203.Service_unit_initialized", suId);
            }
        }
        catch (Throwable ex) {
            if (su != null) {
                try {
                    su.stop();
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
            String msg = mMessages.getString("HTTPBC-E00203.Initialize_failed", (Object)ex.getMessage());
            if (this.mLogger.isLoggable(Level.SEVERE)) {
                this.mLogger.log(Level.SEVERE, msg, ex);
            }
            AlertsUtil.getAlerter().critical(msg, "sun-http-binding", suId, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00203");
            this.mMsgBuilder.throwException(taskName, "SOAPBC_INIT_1", msg, null, ex);
        }
    }

    public void start(String suId) throws DeploymentException {
        ServiceUnit su;
        String taskName = "start";
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "HTTPBC-R00204.Starting_service_unit", suId);
        }
        if ((su = (ServiceUnit)this.mServiceUnits.get(suId)) != null) {
            try {
                su.start();
            }
            catch (Throwable ex) {
                String msg = mMessages.getString("HTTPBC-E00205.Start_failed", (Object)ex.getMessage());
                if (this.mLogger.isLoggable(Level.SEVERE)) {
                    this.mLogger.log(Level.SEVERE, msg, ex);
                }
                AlertsUtil.getAlerter().critical(msg, "sun-http-binding", suId, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00205");
                this.mMsgBuilder.throwException(taskName, "SOAPBC_START_1", msg, null, ex);
            }
        }
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "HTTPBC-R00205.Service_unit_started", suId);
        }
    }

    public void stop(String suId) throws DeploymentException {
        ServiceUnit su;
        String taskName = "stop";
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "HTTPBC-R00206.Stopping_service_unit", suId);
        }
        if ((su = (ServiceUnit)this.mServiceUnits.get(suId)) != null) {
            try {
                su.stop();
            }
            catch (Throwable ex) {
                String msg = mMessages.getString("HTTPBC-E00206.Stop_failed");
                AlertsUtil.getAlerter().critical(msg, "sun-http-binding", suId, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00206");
                this.mMsgBuilder.throwException(taskName, "SOAPBC_STOP_1", msg, null, ex);
            }
        }
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "HTTPBC-R00207.Service_unit_stopped", suId);
        }
    }

    public void shutDown(String suId) throws DeploymentException {
        ServiceUnit su;
        Object retMsg = null;
        String taskName = "shutDown";
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "HTTPBC-R00208.Shutting_down_service_unit", suId);
        }
        if ((su = (ServiceUnit)this.mServiceUnits.get(suId)) != null) {
            try {
                su.shutdown();
            }
            catch (Throwable ex) {
                String msg = mMessages.getString("HTTPBC-E00210.Shutdown_failed");
                AlertsUtil.getAlerter().critical(msg, "sun-http-binding", suId, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-E00210");
                this.mMsgBuilder.throwException(taskName, "SOAPBC_SHUTDOWN_1", msg, null, ex);
            }
        }
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "HTTPBC-R00209.Service_unit_shutdown", suId);
        }
    }

    public String undeploy(String id, String path) throws DeploymentException {
        String retMsg = null;
        String taskName = "undeploy";
        if (this.mLogger.isLoggable(Level.FINE)) {
            this.mLogger.log(Level.FINE, "Undeploying service unit " + id + " from " + path);
        }
        this.shutDown(id);
        ServiceUnit su = (ServiceUnit)this.mServiceUnits.get(id);
        if (su != null) {
            try {
                su.undeploy(path);
            }
            catch (Throwable th) {
                // empty catch block
            }
            this.mServiceUnits.put(id, null);
        }
        retMsg = this.mMsgBuilder.createSuccessMessage(taskName);
        return retMsg;
    }

    public void addEndpointChangeListener(EndpointChangeListener listener) {
        this.mEndpointChangeListeners.add(listener);
    }

    public void addEndpointChangeListener(Collection listeners) {
        this.mEndpointChangeListeners.addAll(listeners);
    }

    public void removeEndpointChangeListener(EndpointChangeListener listener) {
        this.mEndpointChangeListeners.remove(listener);
    }

    public ByteBuffer queryResource(String context, Endpoint endpoint) throws Exception {
        ResourceLocator locator = new ResourceLocator(-1, context);
        String serviceUnitId = locator.getServiceUnitId();
        ServiceUnit su = (ServiceUnit)this.mServiceUnits.get(serviceUnitId);
        if (su == null) {
            return null;
        }
        return su.getResource(locator.getResourceLocation(), endpoint);
    }
}

