/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.util;

import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPool<E> {
    private int mMaxPoolSize;
    private LinkedList<E> mPool = new LinkedList();

    public AbstractPool(int maxPoolSize) {
        this.mMaxPoolSize = maxPoolSize;
        this.resizePool(this.mMaxPoolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resizePool(int newMaxPoolSize) {
        LinkedList<E> linkedList = this.mPool;
        synchronized (linkedList) {
            int size = this.mPool.size();
            if (newMaxPoolSize > size) {
                int n = newMaxPoolSize - size;
                for (int i = 0; i < n; ++i) {
                    this.mPool.addLast(this.createResource());
                }
            } else if (newMaxPoolSize < size) {
                int n = size - newMaxPoolSize;
                for (int i = 0; i < n; ++i) {
                    if (this.mPool.size() <= 0) continue;
                    this.mPool.removeFirst();
                }
            }
            this.mMaxPoolSize = newMaxPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E acquire() {
        LinkedList<E> linkedList = this.mPool;
        synchronized (linkedList) {
            return this.mPool.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(E resource) {
        if (resource == null) {
            return;
        }
        LinkedList<E> linkedList = this.mPool;
        synchronized (linkedList) {
            if (this.mPool.size() >= this.mMaxPoolSize) {
                return;
            }
            this.mPool.addLast(resource);
        }
    }

    protected abstract E createResource();
}

