/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.qos.config;

import com.sun.jbi.common.qos.I18n;
import com.sun.jbi.common.qos.config.ComponentConfig;
import com.sun.jbi.common.qos.config.ConfigPersistence;
import com.sun.jbi.common.qos.config.RuntimeConfigurationMBean;
import com.sun.jbi.common.util.Util;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;

public abstract class AbstractConfigMBean {
    private Logger mLogger;
    private ComponentConfig mConfig;
    private String mWorkspaceRoot;

    public AbstractConfigMBean(ComponentContext ctx, ComponentConfig config) throws DeploymentException {
        this.mLogger = Util.getLogger((ComponentContext)ctx, (String)RuntimeConfigurationMBean.class.getName());
        this.mWorkspaceRoot = ctx.getWorkspaceRoot();
        if (config == null) {
            this.mConfig = ComponentConfig.parse(ctx.getInstallRoot());
            ConfigPersistence.loadConfig(this.mConfig, this.mWorkspaceRoot);
        } else {
            this.mConfig = config;
        }
    }

    protected void persistApplicationConfig() throws MBeanException {
        try {
            ConfigPersistence.persistApplicationConfig(this.getConfig(), this.getWorkspaceRoot());
        }
        catch (DeploymentException de) {
            throw this.mbeanError((Exception)((Object)de), "QOS-6027: Failed to persist {0} application configuration: {1}", this.getConfig().getName(), de.getMessage());
        }
    }

    protected void persistConfiguration() throws MBeanException {
        try {
            ConfigPersistence.persistConfig(this.getConfig(), this.getWorkspaceRoot());
        }
        catch (DeploymentException de) {
            throw this.mbeanError((Exception)((Object)de), "QOS-6028: Failed to persist {0} component configuration: {1}", this.getConfig().getName(), de.getMessage());
        }
    }

    protected ComponentConfig getConfig() {
        return this.mConfig;
    }

    protected String getWorkspaceRoot() {
        return this.mWorkspaceRoot;
    }

    protected Logger log() {
        return this.mLogger;
    }

    protected InvalidAttributeValueException invalidAttr(String msg, Object ... params) {
        String err = I18n.loc(msg, params);
        this.log().warning(err);
        return new InvalidAttributeValueException(err);
    }

    protected DeploymentException deployError(Exception e, String msg, Object ... params) {
        String err = I18n.loc(msg, params);
        if (e == null) {
            this.log().warning(err);
            return new DeploymentException(err);
        }
        this.log().log(Level.WARNING, err, e);
        return new DeploymentException(err, (Throwable)e);
    }

    protected MBeanException mbeanError(Exception e, String msg, Object ... params) {
        String err = I18n.loc(msg, params);
        if (e == null) {
            this.log().warning(err);
            return new MBeanException(new Exception(err));
        }
        this.log().log(Level.WARNING, err, e);
        return new MBeanException(e, err);
    }
}

