/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.qos.config;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property
implements Comparable<Property> {
    private String mName;
    private String mGroup;
    private QName mType;
    private List<String> mValues;
    private int mMaxOccurs;
    private boolean mRequired;

    public Property(String name, String ... defaultValue) {
        this(name);
        if (defaultValue != null) {
            for (String val : defaultValue) {
                this.addValue(val);
            }
        }
    }

    public Property(String name) {
        this.mName = name;
        this.mValues = new ArrayList<String>();
        this.mMaxOccurs = 1;
    }

    @Override
    public int compareTo(Property o) {
        return o == null ? -1 : this.getName().compareTo(o.getName());
    }

    public void addValue(String value) {
        this.insertValue(value, this.getList().size());
    }

    public void clear() {
        this.getList().clear();
    }

    public int count() {
        return this.getList().size();
    }

    protected String getGroup() {
        return this.mGroup;
    }

    public int getMaxOccurs() {
        return this.mMaxOccurs;
    }

    public String getName() {
        return this.mName;
    }

    public QName getType() {
        return this.mType;
    }

    public String getValue() {
        return this.getValueAt(0);
    }

    public String getValueAt(int index) {
        if (index >= 0 && index < this.getList().size()) {
            return this.getList().get(index);
        }
        return null;
    }

    public void insertValue(String value, int index) {
        if (index >= 0) {
            if (index < this.getList().size()) {
                this.getList().set(index, value);
            } else {
                this.getList().add(value);
            }
        }
    }

    public boolean isRepeating() {
        return this.getMaxOccurs() > 1;
    }

    public boolean isRequired() {
        return this.mRequired;
    }

    protected void setGroup(String group) {
        this.mGroup = group;
    }

    protected void setMaxOccurs(int maxOccurs) {
        this.mMaxOccurs = Math.max(1, maxOccurs);
    }

    protected void setRequired(boolean required) {
        this.mRequired = required;
    }

    protected void setType(QName type) {
        this.mType = type;
    }

    public void setValue(String value) {
        this.insertValue(value, 0);
    }

    public List<String> values() {
        return new ArrayList<String>(this.getList());
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Property[").append(this.getName()).append("=").append(String.valueOf(this.getList())).append("]");
        return buff.toString();
    }

    protected List<String> getList() {
        return this.mValues;
    }
}

