/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.internationalization.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OperationResolver {
    private static final String SOAP_ACTION_HEADER = "SOAPAction";
    private static Messages mMessages = Messages.getMessages(OperationResolver.class);
    private static Logger mLogger = Messages.getLogger(OperationResolver.class);

    public static OperationMetaData resolveOperation(SOAPMessage soapMsg, Map metaDataMap) {
        block11: {
            String[] tempS = soapMsg.getMimeHeaders().getHeader(SOAP_ACTION_HEADER);
            String rawSoapAction = tempS != null && tempS.length > 0 ? tempS[0] : null;
            String soapAction = OperationResolver.stripQuotes(rawSoapAction);
            if (soapAction != null && !soapAction.equals("")) {
                Iterator iter = metaDataMap.values().iterator();
                while (iter != null && iter.hasNext()) {
                    OperationMetaData meta = (OperationMetaData)iter.next();
                    if (!meta.useSoapAction() || !soapAction.equals(meta.getSoapActionURL())) continue;
                    return meta;
                }
                mLogger.log(Level.WARNING, "HTTPBC-W00760.Soap_action_cant_resolve_to_operation", soapAction);
            }
            try {
                SOAPBody soapBody = soapMsg.getSOAPBody();
                NodeList nl = soapBody.getChildNodes();
                ArrayList<QName> nodeNames = new ArrayList<QName>();
                ArrayList<QName> nodeLocalNames = new ArrayList<QName>();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node n = nl.item(i);
                    if (1 != n.getNodeType()) continue;
                    String ns = n.lookupNamespaceURI(n.getPrefix());
                    QName nodeQName = new QName(ns, ((Element)n).getLocalName());
                    QName unqualifiedNodeQName = new QName(((Element)n).getLocalName());
                    nodeNames.add(nodeQName);
                    nodeLocalNames.add(unqualifiedNodeQName);
                }
                Iterator iter = metaDataMap.values().iterator();
                while (iter != null && iter.hasNext()) {
                    OperationMetaData meta = (OperationMetaData)iter.next();
                    if (meta.isDocumentMode()) {
                        if (meta.useMsgAsID()) {
                            Set set = meta.getCachedInputPartNames();
                            if (set.size() != nodeNames.size() || !set.containsAll(nodeNames)) continue;
                            return meta;
                        }
                        mLogger.log(Level.WARNING, "HTTPBC-W00761.Soap_action_cant_resolve_by_message", soapAction);
                        continue;
                    }
                    if (nodeNames.size() > 0) {
                        String metaWrapperNS;
                        QName wrapperName = (QName)nodeNames.get(0);
                        if (!meta.getOperationName().equals(wrapperName.getLocalPart()) || !((metaWrapperNS = meta.getInputSoapBody().getNamespaceURI()) == null || metaWrapperNS.length() == 0 ? wrapperName.getNamespaceURI() == null : metaWrapperNS.equals(wrapperName.getNamespaceURI()))) continue;
                        return meta;
                    }
                    mLogger.warning("HTTPBC-W00763.Soap_body_empty");
                    return null;
                }
                Iterator lenientIter = metaDataMap.values().iterator();
                while (lenientIter != null && lenientIter.hasNext()) {
                    OperationMetaData meta = (OperationMetaData)lenientIter.next();
                    if (meta.isDocumentMode()) {
                        Set set;
                        if (!meta.useMsgAsID() || (set = meta.getCachedInputPartNames()).size() != nodeNames.size() || !set.containsAll(nodeLocalNames)) continue;
                        return meta;
                    }
                    if (nodeNames.size() <= 0) continue;
                    QName wrapperName = (QName)nodeNames.get(0);
                    if (!meta.getOperationName().equals(wrapperName.getLocalPart())) continue;
                    return meta;
                }
            }
            catch (SOAPException e) {
                if (!mLogger.isLoggable(Level.WARNING)) break block11;
                String text = mMessages.getString("HTTPBC-W00762.Soap_action_cant_resolve_due_access_error", (Object)e.getLocalizedMessage());
                mLogger.log(Level.WARNING, text, e);
            }
        }
        return null;
    }

    static String stripQuotes(String rawString) {
        String result = rawString;
        if (rawString != null && rawString.length() > 1 && rawString.startsWith("\"") && rawString.endsWith("\"")) {
            result = rawString.substring(1, rawString.length() - 1);
        }
        return result;
    }
}

