/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.validator;

import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.management.descriptor.EndpointIdentifier;
import com.sun.jbi.wsdlvalidator.ValidationException;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.xml.namespace.QName;

public class WSDLExtensionValidator {
    private Map mDefs;
    private EndpointIdentifier[] mSvcs;
    private static final Messages mMessages = Messages.getMessages(WSDLExtensionValidator.class);

    public WSDLExtensionValidator(Map defs, EndpointIdentifier[] svcs) {
        this.mDefs = defs;
        this.mSvcs = svcs;
    }

    public void validate() throws ValidationException {
        this.validateBindings();
    }

    public void validateBindings() throws ValidationException {
        if (this.mDefs != null && this.mSvcs != null) {
            for (Map.Entry entry : this.mDefs.entrySet()) {
                Definition def = (Definition)entry.getValue();
                for (int ii = 0; ii < this.mSvcs.length; ++ii) {
                    Binding binding;
                    EndpointIdentifier epDesc = this.mSvcs[ii];
                    if (epDesc == null || (binding = this.getBinding(def, epDesc.getServiceName().toString(), epDesc.getEndpointName())) == null) continue;
                    List elems = binding.getExtensibilityElements();
                    int numSoapBindings = 0;
                    int numHttpBindings = 0;
                    for (ExtensibilityElement el : elems) {
                        if (SOAPBinding.class.isInstance(el)) {
                            ++numSoapBindings;
                            continue;
                        }
                        if (!HTTPBinding.class.isInstance(el)) continue;
                        numHttpBindings = 0;
                    }
                    if (numSoapBindings > 0 && numSoapBindings > 1) {
                        throw new ValidationException(mMessages.getString("HTTPBC-E00261.Element_one_per_binding", (Object)"soap:binding"));
                    }
                    if (numHttpBindings > 0 && numHttpBindings > 1) {
                        throw new ValidationException(mMessages.getString("HTTPBC-E00261.Element_one_per_binding", (Object)"http:binding"));
                    }
                    this.validateBindingOperations(binding);
                }
            }
        }
    }

    public void validateBindingOperations(Binding binding) throws ValidationException {
        PortType pt = binding.getPortType();
        List bos = binding.getBindingOperations();
        if (bos != null && !bos.isEmpty()) {
            List ptOps = pt.getOperations();
            for (BindingOperation bo : bos) {
                boolean matchingOperationFound = false;
                for (Operation ptOp : ptOps) {
                    if (ptOp.isUndefined() || !ptOp.getName().equals(bo.getName())) continue;
                    matchingOperationFound = true;
                    break;
                }
                if (matchingOperationFound) continue;
                throw new ValidationException(mMessages.getString("HTTPBC-E00262.Binding_op_must_match_porttype_op", new Object[]{bo.getName(), binding.getQName().getLocalPart(), pt.getQName().getLocalPart()}));
            }
        }
    }

    public Binding getBinding(Definition def, String serviceName, String endpointName) {
        Object location = null;
        Service svc = def.getService(QName.valueOf(serviceName));
        if (svc == null) {
            return null;
        }
        Port port = svc.getPort(QName.valueOf(endpointName).getLocalPart());
        if (port == null) {
            return null;
        }
        return port.getBinding();
    }
}

