/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hulp.profiler;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import net.java.hulp.measure.Probe;
import net.sf.hulp.measure.Measurement;
import net.sf.hulp.profiler.Chrono;
import net.sf.hulp.profiler.Profiler;
import net.sf.hulp.util.Markup;
import net.sf.hulp.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealProfiler
extends Profiler {
    private HashMap<Totaler, Totaler> mTotalers = new HashMap();
    public static final double[] HISTOGRAM_BINS = new double[30];
    private static final double HISTOGRAM_DENOMINATOR = 100.0;

    private static final int histoIndex(double d) {
        if (d > HISTOGRAM_BINS[HISTOGRAM_BINS.length - 2]) {
            return HISTOGRAM_BINS.length - 1;
        }
        long k = (long)(100.0 * d);
        int i = 0;
        while (k != 0L) {
            k >>= 1;
            ++i;
        }
        return i;
    }

    private static void header(PrintWriter out, Markup f, double overhead) throws IOException {
        out.print(f.beginRow(12) + "Profiler data (" + StringTools.timeString(System.currentTimeMillis()) + "; measurement overhead: " + Chrono.format(overhead) + " ms)");
        out.print(f.tab(HISTOGRAM_BINS.length) + "Histogram data; bins in ms, counts in n(t)/N");
        out.print(f.endRow());
        out.print(f.beginHRow() + "topic" + f.tab() + "n" + f.tab() + "total time (ms)" + f.tab() + "average' (ms)" + f.tab() + "median (ms)" + f.tab() + "act" + f.tab() + "sub topic" + f.tab() + f.fine("first (ms)") + f.tab() + f.fine("average (ms)") + f.tab() + "throughput (s-1)" + f.tab() + f.fine("last-first (ms)") + f.tab() + f.fine("load"));
        for (int i = 0; i < HISTOGRAM_BINS.length; ++i) {
            out.print(f.tab());
            if (HISTOGRAM_BINS[i] == Double.MAX_VALUE) {
                out.print("oo");
                continue;
            }
            out.print(HISTOGRAM_BINS[i]);
        }
        out.print(f.endRow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Totaler getTotaler(RealMeasurementV1 m) {
        Totaler ret = null;
        HashMap<Totaler, Totaler> hashMap = this.mTotalers;
        synchronized (hashMap) {
            ret = this.mTotalers.get(m);
            if (ret == null) {
                ret = new Totaler("", m.mTopic, m.mSubTopic);
                this.mTotalers.put(ret, ret);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Totaler getTotaler(RealMeasurementV2 m) {
        Totaler ret = null;
        HashMap<Totaler, Totaler> hashMap = this.mTotalers;
        synchronized (hashMap) {
            ret = this.mTotalers.get(m);
            if (ret == null) {
                ret = new Totaler(m.mSource, m.mTopic1, m.mSubTopic);
                this.mTotalers.put(ret, ret);
            }
        }
        return ret;
    }

    @Override
    public Measurement create(String topic, String subTopic) {
        RealMeasurementV1 ret = new RealMeasurementV1(topic, subTopic, null);
        Totaler a = this.getTotaler(ret);
        a.incActive();
        ret.mTotaler = a;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TabularData getData(List<Pattern[]> criteria) {
        try {
            Map m;
            HashMap<Totaler, Totaler> hashMap = this.mTotalers;
            synchronized (hashMap) {
                m = (Map)this.mTotalers.clone();
            }
            int N = 13;
            ArrayList<CompositeDataSupport> ret = new ArrayList<CompositeDataSupport>();
            String[] names = new String[N + HISTOGRAM_BINS.length];
            SimpleType[] types = new SimpleType[N + HISTOGRAM_BINS.length];
            String[] descrs = new String[N + HISTOGRAM_BINS.length];
            CompositeType type = null;
            for (Totaler t : m.values()) {
                boolean matches = false;
                for (Pattern[] p : criteria) {
                    if (!p[0].matcher(t.mSource).matches() || !p[1].matcher(t.mName1).matches() || !p[2].matcher(t.mSubname == null ? "" : t.mSubname).matches()) continue;
                    matches = true;
                    break;
                }
                if (!matches) continue;
                Object[] values = new Object[N + HISTOGRAM_BINS.length];
                int j = 0;
                names[j] = "source";
                types[j] = SimpleType.STRING;
                descrs[j] = "source";
                values[j++] = t.mSource;
                names[j] = "topic";
                types[j] = SimpleType.STRING;
                descrs[j] = "topic";
                values[j++] = t.mName1;
                names[j] = "n";
                types[j] = SimpleType.INTEGER;
                descrs[j] = "n";
                values[j++] = t.mN;
                names[j] = "total time (ms)";
                types[j] = SimpleType.DOUBLE;
                descrs[j] = "total time (ms)";
                values[j++] = t.m_dtSum;
                names[j] = "average' (ms)";
                types[j] = SimpleType.DOUBLE;
                descrs[j] = "average' (ms)";
                values[j++] = t.getAveragePrime();
                names[j] = "median (ms)";
                types[j] = SimpleType.DOUBLE;
                descrs[j] = "median (ms)";
                values[j++] = t.getMedian();
                names[j] = "act";
                types[j] = SimpleType.INTEGER;
                descrs[j] = "act";
                values[j++] = t.m_nActive;
                names[j] = "sub topic";
                types[j] = SimpleType.STRING;
                descrs[j] = "sub topic";
                values[j++] = t.mSubname == null ? "" : t.mSubname;
                names[j] = "first (ms)";
                types[j] = SimpleType.DOUBLE;
                descrs[j] = "first (ms)";
                values[j++] = t.m_dtFirst;
                names[j] = "average (ms)";
                types[j] = SimpleType.DOUBLE;
                descrs[j] = "average (ms)";
                values[j++] = t.getAverage();
                names[j] = "throughput (s-1)";
                types[j] = SimpleType.DOUBLE;
                descrs[j] = "throughput (s-1)";
                values[j++] = t.getThroughput();
                names[j] = "last-first (ms)";
                types[j] = SimpleType.DOUBLE;
                descrs[j] = "last-first (ms)";
                values[j++] = t.getTimespan();
                names[j] = "load";
                types[j] = SimpleType.DOUBLE;
                descrs[j] = "load";
                values[j++] = t.getLoad();
                RealProfiler.assertTrue(N == j);
                for (int i = 0; i < HISTOGRAM_BINS.length; ++i) {
                    names[j] = HISTOGRAM_BINS[i] == Double.MAX_VALUE ? "oo" : "h_" + Double.toString(HISTOGRAM_BINS[i]);
                    types[j] = SimpleType.INTEGER;
                    descrs[j] = "Histogram data; bins in ms";
                    values[j++] = t.mHistogram[i];
                }
                RealProfiler.assertTrue(j == values.length);
                if (type == null) {
                    type = new CompositeType("Performance metrics row", "S", names, descrs, types);
                }
                CompositeDataSupport row = new CompositeDataSupport(type, names, values);
                ret.add(row);
            }
            if (ret.isEmpty()) {
                return null;
            }
            int nTotal = 0;
            for (Totaler t : m.values()) {
                nTotal += t.mN;
            }
            double overhead = (double)nTotal * Chrono.getOverheadPerMeasurement();
            String descr = "Profiler data (" + StringTools.timeString(System.currentTimeMillis()) + "; measurement overhead: " + Chrono.format(overhead) + " ms)";
            TabularType tabletype = new TabularType("Profiler results", descr, type, new String[]{"source", "topic", "sub topic"});
            TabularDataSupport t = new TabularDataSupport(tabletype);
            t.putAll(ret.toArray(new CompositeData[0]));
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(PrintWriter out, Markup f) throws IOException {
        Map m = null;
        HashMap<Totaler, Totaler> hashMap = this.mTotalers;
        synchronized (hashMap) {
            m = (Map)this.mTotalers.clone();
        }
        TreeSet s = new TreeSet(m.values());
        int nTotal = 0;
        for (Totaler a : s) {
            nTotal += a.mN;
        }
        double overhead = (double)nTotal * Chrono.getOverheadPerMeasurement();
        RealProfiler.header(out, f, overhead);
        for (Totaler a : s) {
            a.dump(out, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        HashMap<Totaler, Totaler> hashMap = this.mTotalers;
        synchronized (hashMap) {
            this.mTotalers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData(List<Pattern[]> criteria) {
        Map m;
        ArrayList<Totaler> toclear = new ArrayList<Totaler>();
        HashMap<Totaler, Totaler> hashMap = this.mTotalers;
        synchronized (hashMap) {
            m = (Map)this.mTotalers.clone();
        }
        block6: for (Totaler t : m.values()) {
            for (Pattern[] p : criteria) {
                if (!p[0].matcher(t.mSource).matches() || !p[1].matcher(t.mName1).matches() || !p[2].matcher(t.mSubname == null ? "" : t.mSubname).matches()) continue;
                toclear.add(t);
                continue block6;
            }
        }
        hashMap = this.mTotalers;
        synchronized (hashMap) {
            for (Totaler t : toclear) {
                this.mTotalers.remove(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map[] dump() {
        Map m = null;
        HashMap<Totaler, Totaler> hashMap = this.mTotalers;
        synchronized (hashMap) {
            m = (Map)this.mTotalers.clone();
        }
        Map[] ret = new Map[m.size()];
        int i = 0;
        for (Totaler t : m.values()) {
            HashMap<String, Object> e = new HashMap<String, Object>();
            ret[i++] = e;
            e.put("topic", t.getName());
            e.put("sub topic", t.mSubname);
            e.put("n", new Integer(t.mN));
            e.put("total time (ms)", new Double(t.m_dtSum));
            e.put("average' (ms)", new Double(t.getAveragePrime()));
            e.put("act", new Integer(t.m_nActive));
            e.put("throughput (s-1)", new Double(t.getThroughput()));
            e.put("first (ms)", new Double(t.m_dtFirst));
            e.put("average (ms)", new Double(t.getAverage()));
            e.put("last-first (ms)", new Double(t.getTimespan()));
            e.put("load", new Double(t.getLoad()));
        }
        return ret;
    }

    @Override
    public Map dump(String topicSubtopicSeparator) {
        HashMap<String, Map> ret = new HashMap<String, Map>();
        Map[] entries = this.dump();
        for (int i = 0; i < entries.length; ++i) {
            String key = entries[i].get("topic") + topicSubtopicSeparator + entries[i].get("sub topic");
            ret.put(key, entries[i]);
        }
        return ret;
    }

    private static void assertTrue(boolean b) {
        if (!b) {
            throw new RuntimeException();
        }
    }

    public void testCompare() {
        RealMeasurementV1 a = new RealMeasurementV1(null, null, null);
        Totaler b = new Totaler("", null, null);
        RealProfiler.assertTrue(a.equals(b));
        a.mTopic = "a";
        RealProfiler.assertTrue(!a.equals(b));
        RealProfiler.assertTrue(!b.equals(a));
        RealProfiler.assertTrue(a.hashCode() != b.hashCode());
        a.mSubTopic = "b";
        RealProfiler.assertTrue(!a.equals(b));
        RealProfiler.assertTrue(!b.equals(a));
        RealProfiler.assertTrue(a.hashCode() != b.hashCode());
        b.mName1 = "a";
        RealProfiler.assertTrue(!a.equals(b));
        RealProfiler.assertTrue(!b.equals(a));
        RealProfiler.assertTrue(a.hashCode() != b.hashCode());
        b.mSubname = "b";
        RealProfiler.assertTrue(a.equals(b));
        RealProfiler.assertTrue(b.equals(a));
        RealProfiler.assertTrue(a.hashCode() == b.hashCode());
        a.mSubTopic = null;
        RealProfiler.assertTrue(!a.equals(b));
        RealProfiler.assertTrue(!b.equals(a));
        RealProfiler.assertTrue(a.hashCode() != b.hashCode());
    }

    @Override
    public void help(PrintWriter out, Markup f) {
        if (!Measurement.isInstalled()) {
            out.println("All classes are available but the profiler is not enabled." + f.br());
            out.println("Set the following argument to the JVM:<br>");
            out.println(f.beginArea());
            out.println(f.beginPre());
            out.println("-Dnet.sf.hulp.profiler=1");
            out.println(f.endPre() + f.br());
            out.println(f.endArea());
        } else {
            out.println(f.beginTable(0));
            out.println(f.beginRow() + "Profiler enabled" + f.tab() + "true" + f.endRow());
            out.println(f.beginRow() + "High resolution timer available" + f.tab() + Chrono.isHighResTimerAvailable() + f.endRow());
            out.println(f.beginRow() + "Timer overhead" + f.tab() + Chrono.getOverheadPerMeasurement() + " ms per measurement" + f.endRow());
            out.println(f.endTable());
            out.println(f.br());
            out.println(f.br());
            out.println("The profiler is based on time probes that are placed strategically in");
            out.println("the code base. The probles have a name (topic) and an optional sub-name");
            out.println("(subtopic). A probe essentially measures the time difference between a");
            out.println("start and stop time, just like a stopwatch. The profiler aggregates");
            out.println("these measured time differences <span style=\"font-family: monospace;\">dt</span>.<br>");
            out.println("<br>");
            out.println("Click on <span style=\"font-weight: bold;\">dump</span> to get a listing");
            out.println("of all aggregated results of all probes in HTML format.<br>");
            out.println("Click on <span style=\"font-weight: bold;\">dump text</span> to get the");
            out.println("same data in tab-delimited text; this can be used in a spreadsheet.<br>");
            out.println("Click on <span style=\"font-weight: bold;\">clear</span> to reset all");
            out.println("probes and remove them from memory<br>");
            out.println("<br>");
            out.println("The following columns are displayed in the dump:<br>");
            out.println("<br>");
            out.println("<table style=\"width: 893px; height: 28px;\" bordercolordark=\"#FFFFFF\"");
            out.println("bordercolorlight=\"#FFFFFF\" border=\"0\" bordercolor=\"#ffffff\"");
            out.println("cellpadding=\"2\" cellspacing=\"2\">");
            out.println("<tbody>");
            out.println("<tr>");
            out.println("<td class=\"tbrwlt\"");
            out.println("style=\"vertical-align: top; background-color: rgb(229, 234, 237); color: rgb(0, 0, 0);\">n</td>");
            out.println("<td style=\"color: rgb(0, 0, 0);\" class=\"tbrwlt\" bgcolor=\"#e5eaed\"");
            out.println("valign=\"top\">Number of measurements (or <tt>N</tt>), i.e. the number");
            out.println("of <tt>dt</tt>-s, i.e. the number of times that <span");
            out.println("style=\"font-family: monospace;\">Measurement.begin()</span> - <span");
            out.println("style=\"font-family: monospace;\">end()</span> was called. <br>");
            out.println("</td>");
            out.println("</tr>");
            out.println("<tr>");
            out.println("<td class=\"tbrwlt\"");
            out.println("style=\"vertical-align: top; background-color: rgb(229, 234, 237); color: rgb(0, 0, 0);\">total");
            out.println("time (ms)</td>");
            out.println("<td style=\"color: rgb(0, 0, 0);\" class=\"tbrwlt\" bgcolor=\"#e5eaed\"");
            out.println("valign=\"top\">the sum of all <tt>dt</tt>-s&nbsp; </td>");
            out.println("</tr>");
            out.println("<tr>");
            out.println("<td class=\"tbrwlt\"");
            out.println("style=\"vertical-align: top; background-color: rgb(229, 234, 237); color: rgb(0, 0, 0);\">average'");
            out.println("(ms)</td>");
            out.println("<td style=\"color: rgb(0, 0, 0);\" class=\"tbrwlt\" bgcolor=\"#e5eaed\"");
            out.println("valign=\"top\">(the sum of all <tt>dt</tt>-s minus the first <tt>dt</tt>)");
            out.println("divided by <tt>N</tt>.");
            out.println("The first measurement is discounted because it typically includes");
            out.println("classloading times and distorts the results considerably. If there's");
            out.println("only one measurement, the first measurement is not discounted and the");
            out.println("value should be equal to total time </td>");
            out.println("</tr>");
            out.println("<tr>");
            out.println("<td class=\"tbrwlt\"");
            out.println("style=\"vertical-align: top; background-color: rgb(229, 234, 237); color: rgb(0, 0, 0);\">act</td>");
            out.println("<td style=\"color: rgb(0, 0, 0);\" class=\"tbrwlt\" bgcolor=\"#e5eaed\"");
            out.println("valign=\"top\">the number of measurement objects on which <tt>begin()</tt>");
            out.println("was called but not <tt>end()</tt>.");
            out.println("This indicates the number of active measurements&nbsp; </td>");
            out.println("</tr>");
            out.println("<tr>");
            out.println("<td class=\"tbrwlt\"");
            out.println("style=\"vertical-align: top; background-color: rgb(229, 234, 237); color: rgb(0, 0, 0);\">sub");
            out.println("topic</td>");
            out.println("<td style=\"color: rgb(0, 0, 0);\" class=\"tbrwlt\" bgcolor=\"#e5eaed\"");
            out.println("valign=\"top\">the name of the measurement specified in the second");
            out.println("argument of <tt>begin()</tt> or in <tt>setSubTopic()</tt>&nbsp; </td>");
            out.println("</tr>");
            out.println("<tr>");
            out.println("<td class=\"tbrwlt\"");
            out.println("style=\"vertical-align: top; background-color: rgb(229, 234, 237); color: rgb(0, 0, 0);\">first</td>");
            out.println("<td style=\"color: rgb(0, 0, 0);\" class=\"tbrwlt\" bgcolor=\"#e5eaed\"");
            out.println("valign=\"top\">the first <tt>dt</tt>. This is interesting because it");
            out.println("may include special initializations <br>");
            out.println("</td>");
            out.println("</tr>");
            out.println("<tr>");
            out.println("<td class=\"tbrwlt\"");
            out.println("style=\"vertical-align: top; background-color: rgb(229, 234, 237); color: rgb(0, 0, 0);\">average</td>");
            out.println("<td style=\"color: rgb(0, 0, 0);\" class=\"tbrwlt\" bgcolor=\"#e5eaed\"");
            out.println("valign=\"top\">sum of all <tt>dt</tt>-s divided by N; this does not");
            out.println("discount the first measurement&nbsp; </td>");
            out.println("</tr>");
            out.println("<tr>");
            out.println("<td class=\"tbrwlt\"");
            out.println("style=\"vertical-align: top; background-color: rgb(229, 234, 237); color: rgb(0, 0, 0);\">throughput</td>");
            out.println("<td style=\"color: rgb(0, 0, 0);\" class=\"tbrwlt\" bgcolor=\"#e5eaed\"");
            out.println("valign=\"top\"><span style=\"font-family: monospace;\">N</span> divided by");
            out.println("(<tt>tlast</tt> - <tt>tfirst</tt>); this is the average throughput.");
            out.println("This number is meaningful if there were no long pauses in");
            out.println("processing.&nbsp; </td>");
            out.println("</tr>");
            out.println("<tr>");
            out.println("<td class=\"tbrwlt\"");
            out.println("style=\"vertical-align: top; background-color: rgb(229, 234, 237); color: rgb(0, 0, 0);\"><tt>tlast</tt>");
            out.println("- <tt>tfirst</tt></td>");
            out.println("<td style=\"color: rgb(0, 0, 0);\" class=\"tbrwlt\" bgcolor=\"#e5eaed\"");
            out.println("valign=\"top\">the wallclock time of the first measurement's begin()");
            out.println("method is tracked as <tt>tfirst</tt> and the wallclock time of the");
            out.println("last measurement's end() method is tracked as <tt>tlast</tt>&nbsp; </td>");
            out.println("</tr>");
            out.println("<tr>");
            out.println("<td class=\"tbrwlt\"");
            out.println("style=\"vertical-align: top; background-color: rgb(229, 234, 237); color: rgb(0, 0, 0);\">Load</td>");
            out.println("<td style=\"color: rgb(0, 0, 0);\" class=\"tbrwlt\" bgcolor=\"#e5eaed\"");
            out.println("valign=\"top\">The sum of all <tt>dt</tt>-s divided by (<tt>tlast</tt>");
            out.println("- <tt>tfirst</tt>).");
            out.println("This is a measure of concurrency: the higher the number, the greater");
            out.println("the concurrency. In a single threaded scenario this number can never");
            out.println("exceed 1.&nbsp; </td>");
            out.println("</tr>");
            out.println("<tr>");
            out.println("<td class=\"tbrwlt\"");
            out.println("style=\"vertical-align: top; background-color: rgb(229, 234, 237); color: rgb(0, 0, 0);\">Histograms</td>");
            out.println("<td style=\"color: rgb(0, 0, 0);\" class=\"tbrwlt\" bgcolor=\"#e5eaed\"");
            out.println("valign=\"top\">See below<br>");
            out.println("</td>");
            out.println("</tr>");
            out.println("</tbody>");
            out.println("</table>");
            out.println("<br>");
            out.println("Data is tracked for histograms. There are 30 bins (0 - 29). The times");
            out.println("are on an exponential scale: 0.01 * 2<sup>bin</sup>&nbsp; where <span");
            out.println("style=\"font-family: monospace;\">bin</span> is the bin number.");
            out.println("");
        }
    }

    @Override
    public Probe createV2(int level, Class source, String topic, String subtopic) {
        RealMeasurementV2 ret = new RealMeasurementV2(source, topic, subtopic, null);
        Totaler a = this.getTotaler(ret);
        a.incActive();
        ret.mTotaler = a;
        return ret;
    }

    static {
        for (int i = 0; i < HISTOGRAM_BINS.length; ++i) {
            RealProfiler.HISTOGRAM_BINS[i] = Math.pow(2.0, i) / 100.0;
        }
        RealProfiler.HISTOGRAM_BINS[RealProfiler.HISTOGRAM_BINS.length - 1] = Double.MAX_VALUE;
    }

    private static class Totaler
    implements Comparable,
    Cloneable {
        private String mSource;
        private String mName1;
        private String mSubname;
        private int mN;
        private double m_dtSum;
        private double m_tFirst;
        private double m_dtFirst;
        private double m_tLast;
        private double m_dtLast;
        private int m_nActive;
        private int[] mHistogram;

        public Totaler(String source, String name, String subname) {
            this.mSource = source;
            this.mName1 = name;
            this.mSubname = subname;
            this.mHistogram = new int[HISTOGRAM_BINS.length];
        }

        public synchronized Object clone() {
            Totaler ret = new Totaler(this.mSource, this.mName1, this.mSubname);
            ret.mN = this.mN;
            ret.m_dtSum = this.m_dtSum;
            ret.m_tFirst = this.m_tFirst;
            ret.m_dtFirst = this.m_dtFirst;
            ret.m_tLast = this.m_tLast;
            ret.m_dtLast = this.m_dtLast;
            ret.m_nActive = this.m_nActive;
            ret.mHistogram = new int[this.mHistogram.length];
            System.arraycopy(this.mHistogram, 0, ret.mHistogram, 0, this.mHistogram.length);
            return ret;
        }

        private synchronized void incActive() {
            ++this.m_nActive;
        }

        private synchronized void decActive() {
            --this.m_nActive;
        }

        private synchronized void add(RealMeasurementV1 d) {
            if (this.mN == 0) {
                this.m_dtFirst = d.m_dt;
                this.m_tFirst = d.m_tStart;
            }
            ++this.mN;
            this.m_tLast = d.m_tStart;
            this.m_dtLast = d.m_dt;
            this.m_dtSum += d.m_dt;
            --this.m_nActive;
            int n = RealProfiler.histoIndex(d.m_dt);
            this.mHistogram[n] = this.mHistogram[n] + 1;
        }

        private synchronized void add(RealMeasurementV2 d) {
            if (this.mN == 0) {
                this.m_dtFirst = d.m_dt;
                this.m_tFirst = d.m_tStart;
            }
            ++this.mN;
            this.m_tLast = d.m_tStart;
            this.m_dtLast = d.m_dt;
            this.m_dtSum += d.m_dt;
            --this.m_nActive;
            int n = RealProfiler.histoIndex(d.m_dt);
            this.mHistogram[n] = this.mHistogram[n] + 1;
        }

        public synchronized double getAverage() {
            return this.m_dtSum / (double)(this.mN == 0 ? 1 : this.mN);
        }

        public synchronized double getAveragePrime() {
            return this.mN <= 1 ? this.m_dtSum : (this.m_dtSum - this.m_dtFirst) / (double)(this.mN - 1);
        }

        public synchronized double getLoad() {
            double load = Double.NaN;
            if (this.getTimespan() > 1.0E-8 && this.getTimespan() != Double.NaN && this.mN > 1) {
                load = (double)this.mN * this.getAverage() / this.getTimespan();
            }
            return load;
        }

        public synchronized double getTimespan() {
            double dt = Double.NaN;
            if (this.mN >= 1) {
                double dtLast = Chrono.stop(this.m_tLast);
                double dtFirst = Chrono.stop(this.m_tFirst);
                dt = dtFirst - dtLast + this.m_dtLast;
            }
            return dt;
        }

        public synchronized double getThroughput() {
            double throughput = Double.NaN;
            if (this.getTimespan() > 1.0E-8 && this.getTimespan() != Double.NaN) {
                throughput = (double)this.mN / this.getTimespan() * 1000.0;
            }
            return throughput;
        }

        public synchronized double getMedian() {
            if (this.mHistogram[0] == this.mN) {
                return 0.0;
            }
            if (this.mHistogram[HISTOGRAM_BINS.length - 1] == this.mN) {
                return this.mHistogram[HISTOGRAM_BINS.length - 1];
            }
            double half = (double)this.mN * 0.5;
            int sum = 0;
            int x1 = 0;
            int y1 = 0;
            int x2 = 0;
            int y2 = 0;
            int i = 0;
            while (i < this.mHistogram.length) {
                if ((double)(sum += this.mHistogram[i]) == half) {
                    return HISTOGRAM_BINS[i];
                }
                if (!((double)sum <= half)) {
                    x2 = sum;
                    y2 = i;
                    break;
                }
                x1 = sum;
                y1 = i++;
            }
            double y = (double)y1 + ((double)y2 - (double)y1) / ((double)x2 - (double)x1) * (half - (double)x1);
            return Math.pow(2.0, y) / 100.0;
        }

        public String getName() {
            return this.mSource + (this.mSource.length() == 0 ? "" : ".") + this.mName1;
        }

        private synchronized void dump(PrintWriter out, Markup f) throws IOException {
            out.print(f.beginRow() + this.getName() + f.tab() + this.mN + f.tab() + Chrono.format(this.m_dtSum) + f.tab() + Chrono.format(this.getAveragePrime()) + f.tab() + Chrono.format(this.getMedian()) + f.tab() + this.m_nActive + f.tab() + f.fine(this.mSubname) + f.tab() + f.fine(Chrono.format(this.m_dtFirst)) + f.tab() + f.fine(Chrono.format(this.getAverage())) + f.tab() + Chrono.format(this.getThroughput()) + f.tab() + f.fine(Chrono.format(this.getTimespan())) + f.tab() + f.fine(Chrono.format(this.getLoad())));
            for (int i = 0; i < this.mHistogram.length; ++i) {
                out.print(f.tab() + this.mHistogram[i]);
            }
            out.print(f.endRow());
        }

        public int hashCode() {
            if (this.mSubname != null) {
                return this.mSource.hashCode() + this.mName1.hashCode() + this.mSubname.hashCode();
            }
            if (this.mName1 != null) {
                return this.mSource.hashCode() + this.mName1.hashCode();
            }
            return this.mSource.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof RealMeasurementV1) {
                RealMeasurementV1 rhs = (RealMeasurementV1)o;
                return "".equals(this.mSource) && (this.mName1 == rhs.mTopic || this.mName1 != null && this.mName1.equals(rhs.mTopic)) && (this.mSubname == rhs.mSubTopic || this.mSubname != null && rhs.mSubTopic != null && this.mSubname.equals(rhs.mSubTopic));
            }
            if (o instanceof RealMeasurementV2) {
                RealMeasurementV2 rhs = (RealMeasurementV2)o;
                return this.mSource.equals(rhs.mSource) && (this.mName1 == rhs.mTopic1 || this.mName1 != null && this.mName1.equals(rhs.mTopic1)) && (this.mSubname == rhs.mSubTopic || this.mSubname != null && rhs.mSubTopic != null && this.mSubname.equals(rhs.mSubTopic));
            }
            if (o instanceof Totaler) {
                Totaler rhs = (Totaler)o;
                return this.mSource.equals(rhs.mSource) && (this.mName1 == rhs.mName1 || this.mName1 != null && this.mName1.equals(rhs.mName1)) && (this.mSubname == rhs.mSubname || this.mSubname != null && rhs.mSubname != null && this.mSubname.equals(rhs.mSubname));
            }
            return false;
        }

        public int compareTo(Object rhs_) {
            Totaler lhs = this;
            Totaler rhs = (Totaler)rhs_;
            int ret = lhs.mSource.compareTo(rhs.mSource);
            if (ret == 0 && lhs.mName1 != rhs.mName1) {
                ret = lhs.mName1 == null ? -1 : (rhs.mName1 == null ? 1 : lhs.mName1.compareTo(rhs.mName1));
            }
            if (ret == 0) {
                if (lhs.mSubname != null && rhs.mSubname != null) {
                    ret = lhs.mSubname.compareTo(rhs.mSubname);
                } else {
                    if (lhs.mSubname == null && rhs.mSubname == null) {
                        ret = 0;
                    }
                    if (lhs.mSubname == null) {
                        ret = 1;
                    } else if (rhs.mSubname == null) {
                        return -1;
                    }
                }
            }
            return ret;
        }
    }

    private class RealMeasurementV2
    extends Probe {
        private String mSource;
        private String mTopic1;
        private String mSubTopic;
        private double m_tStart;
        private double m_dt;
        private boolean mDead;
        private Totaler mTotaler;

        public RealMeasurementV2(Class source, String topic, String subTopic, Totaler a) {
            this.mSource = source == null ? "" : source.getName();
            this.mTopic1 = topic;
            this.mSubTopic = subTopic;
            this.m_tStart = Chrono.start();
            this.mTotaler = a;
        }

        public void setTopic(String topic) {
            this.mTopic1 = topic;
            this.mTotaler.decActive();
            this.mTotaler = RealProfiler.this.getTotaler(this);
            this.mTotaler.incActive();
        }

        public void setSubtopic(String subTopic) {
            this.mSubTopic = subTopic;
            this.mTotaler.decActive();
            this.mTotaler = RealProfiler.this.getTotaler(this);
            this.mTotaler.incActive();
        }

        public void end() {
            if (this.mDead) {
                return;
            }
            this.mDead = true;
            this.m_dt = Chrono.stop(this.m_tStart);
            if (this.mTotaler == null) {
                this.mTotaler = RealProfiler.this.getTotaler(this);
            }
            this.mTotaler.add(this);
        }

        public int hashCode() {
            if (this.mSubTopic != null) {
                return this.mSource.hashCode() + this.mTopic1.hashCode() + this.mSubTopic.hashCode();
            }
            if (this.mTopic1 != null) {
                return this.mSource.hashCode() + this.mTopic1.hashCode();
            }
            return this.mSource.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof RealMeasurementV2) {
                RealMeasurementV2 rhs = (RealMeasurementV2)o;
                return this.mSource.equals(rhs.mSource) && (this.mTopic1 == rhs.mTopic1 || this.mTopic1 != null && this.mTopic1.equals(rhs.mTopic1)) && (this.mSubTopic == rhs.mSubTopic || this.mSubTopic != null && rhs.mSubTopic != null && this.mSubTopic.equals(rhs.mSubTopic));
            }
            if (o instanceof Totaler) {
                Totaler rhs = (Totaler)o;
                return this.mSource.equals(rhs.mSource) && (this.mTopic1 == rhs.mName1 || this.mTopic1 != null && this.mTopic1.equals(rhs.mName1)) && (this.mSubTopic == rhs.mSubname || this.mSubTopic != null && rhs.mSubname != null && this.mSubTopic.equals(rhs.mSubname));
            }
            return false;
        }
    }

    private class RealMeasurementV1
    extends Measurement {
        private String mTopic;
        private String mSubTopic;
        private double m_tStart;
        private double m_dt;
        private boolean mDead;
        private Totaler mTotaler;

        public RealMeasurementV1(String topic, String subTopic, Totaler a) {
            this.mTopic = topic;
            this.mSubTopic = subTopic;
            this.m_tStart = Chrono.start();
            this.mTotaler = a;
        }

        public void setTopic(String topic) {
            this.mTopic = topic;
            this.mTotaler.decActive();
            this.mTotaler = RealProfiler.this.getTotaler(this);
            this.mTotaler.incActive();
        }

        public void setSubtopic(String subTopic) {
            this.mSubTopic = subTopic;
            this.mTotaler.decActive();
            this.mTotaler = RealProfiler.this.getTotaler(this);
            this.mTotaler.incActive();
        }

        public void end() {
            if (this.mDead) {
                return;
            }
            this.mDead = true;
            this.m_dt = Chrono.stop(this.m_tStart);
            if (this.mTotaler == null) {
                this.mTotaler = RealProfiler.this.getTotaler(this);
            }
            this.mTotaler.add(this);
        }

        public int hashCode() {
            if (this.mSubTopic != null) {
                return this.mTopic.hashCode() + this.mSubTopic.hashCode();
            }
            if (this.mTopic != null) {
                return this.mTopic.hashCode();
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof RealMeasurementV1) {
                RealMeasurementV1 rhs = (RealMeasurementV1)o;
                return (this.mTopic == rhs.mTopic || this.mTopic != null && this.mTopic.equals(rhs.mTopic)) && (this.mSubTopic == rhs.mSubTopic || this.mSubTopic != null && rhs.mSubTopic != null && this.mSubTopic.equals(rhs.mSubTopic));
            }
            if (o instanceof Totaler) {
                Totaler rhs = (Totaler)o;
                return "".equals(rhs.mSource) && (this.mTopic == rhs.mName1 || this.mTopic != null && this.mTopic.equals(rhs.mName1)) && (this.mSubTopic == rhs.mSubname || this.mSubTopic != null && rhs.mSubname != null && this.mSubTopic.equals(rhs.mSubname));
            }
            return false;
        }
    }
}

