#!/bin/bash

# if eth2 exists, and it is a igbvf device, then
# get eth0 ip, ifdown eth0, and manually configure
# eth2 with eth0's IP

if [ -e /sys/class/net/eth2 ]; then
   eth0_ip=`ip addr show dev eth0 | grep "inet " | awk '{print $2}' | awk -F/ '{print $1}'`
   if [ -z "$eth0_ip" ]; then
	echo "no ip address for eth0, exiting"
        exit 1
   fi
   def_route_gw=`ip route show | grep default | awk '{print $3}'`
   echo migrating eth0 ip $eth0_ip to eth2
   ifdown eth0
   ifconfig eth2 down
   ifconfig eth2 $eth0_ip netmask 255.255.0.0 up
   route add -net default gw $def_route_gw dev eth2
fi 

# also set up eth3 for an optional, dedicated ixgbevf for NFS
if [ -e /sys/class/net/eth3 ]; then
    ifconfig eth1 down
    if hostname | grep web; then
        tile=`hostname -s | sed -e s/vg-webt// -e s/^0*//`
        ifconfig eth3 192.132.${tile}.1 netmask 255.255.255.0 up
    else
        tile=`hostname -s | sed -e s/vg-infrat// -e s/^0*//`
        ifconfig eth3 192.132.${tile}.2 netmask 255.255.255.0 up
    fi
fi
