/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.embedded;

import com.sun.enterprise.web.connector.grizzly.AsyncTask;
import com.sun.jbi.httpsoapbc.Denormalizer;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.FaultException;
import com.sun.jbi.httpsoapbc.HttpSoapBindingLifeCycle;
import com.sun.jbi.httpsoapbc.HttpSoapComponentContext;
import com.sun.jbi.httpsoapbc.InboundMessageProcessor;
import com.sun.jbi.httpsoapbc.MessageExchangeSupport;
import com.sun.jbi.httpsoapbc.Normalizer;
import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.ReplyListener;
import com.sun.jbi.httpsoapbc.embedded.HttpException;
import com.sun.jbi.httpsoapbc.embedded.JBIGrizzlyAsyncFilter;
import com.sun.jbi.httpsoapbc.servletsupport.HttpServletDenormalizer;
import com.sun.jbi.httpsoapbc.servletsupport.HttpServletNormalizer;
import com.sun.jbi.httpsoapbc.util.DebugLog;
import com.sun.jbi.internationalization.Messages;
import com.sun.jbi.nms.exchange.ExchangePattern;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.servlet.ServletOutputStream;
import org.apache.catalina.Connector;
import org.apache.catalina.Request;
import org.apache.coyote.Adapter;
import org.apache.coyote.Response;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.coyote.tomcat5.CoyoteConnector;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteResponse;

public class GrizzlyRequestProcessor
implements Adapter,
ReplyListener {
    private static final Messages mMessages = Messages.getMessages(GrizzlyRequestProcessor.class);
    private static final Logger mLogger = Messages.getLogger(GrizzlyRequestProcessor.class);
    static final int ADAPTER_NOTES = 1;
    private CoyoteConnector connector = null;
    Map exchangeIDToContext = new ConcurrentHashMap();
    HttpSoapBindingLifeCycle lifeCycle;
    private static ThreadLocal processorSupport = new ThreadLocal();

    public GrizzlyRequestProcessor(CoyoteConnector connector) throws MessagingException {
        this.connector = connector;
        this.initialize();
    }

    void initialize() throws MessagingException {
        this.lifeCycle = (HttpSoapBindingLifeCycle)HttpSoapComponentContext.getInstance().getAssociatedLifeCycle();
    }

    public void service(org.apache.coyote.Request req, Response res) {
        AsyncTask asyncTask = JBIGrizzlyAsyncFilter.removeTaskMapping(req);
        if (mLogger.isLoggable(Level.FINEST)) {
            mLogger.log(Level.FINEST, "Got task mapping from request " + req.toString() + ", asyncProcessorTask " + asyncTask);
        }
        int port = this.connector.getPort();
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Servicing async request for " + req.requestURI());
        }
        CoyoteRequest request = (CoyoteRequest)req.getNote(1);
        CoyoteResponse response = (CoyoteResponse)res.getNote(1);
        if (mLogger.isLoggable(Level.FINEST)) {
            mLogger.log(Level.FINEST, "Initializing servicing objects");
        }
        request = (CoyoteRequest)this.connector.createRequest();
        request.setCoyoteRequest(req);
        response = (CoyoteResponse)this.connector.createResponse();
        response.setCoyoteResponse(res);
        request.setResponse((org.apache.catalina.Response)response);
        response.setRequest((Request)request);
        req.setNote(1, (Object)request);
        res.setNote(1, (Object)response);
        req.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Query string encoding: " + this.connector.getURIEncoding());
        }
        Context currentContext = new Context();
        currentContext.port = port;
        currentContext.anInputBuffer = (InternalInputBuffer)req.getInputBuffer();
        currentContext.anOutputBuffer = (InternalOutputBuffer)res.getOutputBuffer();
        currentContext.req = req;
        currentContext.res = res;
        currentContext.coyoteRequest = request;
        currentContext.coyoteResponse = response;
        currentContext.connector = this.connector;
        currentContext.asyncTask = asyncTask;
        currentContext.contextPath = "";
        currentContext.pathInfo = req.requestURI().toString();
        if ("WSDL".equalsIgnoreCase(request.getQueryString())) {
            this.processSynchronousReply(currentContext, null, null);
        } else {
            try {
                String exchangeID = this.processAsynchRequest(currentContext);
            }
            catch (Exception ex) {
                if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "Exception reported in process synchronous request-reply.", ex);
                }
                this.processSynchronousReply(currentContext, null, ex);
            }
        }
    }

    public void afterService(org.apache.coyote.Request req, Response res) {
    }

    public String processAsynchRequest(Context reqContext) throws FaultException, HttpException {
        int port;
        String exchangeID = null;
        CoyoteRequest request = reqContext.coyoteRequest;
        String context = reqContext.contextPath + reqContext.pathInfo;
        Endpoint targetEndpoint = this.lifeCycle.getEndpointBeanForContext(context, port = reqContext.port);
        if (targetEndpoint == null) {
            if (mLogger.isLoggable(Level.WARNING)) {
                mLogger.log(Level.WARNING, "HTTPBC-W00652.Web_service_mapping_failed", new Object[]{context, new Integer(port)});
            }
            throw new HttpException(404, mMessages.getString("HTTPBC-W00652.Web_service_mapping_failed", new Object[]{context, new Integer(port)}));
        }
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Web service mapping found for the requested URL. " + context + " at port " + port);
        }
        try {
            InboundMessageProcessor anInboundProcessor = this.getProcessorSupport().inboundProcessor;
            anInboundProcessor.setInput(request);
            anInboundProcessor.setTargetEndpoint(targetEndpoint);
            exchangeID = anInboundProcessor.execute(reqContext);
        }
        catch (MessagingException ex) {
            if (mLogger.isLoggable(Level.WARNING)) {
                mLogger.log(Level.WARNING, "HTTPBC-W00653.Exception_during_request_processing", ex);
            }
            throw new FaultException(ex);
        }
        return exchangeID;
    }

    public void setMessageExchangeId(String messageExchangeId, Object clientContext) {
        if (mLogger.isLoggable(Level.FINEST)) {
            mLogger.log(Level.FINEST, "setMessageExchangeId: " + messageExchangeId + ", clientContext: " + clientContext);
        }
        this.exchangeIDToContext.put(messageExchangeId, clientContext);
    }

    public void removeMessageExchangeId(String messageExchangeId) {
        this.exchangeIDToContext.remove(messageExchangeId);
    }

    public void onReply(MessageExchange exchange) throws MessagingException {
        MessageExchangeSupport.removeReplyListener(exchange.getExchangeId());
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Got reply message exchange " + exchange.getExchangeId());
        }
        Context context = (Context)this.exchangeIDToContext.remove(exchange.getExchangeId());
        if (mLogger.isLoggable(Level.FINEST)) {
            StringBuffer idsStr = new StringBuffer();
            Set s = this.exchangeIDToContext.keySet();
            if (s.size() == 0) {
                idsStr.append("none");
            } else {
                for (Object key : s) {
                    idsStr.append(key.toString()).append(" ");
                }
            }
            mLogger.log(Level.FINEST, "Outstanding exchanges: " + idsStr.toString());
        }
        try {
            this.processAsynchReply(context, exchange, null);
        }
        catch (RuntimeException ex) {
            throw new MessagingException(mMessages.getString("HTTPBC-E00654.Exception_during_reply_processing"), (Throwable)ex);
        }
        finally {
            if (mLogger.isLoggable(Level.FINEST)) {
                mLogger.log(Level.FINEST, "Finishing response");
            }
            JBIGrizzlyAsyncFilter.finishResponse(context.asyncTask);
        }
    }

    public void processSynchronousReply(Context reqContext, MessageExchange exchange, Exception requestFailedException) {
        this.processAsynchReply(reqContext, exchange, requestFailedException);
        JBIGrizzlyAsyncFilter.finishResponseSynchronously(reqContext.asyncTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAsynchReply(Context reqContext, MessageExchange exchange, Exception requestFailedException) {
        block51: {
            CoyoteResponse response = reqContext.coyoteResponse;
            try {
                CoyoteRequest request = reqContext.coyoteRequest;
                String context = reqContext.contextPath + reqContext.pathInfo;
                if (mLogger.isLoggable(Level.FINEST)) {
                    mLogger.log(Level.FINEST, "Lifecycle: " + this.lifeCycle + ", context path: " + context + ", request context: " + reqContext);
                }
                Endpoint targetEndpoint = this.lifeCycle.getEndpointBeanForContext(context, reqContext.port);
                OperationMetaData operationMetaData = null;
                response.setContentType("text/xml");
                if (mLogger.isLoggable(Level.FINEST)) {
                    mLogger.log(Level.FINEST, "Request query string: " + request.getQueryString());
                }
                if (targetEndpoint != null && "WSDL".equalsIgnoreCase(request.getQueryString())) {
                    try {
                        ByteBuffer mbb = targetEndpoint.getServiceDescriptorAsByteBuffer();
                        ServletOutputStream os = response.getOutputStream();
                        WritableByteChannel channel = Channels.newChannel((OutputStream)os);
                        channel.write(mbb);
                        os.flush();
                        response.setStatus(200);
                    }
                    catch (Exception e) {
                        if (mLogger.isLoggable(Level.WARNING)) {
                            mLogger.log(Level.WARNING, "HTTPBC-W00651.WSDL_retrieval_exception", e);
                        }
                        response.setStatus(500);
                    }
                    return;
                }
                String pat = null;
                String operation = null;
                if (exchange != null) {
                    URI pattern = exchange.getPattern();
                    if (mLogger.isLoggable(Level.FINEST)) {
                        mLogger.log(Level.FINEST, "Pattern for exchange id " + exchange.getExchangeId() + " is " + pattern);
                    }
                    pat = pattern.toString().trim();
                    operation = exchange.getOperation().getLocalPart();
                } else if (requestFailedException == null) {
                    requestFailedException = new MessagingException("Null message exchange");
                }
                if (targetEndpoint != null) {
                    Map nameToMeta = targetEndpoint.getOperationNameToMetaData();
                    operationMetaData = (OperationMetaData)nameToMeta.get(operation);
                }
                if (targetEndpoint == null || exchange == null || ExchangePattern.isInOut((MessageExchange)exchange)) {
                    try {
                        Denormalizer aDenormalizer;
                        if (requestFailedException != null) {
                            if (requestFailedException instanceof HttpException) {
                                ByteBuffer resource = this.lifeCycle.queryResource(context, targetEndpoint);
                                if (resource != null) {
                                    if (mLogger.isLoggable(Level.FINE)) {
                                        mLogger.log(Level.FINE, "Request context " + context + " at port " + reqContext.port + " mapped to resource " + resource);
                                    }
                                    ByteBuffer mbb = resource;
                                    ServletOutputStream os = response.getOutputStream();
                                    WritableByteChannel channel = Channels.newChannel((OutputStream)os);
                                    channel.write(mbb);
                                    os.flush();
                                    response.setStatus(200);
                                } else {
                                    response.setStatus(((HttpException)requestFailedException).getErrorCode());
                                }
                            } else {
                                aDenormalizer = this.getProcessorSupport().denormalizer;
                                response = (CoyoteResponse)aDenormalizer.denormalizeException(requestFailedException, response);
                                int statusCode = 500;
                                response.setStatus(statusCode);
                            }
                            break block51;
                        }
                        if (operationMetaData == null) {
                            throw new MessagingException(mMessages.getString("HTTPBC-E00667.No_opmeta_for_operation", (Object)operation));
                        }
                        if (exchange.getError() != null) {
                            aDenormalizer = this.getProcessorSupport().denormalizer;
                            response = (CoyoteResponse)aDenormalizer.denormalizeError(exchange, response);
                            break block51;
                        }
                        Fault outMsg = null;
                        if (exchange.getFault() != null) {
                            Fault aFault;
                            outMsg = aFault = exchange.getFault();
                        } else if (exchange instanceof InOut) {
                            InOut inout = (InOut)exchange;
                            outMsg = inout.getOutMessage();
                        }
                        if (mLogger.isLoggable(Level.FINE)) {
                            if (outMsg != null) {
                                DebugLog.debugLog(mLogger, Level.FINE, "Denormalizing received msg", outMsg.getContent());
                            } else {
                                mLogger.log(Level.FINE, "Message received is empty");
                            }
                        }
                        Denormalizer aDenormalizer2 = this.getProcessorSupport().denormalizer;
                        response = (CoyoteResponse)aDenormalizer2.denormalize((NormalizedMessage)outMsg, exchange, response, operationMetaData);
                    }
                    catch (Throwable ex) {
                        if (mLogger.isLoggable(Level.WARNING)) {
                            mLogger.log(Level.WARNING, "HTTPBC-W00654.Exception_during_reply_processing", ex);
                        }
                        Denormalizer aDenormalizer = this.getProcessorSupport().denormalizer;
                        response = (CoyoteResponse)aDenormalizer.denormalizeException(ex, response);
                    }
                    break block51;
                }
                if (ExchangePattern.isInOnly((MessageExchange)exchange)) {
                    int statusCode = 202;
                    if (requestFailedException != null) {
                        if (requestFailedException instanceof HttpException) {
                            statusCode = ((HttpException)requestFailedException).getErrorCode();
                        } else {
                            mLogger.log(Level.SEVERE, "HTTPBC-E00653.Exception_during_request_processing", requestFailedException);
                            statusCode = 500;
                        }
                    } else if (exchange.getStatus().equals(ExchangeStatus.ERROR)) {
                        mLogger.log(Level.SEVERE, "HTTPBC-E00653.Exception_during_request_processing");
                        statusCode = 500;
                    }
                    response.setStatus(statusCode);
                } else {
                    mLogger.log(Level.SEVERE, "HTTPBC-E00668.Unsupported_message_type", pat);
                    int statusCode = 500;
                    response.setStatus(statusCode);
                }
            }
            catch (Throwable ex) {
                mLogger.log(Level.SEVERE, "HTTPBC-E00654.Exception_during_reply_processing", ex);
                int statusCode = 500;
                response.setStatus(statusCode);
            }
            finally {
                try {
                    response.finishResponse();
                }
                catch (IOException ex) {
                    mLogger.log(Level.SEVERE, "HTTPBC-E00654.Exception_during_reply_processing", ex);
                }
                if (mLogger.isLoggable(Level.FINEST)) {
                    mLogger.log(Level.FINEST, "Wrote response");
                }
            }
        }
    }

    public void fireAdapterEvent(String type, Object data) {
        mLogger.log(Level.FINE, "Not supported by this implementation");
    }

    ProcessorSupport getProcessorSupport() throws MessagingException {
        ProcessorSupport currentProcSupport = (ProcessorSupport)processorSupport.get();
        if (currentProcSupport == null) {
            currentProcSupport = new ProcessorSupport();
            currentProcSupport.normalizer = new HttpServletNormalizer();
            currentProcSupport.denormalizer = new HttpServletDenormalizer();
            currentProcSupport.inboundProcessor = new InboundMessageProcessor(currentProcSupport.normalizer, this);
            processorSupport.set(currentProcSupport);
        }
        return currentProcSupport;
    }

    static class Context {
        int port;
        InternalInputBuffer anInputBuffer;
        InternalOutputBuffer anOutputBuffer;
        org.apache.coyote.Request req;
        Response res;
        CoyoteRequest coyoteRequest;
        CoyoteResponse coyoteResponse;
        Connector connector;
        String contextPath;
        String pathInfo;
        AsyncTask asyncTask;

        Context() {
        }
    }

    static class ProcessorSupport {
        Normalizer normalizer;
        Denormalizer denormalizer;
        InboundMessageProcessor inboundProcessor;

        ProcessorSupport() {
        }
    }
}

