/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.util.soap;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPHeaderImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLConverter {
    ExtensionRegistry extnReg;
    WSDLReader wsdlReader;
    WSDLWriter wsdlWriter;
    public static final String SOAP_NS = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String SOAP_PREFIX = "soap";
    public static final String SOAP_BINDING_SUFFIX = "binding";
    public static final String SOAP_OPERATION_SUFFIX = "operation";
    public static final String SOAP_ADDRESS_SUFFIX = "address";
    public static final String SOAP_BODY_SUFFIX = "body";
    public static final String SOAP_HEADER_SUFFIX = "header";
    public static final String SOAP_FAULT_SUFFIX = "fault";
    public static final String SOAP_HTTP_TRANSPORT_URI = "http://schemas.xmlsoap.org/soap/http";
    public static final String SOAP_ADDRESS_LOCATION = "REPLACE_WITH_ACTUAL_URL";
    public static final String RPC_STYLE = "rpc";
    public static final String DOCUMENT_STYLE = "document";
    public static final String USE_LITERAL = "literal";

    public WSDLConverter() throws Exception {
        WSDLFactory factory = WSDLFactory.newInstance();
        this.wsdlReader = factory.newWSDLReader();
        this.wsdlWriter = factory.newWSDLWriter();
        this.extnReg = new ExtensionRegistry();
        this.extnReg.mapExtensionTypes(Binding.class, new QName(SOAP_NS, SOAP_BINDING_SUFFIX), SOAPBindingImpl.class);
        this.extnReg.mapExtensionTypes(ExtensibilityElement.class, new QName(SOAP_NS, SOAP_OPERATION_SUFFIX), SOAPOperationImpl.class);
        this.extnReg.mapExtensionTypes(ExtensibilityElement.class, new QName(SOAP_NS, SOAP_ADDRESS_SUFFIX), SOAPAddressImpl.class);
        this.extnReg.mapExtensionTypes(SOAPBody.class, new QName(SOAP_NS, SOAP_BODY_SUFFIX), SOAPBodyImpl.class);
        this.extnReg.mapExtensionTypes(SOAPHeader.class, new QName(SOAP_NS, SOAP_HEADER_SUFFIX), SOAPHeaderImpl.class);
        this.extnReg.mapExtensionTypes(SOAPFault.class, new QName(SOAP_NS, SOAP_FAULT_SUFFIX), SOAPFaultImpl.class);
    }

    private SOAPBinding createSoapBinding() throws Exception {
        SOAPBinding soapBinding = (SOAPBinding)this.extnReg.createExtension(Binding.class, new QName(SOAP_NS, SOAP_BINDING_SUFFIX));
        soapBinding.setTransportURI(SOAP_HTTP_TRANSPORT_URI);
        return soapBinding;
    }

    private SOAPAddress createSoapAddress() throws Exception {
        SOAPAddress soapAddress = (SOAPAddress)this.extnReg.createExtension(ExtensibilityElement.class, new QName(SOAP_NS, SOAP_ADDRESS_SUFFIX));
        soapAddress.setLocationURI(SOAP_ADDRESS_LOCATION);
        return soapAddress;
    }

    private SOAPOperation createSoapOperation() throws Exception {
        SOAPOperation soapOperation = (SOAPOperation)this.extnReg.createExtension(ExtensibilityElement.class, new QName(SOAP_NS, SOAP_OPERATION_SUFFIX));
        return soapOperation;
    }

    private SOAPBody createSoapBody() throws Exception {
        SOAPBody soapBody = (SOAPBody)this.extnReg.createExtension(SOAPBody.class, new QName(SOAP_NS, SOAP_BODY_SUFFIX));
        soapBody.setUse(USE_LITERAL);
        return soapBody;
    }

    private SOAPHeader createSoapHeader() throws Exception {
        SOAPHeader soapHeader = (SOAPHeader)this.extnReg.createExtension(SOAPHeader.class, new QName(SOAP_NS, SOAP_HEADER_SUFFIX));
        soapHeader.setUse(USE_LITERAL);
        return soapHeader;
    }

    private SOAPFault createSoapFault() throws Exception {
        SOAPFault soapFault = (SOAPFault)this.extnReg.createExtension(SOAPFault.class, new QName(SOAP_NS, SOAP_FAULT_SUFFIX));
        soapFault.setUse(USE_LITERAL);
        return soapFault;
    }

    private String getStyle(Operation portTypeOperation) {
        try {
            List parts;
            if (portTypeOperation.getInput() != null) {
                parts = portTypeOperation.getInput().getMessage().getOrderedParts(null);
                for (Part p : parts) {
                    if (p.getTypeName() == null) continue;
                    return RPC_STYLE;
                }
            }
            if (portTypeOperation.getOutput() != null) {
                parts = portTypeOperation.getOutput().getMessage().getOrderedParts(null);
                for (Part p : parts) {
                    if (p.getTypeName() == null) continue;
                    return RPC_STYLE;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return DOCUMENT_STYLE;
    }

    private void processElement(ElementExtensible elementExtensible, Message message, String style) throws Exception {
        if (RPC_STYLE.equals(style)) {
            SOAPBody soapBody = this.createSoapBody();
            soapBody.setNamespaceURI(message.getQName().getNamespaceURI());
            elementExtensible.addExtensibilityElement((ExtensibilityElement)soapBody);
        } else {
            List orderedParts = message.getOrderedParts(null);
            boolean partBoundToBody = false;
            for (int i = orderedParts.size() - 1; i >= 0; --i) {
                Part p = (Part)orderedParts.get(i);
                if (p.getElementName().getLocalPart().equals(message.getQName().getLocalPart()) || i == 0 && !partBoundToBody) {
                    partBoundToBody = true;
                    SOAPBody soapBody = this.createSoapBody();
                    ArrayList<String> parts = new ArrayList<String>();
                    parts.add(p.getName());
                    soapBody.setParts(parts);
                    elementExtensible.addExtensibilityElement((ExtensibilityElement)soapBody);
                    continue;
                }
                SOAPHeader soapHeader = this.createSoapHeader();
                soapHeader.setPart(p.getName());
                soapHeader.setMessage(message.getQName());
                elementExtensible.addExtensibilityElement((ExtensibilityElement)soapHeader);
            }
        }
    }

    private boolean convertServices(Definition defn) throws Exception {
        Service[] originalServices;
        boolean wsdlModified = false;
        Map services = defn.getServices();
        if (services == null || services.isEmpty()) {
            return wsdlModified;
        }
        for (Service originalService : originalServices = services.values().toArray(new Service[0])) {
            Map originalPorts = originalService.getPorts();
            boolean isSOAP = false;
            Service newService = defn.createService();
            for (String key : originalPorts.keySet()) {
                Port originalPort = (Port)originalPorts.get(key);
                List extList = originalPort.getExtensibilityElements();
                for (ExtensibilityElement extElem : extList) {
                    if (!(extElem instanceof SOAPAddress)) continue;
                    isSOAP = true;
                    break;
                }
                if (isSOAP) continue;
                wsdlModified = true;
                String originalPortName = originalPort.getName();
                Element originalPortDocElem = originalPort.getDocumentationElement();
                Binding originalBinding = originalPort.getBinding();
                Port newPort = defn.createPort();
                newPort.setName(originalPortName);
                newPort.setBinding(defn.getBinding(originalBinding.getQName()));
                newPort.setDocumentationElement(originalPortDocElem);
                SOAPAddress soapAddress = this.createSoapAddress();
                newPort.addExtensibilityElement((ExtensibilityElement)soapAddress);
                newService.setQName(originalService.getQName());
                newService.addPort(newPort);
            }
            if (isSOAP) continue;
            defn.removeService(originalService.getQName());
            defn.addService(newService);
        }
        return wsdlModified;
    }

    private boolean convertBindings(Definition defn) throws Exception {
        Binding[] originalBindings;
        boolean wsdlModified = false;
        Map bindings = defn.getBindings();
        if (bindings == null || bindings.isEmpty()) {
            return wsdlModified;
        }
        for (Binding originalBinding : originalBindings = bindings.values().toArray(new Binding[0])) {
            boolean isSOAP = false;
            List extList = originalBinding.getExtensibilityElements();
            for (ExtensibilityElement extElem : extList) {
                if (!(extElem instanceof SOAPBinding)) continue;
                isSOAP = true;
                break;
            }
            if (isSOAP) continue;
            wsdlModified = true;
            PortType p = originalBinding.getPortType();
            QName originalBindingQname = originalBinding.getQName();
            List originalBindingOps = originalBinding.getBindingOperations();
            Binding newBinding = defn.createBinding();
            newBinding.setQName(originalBindingQname);
            newBinding.setPortType(p);
            newBinding.setUndefined(false);
            SOAPBinding soapBinding = this.createSoapBinding();
            newBinding.addExtensibilityElement((ExtensibilityElement)soapBinding);
            String style = null;
            for (BindingOperation originalBindingOp : originalBindingOps) {
                BindingOperation newBindingOp = defn.createBindingOperation();
                newBindingOp.setOperation(originalBindingOp.getOperation());
                Operation portTypeOperation = newBindingOp.getOperation();
                if (style == null && RPC_STYLE.equals(style = this.getStyle(portTypeOperation))) {
                    soapBinding.setStyle(style);
                }
                newBindingOp.setName(originalBindingOp.getName());
                newBindingOp.setDocumentationElement(originalBindingOp.getDocumentationElement());
                SOAPOperation soapOperation = this.createSoapOperation();
                newBindingOp.addExtensibilityElement((ExtensibilityElement)soapOperation);
                if (portTypeOperation.getInput() != null) {
                    BindingInput newBindingInput = defn.createBindingInput();
                    this.processElement((ElementExtensible)newBindingInput, portTypeOperation.getInput().getMessage(), style);
                    newBindingOp.setBindingInput(newBindingInput);
                }
                if (portTypeOperation.getOutput() != null) {
                    BindingOutput newBindingOutput = defn.createBindingOutput();
                    this.processElement((ElementExtensible)newBindingOutput, portTypeOperation.getOutput().getMessage(), style);
                    newBindingOp.setBindingOutput(newBindingOutput);
                }
                if (portTypeOperation.getFaults() != null) {
                    Map faults = portTypeOperation.getFaults();
                    for (String faultName : faults.keySet()) {
                        BindingFault newBindingFault = defn.createBindingFault();
                        newBindingFault.setName(faultName);
                        SOAPFault soapFault = this.createSoapFault();
                        soapFault.setName(faultName);
                        newBindingFault.addExtensibilityElement((ExtensibilityElement)soapFault);
                        newBindingOp.addBindingFault(newBindingFault);
                    }
                }
                newBinding.addBindingOperation(newBindingOp);
            }
            defn.removeBinding(originalBindingQname);
            defn.addBinding(newBinding);
        }
        return wsdlModified;
    }

    private void writeWSDL(Definition defn, String wsdl) throws Exception {
        defn.addNamespace(SOAP_PREFIX, SOAP_NS);
        FileWriter fw = new FileWriter(wsdl);
        this.wsdlWriter.writeWSDL(defn, (Writer)fw);
        fw.close();
    }

    public boolean convert(String wsdl) throws Exception {
        String wsdlLocationUri = new File(wsdl).toURI().toString();
        Definition defn = this.wsdlReader.readWSDL(wsdlLocationUri);
        boolean wsdlModified = false;
        wsdlModified = this.convertBindings(defn);
        wsdlModified = this.convertServices(defn);
        if (wsdlModified) {
            System.out.println("Modified WSDL : " + wsdl);
            this.writeWSDL(defn, wsdl);
        }
        return wsdlModified;
    }

    List<String> listWSDLs(File baseDir) {
        ArrayList<String> files = new ArrayList<String>();
        for (File f : baseDir.listFiles()) {
            if (f.isDirectory()) {
                files.addAll(this.listWSDLs(f));
                continue;
            }
            if (!f.getAbsolutePath().endsWith("wsdl")) continue;
            files.add(f.getAbsolutePath());
        }
        return files;
    }

    public List<String> convertAllWSDLs(String baseDir) {
        ArrayList<String> convertedWSDLs = new ArrayList<String>();
        List<String> wsdls = this.listWSDLs(new File(baseDir));
        for (String wsdl : wsdls) {
            try {
                if (!this.convert(wsdl)) continue;
                convertedWSDLs.add(wsdl.substring(baseDir.length() + 1));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("BaseDir = " + baseDir + ", Converted WSDLs = " + convertedWSDLs);
        return convertedWSDLs;
    }

    public static List<String> convertWSDLs(String baseDir) {
        try {
            WSDLConverter converter = new WSDLConverter();
            return converter.convertAllWSDLs(baseDir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new ArrayList<String>();
        }
    }

    void print(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) throws Exception {
        WSDLConverter.convertWSDLs("/tmp/wsdl");
    }
}

