/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.util.soap;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class StringTranslator {
    private static final String LOGGER_NAME = "com.sun.jbi.common.soap";
    public static final String RESOURCE_BUNDLE_NAME = "LocalStrings";
    private static final String LOG_NEW_INSTANCE = "New StringTranslator for package {0}, classLoader is {1}";
    private static final String LOG_CURRENT_LOCALE = "Current locale is {0}";
    private static final String LOG_UNABLE_TO_LOAD_BUNDLE = "Unable to load resource bundle {0} for locale {1}: {2}";
    private static final String LOG_USING_BUNDLE = "Using resource bundle for locale {0} instead.";
    private static final String LOG_TRANSLATION_USING_FALLBACK = "No translation for key={0} found in resource bundle for locale {1}, using locale {2} instead.";
    private static final String LOG_NO_TRANSLATION_FOR_KEY = "No translation for key={0} found in any resource bundle. Insert data is [{1}].";
    private static final String LOG_NO_TRANSLATION_FOR_KEY_IN_BUNDLE = "No translation for key={0} found in resource bundle for locale {1}. Insert data is [{2}].";
    private static final String MSG_NO_TRANSLATION = "No translation available for message with key={0} and inserts=[{1}].";
    private Locale mDefaultLocale;
    private Logger mLog;
    private ResourceBundle mFallbackBundle;
    private ResourceBundle mResourceBundle;
    private static StringTranslator defaultInstance;

    public StringTranslator() {
        this("com.sun.enterprise.jbi.serviceengine.core", null);
    }

    public static StringTranslator getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new StringTranslator();
        }
        return defaultInstance;
    }

    public StringTranslator(String packageName, ClassLoader classLoader) {
        this.mLog = Logger.getLogger(packageName);
        String bundleName = packageName + "." + RESOURCE_BUNDLE_NAME;
        this.mDefaultLocale = Locale.getDefault();
        this.mFallbackBundle = null;
        ResourceBundle englishBundle = null;
        try {
            englishBundle = null == classLoader ? ResourceBundle.getBundle(bundleName, Locale.US) : ResourceBundle.getBundle(bundleName, Locale.US, classLoader);
        }
        catch (MissingResourceException mrEx) {
            this.mLog.warning(MessageFormat.format(LOG_UNABLE_TO_LOAD_BUNDLE, bundleName, Locale.US, mrEx));
        }
        if (this.mDefaultLocale.equals(Locale.US)) {
            this.mResourceBundle = englishBundle;
        } else {
            try {
                if (null == classLoader) {
                    this.mResourceBundle = ResourceBundle.getBundle(bundleName);
                    this.mFallbackBundle = englishBundle;
                } else {
                    this.mResourceBundle = ResourceBundle.getBundle(bundleName, this.mDefaultLocale, classLoader);
                    this.mFallbackBundle = englishBundle;
                }
            }
            catch (MissingResourceException mrEx) {
                this.mLog.warning(MessageFormat.format(LOG_UNABLE_TO_LOAD_BUNDLE, bundleName, this.mDefaultLocale, mrEx));
                this.mLog.warning(MessageFormat.format(LOG_USING_BUNDLE, Locale.US));
                this.mResourceBundle = englishBundle;
            }
        }
    }

    public String getString(String key) {
        Object[] inserts = new Object[]{};
        return this.getString(key, inserts);
    }

    public String getString(String key, Object insert1) {
        Object[] inserts = new Object[]{insert1};
        return this.getString(key, inserts);
    }

    public String getString(String key, Object insert1, Object insert2) {
        Object[] inserts = new Object[]{insert1, insert2};
        return this.getString(key, inserts);
    }

    public String getString(String key, Object insert1, Object insert2, Object insert3) {
        Object[] inserts = new Object[]{insert1, insert2, insert3};
        return this.getString(key, inserts);
    }

    public String getString(String key, Object insert1, Object insert2, Object insert3, Object insert4) {
        Object[] inserts = new Object[]{insert1, insert2, insert3, insert4};
        return this.getString(key, inserts);
    }

    public String getString(String key, Object[] inserts) {
        String translated;
        block7: {
            translated = null;
            if (null != this.mResourceBundle) {
                try {
                    translated = this.mResourceBundle.getString(key);
                    translated = MessageFormat.format(translated, inserts);
                }
                catch (MissingResourceException mrEx) {
                    if (null != this.mFallbackBundle) {
                        try {
                            translated = this.mFallbackBundle.getString(key);
                            translated = MessageFormat.format(translated, inserts);
                            this.mLog.fine(MessageFormat.format(LOG_TRANSLATION_USING_FALLBACK, key, this.mDefaultLocale, Locale.US));
                        }
                        catch (MissingResourceException mreEx) {
                            String fi = this.formatInserts(inserts);
                            translated = MessageFormat.format(MSG_NO_TRANSLATION, key, fi);
                            this.mLog.warning(MessageFormat.format(LOG_NO_TRANSLATION_FOR_KEY, key, fi));
                        }
                        break block7;
                    }
                    String fi = this.formatInserts(inserts);
                    translated = MessageFormat.format(MSG_NO_TRANSLATION, key, fi);
                    this.mLog.warning(MessageFormat.format(LOG_NO_TRANSLATION_FOR_KEY_IN_BUNDLE, key, this.mDefaultLocale, fi));
                }
            } else {
                translated = MessageFormat.format(MSG_NO_TRANSLATION, key, this.formatInserts(inserts));
            }
        }
        return translated;
    }

    private String formatInserts(Object[] inserts) {
        StringBuffer formatted = new StringBuffer("");
        for (int i = 0; i < inserts.length; ++i) {
            if (i > 0) {
                formatted.append(",");
            }
            formatted.append(inserts[i].toString());
        }
        return formatted.toString();
    }
}

