/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransportImpl;
import com.sun.enterprise.jbi.serviceengine.comm.UnWrappedMessage;
import com.sun.enterprise.jbi.serviceengine.comm.WrappedMessage;
import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import java.util.logging.Level;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;

public class ProviderInOut
extends MessageExchangeTransportImpl {
    private InOut me;

    public ProviderInOut(InOut me) {
        super((MessageExchange)me);
        this.me = me;
    }

    public NormalizedMessage receiveNormalized() {
        this.msg = this.me.getInMessage();
        this.preReceive();
        return this.msg;
    }

    public UnWrappedMessage receive(EndpointMetaData emd) {
        NormalizedMessage normalizedMessage = this.receiveNormalized();
        UnWrappedMessage unwrappedMessage = null;
        if (normalizedMessage != null) {
            try {
                String operationName = this.me.getOperation().getLocalPart();
                unwrappedMessage = new UnWrappedMessage();
                unwrappedMessage.setNormalizedMessage(normalizedMessage);
                if (normalizedMessage instanceof Fault) {
                    unwrappedMessage.unwrapFault();
                } else {
                    unwrappedMessage.setWSDLMessageType(new QName(emd.getInputMessage(operationName).getQName().getNamespaceURI(), operationName));
                    unwrappedMessage.setWSDLBindingStyle(emd.getBindingStyle(operationName));
                    unwrappedMessage.setWSDLOrderedParts(emd.getInputMessage(operationName).getOrderedParts(null));
                    unwrappedMessage.setWSDLPartBindings(emd.getInputPartBindings(operationName));
                    unwrappedMessage.unwrap();
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return unwrappedMessage;
    }

    public void sendNormalized() throws Exception {
        if (this.msg instanceof Fault) {
            this.me.setFault((Fault)this.msg);
        } else {
            this.me.setOutMessage(this.msg);
        }
        this.send();
    }

    public void send(Packet packet, EndpointMetaData emd) throws Exception {
        Message message = packet.getMessage();
        String operationName = this.me.getOperation().getLocalPart();
        WrappedMessage wrappedMessage = new WrappedMessage();
        wrappedMessage.setAbstractMessage(message);
        if (message.isFault()) {
            wrappedMessage.wrapFault(operationName, emd);
            this.msg = this.me.createFault();
        } else {
            wrappedMessage.setWSDLBindingStyle(emd.getBindingStyle(operationName));
            wrappedMessage.setWSDLMessageType(emd.getOutputMessage(operationName).getQName());
            wrappedMessage.setWSDLMessageName(emd.getOperationOutputName(operationName));
            wrappedMessage.setWSDLOrderedParts(emd.getOutputMessage(operationName).getOrderedParts(null));
            wrappedMessage.setWSDLPartBindings(emd.getOutputPartBindings(operationName));
            wrappedMessage.wrap();
            this.msg = this.me.createMessage();
        }
        this.msg.setContent(wrappedMessage.readPayloadAsSource());
        this.setMessageProperties(packet.invocationProperties);
        this.sendNormalized();
    }
}

