/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.qos.redelivery;

import com.sun.jbi.common.qos.redelivery.RedeliveryConfig;
import com.sun.jbi.common.qos.redelivery.RedeliveryStatus;
import com.sun.jbi.common.qos.redelivery.Redirect;
import com.sun.jbi.common.util.Util;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;

public class Redelivery {
    public static final String REDELIVERY_NS = "http://www.sun.com/jbi/qos/redelivery";
    private static final String REDELIVERY_LAST_RETRY_TIME = "com.sun.jbi.common.qos.redelivery.lastRetryTime";
    private static final String REDELIVERY_TOTAL_RETRIES = "com.sun.jbi.common.qos.redelivery.totalRetries";
    private static final String REDELIVERY_REMAINING_RETRIES = "com.sun.jbi.common.qos.redelivery.remainingRetries";
    private static final String REDELIVERY_ERROR_DETAILS = "com.sun.jbi.common.qos.redelivery.errorDetails";
    private static final String REDELIVERY_FAILURE = "com.sun.jbi.common.qos.redelivery.failure";
    private static final String REDELIVERY_ORIGINAL_ENDPOINT = "com.sun.jbi.common.qos.redelivery.originalEndpoint";

    public static ServiceEndpoint getEndpoint(MessageExchange msg) {
        if (msg != null) {
            ServiceEndpoint endpt = (ServiceEndpoint)msg.getProperty(REDELIVERY_ORIGINAL_ENDPOINT);
            return endpt == null ? msg.getEndpoint() : endpt;
        }
        return null;
    }

    public static void setEndpoint(MessageExchange msg, ServiceEndpoint endpt) {
        if (msg != null) {
            msg.setProperty(REDELIVERY_ORIGINAL_ENDPOINT, (Object)endpt);
        }
    }

    public static String getUniqueId(MessageExchange msg) {
        if (msg == null) {
            return null;
        }
        String messageId = (String)msg.getProperty("com.sun.jbi.messaging.messageid");
        if (Util.isEmpty((String)messageId)) {
            return null;
        }
        String groupId = (String)msg.getProperty("com.sun.jbi.messaging.groupid");
        return Util.isEmpty((String)groupId) ? messageId : messageId + "." + groupId;
    }

    public static void setUniqueId(MessageExchange msg, String msgId) {
        Redelivery.setUniqueId(msg, msgId, null);
    }

    public static void setUniqueId(MessageExchange msg, String msgId, String groupId) {
        if (msg != null && !Util.isEmpty((String)msgId)) {
            msg.setProperty("com.sun.jbi.messaging.messageid", (Object)msgId);
            msg.setProperty("com.sun.jbi.messaging.groupid", (Object)groupId);
        }
    }

    public static RedeliveryConfig createRedeliveryConfig(int maxRetries, long retryInterval, RedeliveryConfig.Failure failure, Redirect redirect) {
        return new RDConfig(maxRetries, retryInterval, failure == null ? RedeliveryConfig.Failure.error : failure, redirect);
    }

    public static void setRedeliveryStatus(MessageExchange msg, Exception err) {
        if (msg != null) {
            msg.setProperty(REDELIVERY_ERROR_DETAILS, (Object)err);
        }
    }

    public static void setRedeliveryStatus(MessageExchange msg, long timestamp, int total, int remaining, Exception err, boolean failed) {
        if (msg != null) {
            msg.setProperty(REDELIVERY_LAST_RETRY_TIME, (Object)String.valueOf(timestamp));
            msg.setProperty(REDELIVERY_TOTAL_RETRIES, (Object)String.valueOf(total));
            msg.setProperty(REDELIVERY_REMAINING_RETRIES, (Object)String.valueOf(remaining));
            msg.setProperty(REDELIVERY_ERROR_DETAILS, (Object)err);
            msg.setProperty(REDELIVERY_FAILURE, (Object)Boolean.toString(failed));
        }
    }

    public static RedeliveryStatus getRedeliveryStatus(MessageExchange msg) {
        if (msg == null) {
            return null;
        }
        String guid = Redelivery.getUniqueId(msg);
        if (!Util.isEmpty((String)guid)) {
            return new RDStatus(Util.parseLong((String)((String)msg.getProperty(REDELIVERY_LAST_RETRY_TIME)), (long)-1L), Util.parseInt((String)((String)msg.getProperty(REDELIVERY_TOTAL_RETRIES)), (int)-1), Util.parseInt((String)((String)msg.getProperty(REDELIVERY_REMAINING_RETRIES)), (int)-1), (Exception)msg.getProperty(REDELIVERY_ERROR_DETAILS), Boolean.valueOf(String.valueOf(msg.getProperty(REDELIVERY_FAILURE))));
        }
        return null;
    }

    private static class RDStatus
    implements RedeliveryStatus {
        private int mTotal;
        private int mRemaining;
        private long mLastRetry;
        private Exception mLastError;
        private boolean mFailed;

        public RDStatus(long lastRetry, int total, int remaining, Exception err, boolean failed) {
            this.mLastRetry = lastRetry;
            this.mTotal = total;
            this.mRemaining = remaining;
            this.mLastError = err;
            this.mFailed = failed;
        }

        public Exception getError() {
            return this.mLastError;
        }

        public long getLastRetryTime() {
            return this.mLastRetry;
        }

        public int getRemainingRetries() {
            return this.mRemaining;
        }

        public int getTotalRetries() {
            return this.mTotal;
        }

        public boolean hasFailed() {
            return this.mFailed;
        }
    }

    private static class RDConfig
    implements RedeliveryConfig {
        private Redirect mRedirect;
        private int mMaxRetries;
        private long mRetryInterval;
        private RedeliveryConfig.Failure mFailure;

        public RDConfig(int maxRetries, long retryInterval, RedeliveryConfig.Failure failure, Redirect redirect) {
            this.mRedirect = redirect;
            this.mMaxRetries = maxRetries;
            this.mRetryInterval = retryInterval;
            this.mFailure = failure;
        }

        public RedeliveryConfig.Failure getFailure() {
            return this.mFailure;
        }

        public int getMaxRetries() {
            return this.mMaxRetries;
        }

        public Redirect getRedirect() {
            return this.mRedirect;
        }

        public long getRetryInterval() {
            return this.mRetryInterval;
        }
    }
}

