/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.AbstractEndpoint;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.HttpSoapBindingLifeCycle;
import com.sun.jbi.httpsoapbc.HttpSoapEndpoint;
import com.sun.jbi.httpsoapbc.util.AlertsUtil;
import com.sun.jbi.internationalization.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HttpSoapBindingComponent
implements Component {
    private static final String WS_ADDRESSING_NS = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private static final Messages mMessages = Messages.getMessages(HttpSoapBindingComponent.class);
    private static final Logger mLogger = Messages.getLogger(HttpSoapBindingComponent.class);
    private HttpSoapBindingLifeCycle mComponentLifeCycle = new HttpSoapBindingLifeCycle();

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        Document result = null;
        String uniqueName = AbstractEndpoint.getUniqueName(endpoint.getServiceName().getNamespaceURI(), endpoint.getServiceName().getLocalPart(), endpoint.getEndpointName(), false);
        Map endpoints = this.mComponentLifeCycle.getEndpointBeans();
        HttpSoapEndpoint foundEndpoint = (HttpSoapEndpoint)endpoints.get(uniqueName);
        if (foundEndpoint == null) {
            if (mLogger.isLoggable(Level.FINE)) {
                mLogger.log(Level.FINE, "Endpoint " + uniqueName + " could not be located in this binding component.");
            }
        } else {
            result = foundEndpoint.getServiceDescriptorAsDocument();
        }
        return result;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
        MyServiceEndpoint sep;
        block9: {
            sep = null;
            Endpoint endpoint = null;
            try {
                NodeList children = epr.getChildNodes();
                if (children != null && children.getLength() > 1) {
                    endpoint = this.getEndpointInfo(epr);
                } else if (children.getLength() == 1) {
                    Node child = children.item(0);
                    endpoint = this.getEndpointInfo(child);
                } else {
                    throw new Exception(mMessages.getString("HttpSoapBindingComponent.Invalid_epr_format"));
                }
                if (endpoint != null) {
                    sep = new MyServiceEndpoint(endpoint.getServiceName(), endpoint.getEndpointName(), null, epr);
                } else if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "HTTP BC can't locate an activated endpoint with the service/endpoint name specified in the endpoint reference document fragment. Returning null...");
                }
            }
            catch (Exception e) {
                if (!mLogger.isLoggable(Level.WARNING)) break block9;
                String text = mMessages.getString("HTTPBC-W00671.Exception_during_endpoint_resolution", (Object)e.getLocalizedMessage());
                mLogger.log(Level.WARNING, text, e);
                AlertsUtil.getAlerter().warning(text, "sun-http-binding", null, AlertsUtil.getServerType(), "BindingComponent", 7, "Alert", "HTTPBC-W00671");
            }
        }
        return sep;
    }

    private Endpoint getEndpointInfo(Node parentNode) throws Exception {
        Endpoint endpoint = null;
        String urlLocation = null;
        URL url = null;
        Map endpoints = this.mComponentLifeCycle.getEndpointBeans();
        NodeList children = parentNode.getChildNodes();
        for (int ii = 0; ii < children.getLength(); ++ii) {
            String namespaceURI;
            Node child = children.item(ii);
            if ("Address".equalsIgnoreCase(child.getLocalName()) && WS_ADDRESSING_NS.equals(child.getNamespaceURI())) {
                urlLocation = child.getTextContent().trim();
            }
            if (!"ServiceName".equalsIgnoreCase(child.getLocalName()) || !WS_ADDRESSING_NS.equals(child.getNamespaceURI())) continue;
            NamedNodeMap attributes = child.getAttributes();
            Node portNode = attributes.getNamedItem("PortName");
            String content = child.getTextContent().trim();
            int index = content.indexOf(":");
            if (index <= 0) {
                throw new Exception(mMessages.getString("HTTPBC-E00305.Service_name_invalid", (Object)content));
            }
            String prefix = content.substring(0, index);
            String serviceLocalName = content.substring(index + 1);
            String string = namespaceURI = child.lookupNamespaceURI(prefix) == null ? parentNode.lookupNamespaceURI(prefix) : child.lookupNamespaceURI(prefix);
            if (namespaceURI == null) {
                throw new Exception(mMessages.getString("HTTPBC-E00306.Namespace_prefix_not_defined", (Object)prefix));
            }
            String endpointName = portNode != null ? portNode.getNodeValue() : null;
            QName serviceQName = new QName(namespaceURI, serviceLocalName);
            String uniqueName = AbstractEndpoint.getUniqueName(serviceQName.getNamespaceURI(), serviceQName.getLocalPart(), endpointName, false);
            if (uniqueName == null || endpoints.get(uniqueName) == null) continue;
            endpoint = (Endpoint)endpoints.get(uniqueName);
        }
        if (endpoint != null) {
            if (urlLocation == null) {
                throw new Exception(mMessages.getString("HTTPBC-E00307.Address_invalid"));
            }
            try {
                url = new URL(urlLocation);
            }
            catch (MalformedURLException e) {
                if (mLogger.isLoggable(Level.FINE)) {
                    mLogger.log(Level.FINE, "Attribute value for wsa:Address element is not a valid URL: " + urlLocation + ". The endpoint reference document fragment may not be targeted for HTTP BC, ignoring it...");
                }
                return null;
            }
            endpoint.setIsDynamicEPR(true);
            endpoint.setDynamicEPRUrl(url);
        }
        return endpoint;
    }

    public ComponentLifeCycle getLifeCycle() {
        return this.mComponentLifeCycle;
    }

    public ServiceUnitManager getServiceUnitManager() {
        return this.mComponentLifeCycle.getServiceUnitManager();
    }

    class MyServiceEndpoint
    implements ServiceEndpoint {
        private DocumentFragment mEpr;
        private QName mServiceName;
        private String mEndpointName;
        private QName mInterfaceName;

        MyServiceEndpoint(QName serviceName, String endpointName, QName interfaceName, DocumentFragment epr) {
            this.mEpr = epr;
            this.mServiceName = serviceName;
            this.mEndpointName = endpointName;
            this.mInterfaceName = interfaceName;
        }

        public QName getServiceName() {
            return this.mServiceName;
        }

        public String getEndpointName() {
            return this.mEndpointName;
        }

        public DocumentFragment getAsReference(QName operation) {
            return this.mEpr;
        }

        public QName[] getInterfaces() {
            QName[] qNameArray;
            if (this.mInterfaceName != null) {
                QName[] qNameArray2 = new QName[1];
                qNameArray = qNameArray2;
                qNameArray2[0] = this.mInterfaceName;
            } else {
                qNameArray = null;
            }
            return qNameArray;
        }
    }
}

