/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hulp.profiler;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.hulp.profiler.Profiler;
import net.sf.hulp.util.Markup;
import net.sf.hulp.util.MarkupHtml;

public class ProfilerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1777967092267346221L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MarkupHtml f = new MarkupHtml();
        if (request.getQueryString() == null) {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.print(f.pageFrame());
        } else if ("menu".equals(request.getQueryString())) {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println(new MarkupHtml.Menu("Profiler").add("?cmd=dump", "Dump").add("?cmd=dumptext", "Dump text").add("?cmd=clear", "Clear").add("?cmd=help", "Help"));
        } else if ("body".equals(request.getQueryString()) || "help".equals(request.getParameter("cmd"))) {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println(f.beginPage());
            Profiler.get().help(out, f);
            out.println(f.endPage());
        } else if ("dump".equals(request.getParameter("cmd"))) {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println(f.beginPage());
            this.dump(out, f);
            out.println(f.endPage());
        } else if ("dumptext".equals(request.getParameter("cmd"))) {
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            Markup ftext = new Markup();
            this.dump(out, ftext);
        } else if ("clear".equals(request.getParameter("cmd"))) {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println(f.beginPage());
            out.println(f.beginArea() + "This will clear all accumulated measurements.");
            out.println("<br><br>Proceed? ");
            out.println("<a href='?cmd=wipe'>Yes</a>");
            out.println(f.endPage());
        } else if ("wipe".equals(request.getParameter("cmd"))) {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println(f.beginPage());
            this.clear(out, f);
            out.println(f.endPage());
        } else {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println(f.beginPage());
            out.println("Unknown request " + request.getRequestURL() + " ... " + request.getQueryString());
            out.println(f.endPage());
        }
    }

    public void dump(PrintWriter out, Markup f) throws IOException, ServletException {
        out.println(f.beginTable(2));
        Profiler.get().dump(out, f);
        out.println(f.endTable());
    }

    public void clear(PrintWriter out, Markup f) throws IOException, ServletException {
        Profiler.get().clear();
        out.println("Cleared");
    }
}

