/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.security.impl;

import com.sun.jbi.httpsoapbc.configuration.RuntimeConfigurationMBean;
import com.sun.jbi.httpsoapbc.extensions.BasicAuthenticationDetail;
import com.sun.jbi.httpsoapbc.extensions.Policy;
import com.sun.jbi.httpsoapbc.extensions.RealmValidation;
import com.sun.jbi.httpsoapbc.extensions.StringCompareValidation;
import com.sun.jbi.httpsoapbc.extensions.ValidationBaseType;
import com.sun.jbi.httpsoapbc.security.am.impl.SunAccessManagerCredentialValidator;
import com.sun.jbi.httpsoapbc.security.api.CredentialValidationException;
import com.sun.jbi.httpsoapbc.security.api.CredentialValidator;
import com.sun.jbi.httpsoapbc.security.realm.impl.SunRealmCredentialValidator;
import com.sun.jbi.httpsoapbc.security.sc.impl.SunStringCompareCredentialValidator;
import com.sun.jbi.internationalization.Messages;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CredentialValidatorManager {
    private static final Messages mMessages = Messages.getMessages(CredentialValidatorManager.class);
    private Map<String, SunStringCompareCredentialValidator> scValidators;
    private SunAccessManagerCredentialValidator amValidator;
    private Map<String, RealmRefCount> realmValidators;
    private RuntimeConfigurationMBean rtc;

    public CredentialValidatorManager(RuntimeConfigurationMBean rtc) {
        this.rtc = rtc;
        this.scValidators = Collections.synchronizedMap(new HashMap());
        this.realmValidators = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CredentialValidator acquireCredentialValidator(String uniqueEndpointName, Policy authPolicy) throws CredentialValidationException {
        BasicAuthenticationDetail.CredentialValidationType cvType = authPolicy.getBasicAuthenticationDetail().getCredentialValidationType();
        ValidationBaseType vbt = authPolicy.getBasicAuthenticationDetail().getCredentialValidation();
        CredentialValidator cv = null;
        switch (cvType) {
            case StringCompare: {
                Map<String, SunStringCompareCredentialValidator> map = this.scValidators;
                synchronized (map) {
                    if (!this.scValidators.containsKey(uniqueEndpointName)) {
                        StringCompareValidation sv = (StringCompareValidation)vbt;
                        SunStringCompareCredentialValidator scv = new SunStringCompareCredentialValidator(uniqueEndpointName, sv.getUsername(), sv.getPassword());
                        this.scValidators.put(uniqueEndpointName, scv);
                    }
                    cv = this.scValidators.get(uniqueEndpointName);
                    break;
                }
            }
            case AM: {
                if (this.amValidator == null) {
                    try {
                        this.amValidator = new SunAccessManagerCredentialValidator(this.rtc);
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        String err = mMessages.getString("HTTPBC-E01037.AM_credential_validator_create_failed_no_AM_client_library");
                        throw new CredentialValidationException(err, ncdfe);
                    }
                    catch (Throwable t) {
                        String err = mMessages.getString("HTTPBC-E01038.AM_credential_validator_create_failed_unexpected_runtime_error", new Object[]{t.getLocalizedMessage()});
                        throw new CredentialValidationException(err, t);
                    }
                }
                cv = this.amValidator;
                break;
            }
            case Realm: {
                RealmValidation rv = (RealmValidation)vbt;
                String realm = rv.getRealmName();
                Map<String, RealmRefCount> map = this.realmValidators;
                synchronized (map) {
                    if (!this.realmValidators.containsKey(realm)) {
                        try {
                            SunRealmCredentialValidator rcv = new SunRealmCredentialValidator(realm);
                            RealmRefCount rrc = new RealmRefCount(rcv);
                            this.realmValidators.put(realm, rrc);
                        }
                        catch (NoClassDefFoundError ncdfe) {
                            String err = mMessages.getString("HTTPBC-E01039.Realm_credential_validator_create_failed_no_Realm_client_library");
                            throw new CredentialValidationException(err, ncdfe);
                        }
                        catch (Throwable t) {
                            String err = mMessages.getString("HTTPBC-E01040.Realm_credential_validator_create_failed_unexpected_runtime_error", new Object[]{t.getLocalizedMessage()});
                            throw new CredentialValidationException(err, t);
                        }
                    }
                    cv = this.realmValidators.get(realm).acquireValidator();
                    break;
                }
            }
        }
        return cv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCredentialValidator(CredentialValidator cv) {
        if (cv instanceof SunStringCompareCredentialValidator) {
            SunStringCompareCredentialValidator scv = (SunStringCompareCredentialValidator)cv;
            Map<String, SunStringCompareCredentialValidator> map = this.scValidators;
            synchronized (map) {
                this.scValidators.remove(scv.getEndpointName());
            }
        }
        if (cv instanceof SunRealmCredentialValidator) {
            SunRealmCredentialValidator rv = (SunRealmCredentialValidator)cv;
            Map<String, RealmRefCount> map = this.realmValidators;
            synchronized (map) {
                RealmRefCount rrc = this.realmValidators.get(rv.getRealmName());
                rrc.releaseValidator();
                if (rrc.canDestroy()) {
                    this.realmValidators.remove(rv.getRealmName());
                }
            }
        }
    }

    private class RealmRefCount {
        private int refcount = 0;
        private SunRealmCredentialValidator rv;

        RealmRefCount(SunRealmCredentialValidator rv) {
            this.rv = rv;
        }

        CredentialValidator acquireValidator() {
            ++this.refcount;
            return this.rv;
        }

        void releaseValidator() {
            --this.refcount;
        }

        boolean canDestroy() {
            return this.refcount == 0;
        }
    }
}

