/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.management.message;

import com.sun.jbi.management.message.ComponentTaskResult;
import com.sun.jbi.management.message.FrameworkTaskResult;
import com.sun.jbi.management.message.JBIMessageElement;
import com.sun.jbi.management.message.JBIMessageException;
import com.sun.jbi.util.JBIUtils;
import java.util.List;
import java.util.logging.Logger;

public class JBITaskResult
extends JBIMessageElement {
    private static final Logger logger = Logger.getLogger(JBITaskResult.class.getName());
    public static final String ELEMENT_NAME = "jbi-task-result";
    private FrameworkTaskResult frameworkTaskResult;
    private List componentTaskResults;

    protected String buildString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t<");
        buffer.append(ELEMENT_NAME);
        buffer.append(">\n");
        buffer.append(this.getFrameworkTaskResult().getString());
        if (this.componentTaskResults != null) {
            for (ComponentTaskResult componentTaskResult : this.componentTaskResults) {
                buffer.append(componentTaskResult.getString());
            }
        }
        buffer.append("\t</");
        buffer.append(ELEMENT_NAME);
        buffer.append(">\n");
        return buffer.toString();
    }

    public void validate() throws JBIMessageException {
        if (this.frameworkTaskResult == null) {
            logger.warning("Framework task result has not been set");
        }
    }

    public FrameworkTaskResult getFrameworkTaskResult() {
        if (this.frameworkTaskResult == null) {
            this.frameworkTaskResult = new FrameworkTaskResult();
        }
        return this.frameworkTaskResult;
    }

    public void setFrameworkTaskResult(FrameworkTaskResult frameworkTaskResult) throws JBIMessageException {
        if (frameworkTaskResult == null) {
            throw new JBIMessageException("Framework task result cannot be null");
        }
        this.frameworkTaskResult = frameworkTaskResult;
    }

    public List getComponentTaskResults() {
        if (this.componentTaskResults == null) {
            this.componentTaskResults = JBIUtils.createSafeList(ComponentTaskResult.class, false, false);
        }
        return this.componentTaskResults;
    }

    public ComponentTaskResult newComponentTaskResult() {
        ComponentTaskResult componentTaskResult = new ComponentTaskResult();
        this.getComponentTaskResults().add(componentTaskResult);
        return componentTaskResult;
    }

    public void addComponentTaskResult(ComponentTaskResult componentTaskResult) throws JBIMessageException {
        if (componentTaskResult == null) {
            throw new JBIMessageException("Component task result cannot be null");
        }
        this.getComponentTaskResults().add(componentTaskResult);
    }

    public void removeComponentTaskResult(ComponentTaskResult componentTaskResult) throws JBIMessageException {
        if (componentTaskResult == null) {
            throw new JBIMessageException("Cannot remove null component");
        }
        if (this.componentTaskResults == null) {
            throw new JBIMessageException("Empty component result list, cannot remove");
        }
        if (!this.componentTaskResults.remove(componentTaskResult)) {
            throw new JBIMessageException("Component result not in list, cannot remove");
        }
    }

    public void setComponentTaskResults(List componentTaskResults) throws JBIMessageException {
        JBIUtils.validateCollection(componentTaskResults, ComponentTaskResult.class);
        this.componentTaskResults = componentTaskResults;
    }
}

