/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.validation.conf.wsi.bp.soap.api;

import com.sun.jbi.httpsoapbc.validation.conf.wsi.api.WSIConstants;
import com.sun.jbi.httpsoapbc.validation.conf.wsi.api.WSIValidationException;
import com.sun.jbi.httpsoapbc.validation.conf.wsi.bp.soap.api.SOAPMsgValidator;
import com.sun.jbi.httpsoapbc.validation.conf.wsi.bp.v10.impl.BPv10SOAPMsgValidatorImpl;
import com.sun.jbi.internationalization.Messages;

public class SOAPValidatorFactory {
    private static final Messages messages = Messages.getMessages(WSIConstants.class);

    private SOAPValidatorFactory() {
    }

    public static SOAPValidatorFactory getInstance() {
        return LazyHolder.instance;
    }

    public SOAPMsgValidator createSOAPMsgValidator(String bpVersion, String level) throws WSIValidationException {
        if (bpVersion == null) {
            bpVersion = "1.0";
        }
        if (level == null) {
            level = "Error";
        }
        if (bpVersion.equals("1.0")) {
            return new BPv10SOAPMsgValidatorImpl(level);
        }
        throw new WSIValidationException(messages.getString("BP_Version_Not_Supported", (Object)bpVersion));
    }

    private static class LazyHolder {
        static final SOAPValidatorFactory instance = new SOAPValidatorFactory();

        private LazyHolder() {
        }
    }
}

