/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.OperationMetaData;
import com.sun.jbi.httpsoapbc.OperationResolveException;
import com.sun.jbi.httpsoapbc.util.HttpGetStringUtil;
import com.sun.jbi.internationalization.Messages;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationResolver2 {
    private static final Logger mLogger = Messages.getLogger(OperationResolver2.class);
    private static final Messages mMessages = Messages.getMessages(OperationResolver2.class);

    public static OperationMetaData resolveOperation(MessageContext msgContext, String endpointUrlContext, Map metaDataMap) throws OperationResolveException {
        String httpEncoding = OperationResolver2.determineUrlEncoding(msgContext);
        if ("unspecified".equals(httpEncoding)) {
            String msg = mMessages.getString("HTTPBC-E00746.Unspecified_WSDL_HTTP_URL_encoding");
            throw new OperationResolveException(msg);
        }
        String operationLocation = OperationResolver2.determineOperationLocation(msgContext, endpointUrlContext);
        if (operationLocation == null) {
            String msg = mMessages.getString("HTTPBC-E00730.Operation_location_not_found", new Object[]{OperationResolver2.retrieveQueryString(msgContext), endpointUrlContext});
            throw new OperationResolveException(msg);
        }
        Set<OperationMetaData> operationMetaDataSet = new HashSet<OperationMetaData>(metaDataMap.values());
        if ((operationMetaDataSet = OperationResolver2.filterByEncoding(operationMetaDataSet, httpEncoding)).isEmpty()) {
            String msg = mMessages.getString("HTTPBC-E00731.Operation_location_encoding_not_found", (Object)httpEncoding);
            throw new OperationResolveException(msg);
        }
        if ((operationMetaDataSet = OperationResolver2.filterByOperationLocation(operationMetaDataSet, operationLocation, httpEncoding)).size() != 1) {
            if (operationMetaDataSet.isEmpty()) {
                String msg = mMessages.getString("HTTPBC-E00732.Operation_filteredby_encoding_no_match", new Object[]{operationLocation, httpEncoding});
                throw new OperationResolveException(msg);
            }
            String msg = mMessages.getString("HTTPBC-E00733.Operation_multiples_match", new Object[]{operationLocation, httpEncoding, operationMetaDataSet.size()});
            throw new OperationResolveException(msg);
        }
        OperationMetaData ret = (OperationMetaData)operationMetaDataSet.toArray()[0];
        if (mLogger.isLoggable(Level.FINE)) {
            mLogger.log(Level.FINE, "Matching operation '" + ret.getHttpOperationLocation() + "' for location '" + operationLocation + "' and encoding '" + httpEncoding + "'");
        }
        return ret;
    }

    private static String retrieveQueryString(MessageContext msgContext) {
        String queryString = (String)msgContext.get((Object)"javax.xml.ws.http.request.querystring");
        if ("".equals(queryString) || queryString == null) {
            queryString = (String)msgContext.get((Object)"javax.xml.ws.http.request.pathinfo");
        }
        if ("".equals(queryString)) {
            queryString = null;
        }
        return queryString;
    }

    private static String determineUrlEncoding(MessageContext msgContext) {
        String verb = String.valueOf(msgContext.get((Object)"javax.xml.ws.http.request.method"));
        if ("POST".equals(verb)) {
            return "urlEncoded";
        }
        String queryString = (String)msgContext.get((Object)"javax.xml.ws.http.request.querystring");
        if (queryString != null && !"".equals(queryString)) {
            return "urlEncoded";
        }
        queryString = (String)msgContext.get((Object)"javax.xml.ws.http.request.pathinfo");
        if (queryString != null && !"".equals(queryString)) {
            return "urlReplacement";
        }
        return "unspecified";
    }

    private static String determineOperationLocation(MessageContext msgContext, String contextPath) {
        StringBuffer location = new StringBuffer((String)msgContext.get((Object)"javax.xml.ws.http.request.pathinfo"));
        String operationLocation = null;
        if (location != null) {
            boolean denormalizeLocation = false;
            if (!contextPath.endsWith("/")) {
                contextPath = contextPath.concat("/");
            }
            if (location.length() == 0 || location.charAt(location.length() - 1) != '/') {
                location.append("/");
                denormalizeLocation = true;
            }
            if (contextPath.length() <= location.length() && location.subSequence(0, contextPath.length()).equals(contextPath)) {
                operationLocation = !denormalizeLocation ? location.substring(contextPath.length()) : (location.length() != contextPath.length() ? location.substring(contextPath.length(), location.length() - 1) : location.substring(contextPath.length()));
            }
        }
        return operationLocation;
    }

    private static Set filterByEncoding(Set<OperationMetaData> operationMetaDataSet, String httpEncoding) {
        Iterator<OperationMetaData> iter = operationMetaDataSet.iterator();
        while (iter.hasNext()) {
            OperationMetaData meta = iter.next();
            if (httpEncoding.equals(meta.getHttpUrlEncoding())) continue;
            iter.remove();
        }
        return operationMetaDataSet;
    }

    private static Set filterByOperationLocation(Set<OperationMetaData> operationMetaDataSet, String operationLocation, String httpEncoding) {
        block5: {
            block4: {
                if (!"urlEncoded".equals(httpEncoding)) break block4;
                Iterator<OperationMetaData> iter = operationMetaDataSet.iterator();
                while (iter.hasNext()) {
                    OperationMetaData meta = iter.next();
                    if (meta.getHttpOperationLocation().equals(operationLocation)) continue;
                    iter.remove();
                }
                break block5;
            }
            if (!"urlReplacement".equals(httpEncoding)) break block5;
            Iterator<OperationMetaData> iter = operationMetaDataSet.iterator();
            while (iter.hasNext()) {
                OperationMetaData meta = iter.next();
                try {
                    HttpGetStringUtil.extractNameValuePairs(operationLocation, meta.getHttpOperationLocation());
                }
                catch (HttpGetStringUtil.PatternMatchException e) {
                    iter.remove();
                }
            }
        }
        return operationMetaDataSet;
    }
}

