/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.embedded;

import com.sun.enterprise.web.connector.grizzly.AsyncReadTask;
import com.sun.enterprise.web.connector.grizzly.HtmlHelper;
import com.sun.enterprise.web.connector.grizzly.LinkedListPipeline;
import com.sun.enterprise.web.connector.grizzly.ReadTask;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.jbi.httpsoapbc.Endpoint;
import com.sun.jbi.httpsoapbc.HttpSoapBindingLifeCycle;
import com.sun.jbi.httpsoapbc.RequestThrottlingController;
import com.sun.jbi.internationalization.Messages;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LinkedListThrottlePipeline
extends LinkedListPipeline
implements RequestThrottlingController {
    private static final Messages mMessages = Messages.getMessages(LinkedListThrottlePipeline.class);
    private static final Logger mLogger = Messages.getLogger(LinkedListThrottlePipeline.class);
    private SelectorThread st;
    private static final String QUERY_STRING = "?";
    private static final String PATH_STRING = "/";
    private HttpSoapBindingLifeCycle lifeCycle;
    private ExecutorService resumeThreadPool;
    protected ConcurrentHashMap<String, ConcurrentLinkedQueue<SelectionKeyByteBuffer>> suspendedKeys = new ConcurrentHashMap();
    protected ConcurrentLinkedQueue<ByteBuffer> bbPool = new ConcurrentLinkedQueue();

    public synchronized void addTask(Task task) {
        if (mLogger.isLoggable(Level.FINER)) {
            mLogger.log(Level.FINER, "addTask called with Task [" + task + "]");
        }
        if (task.getType() == 1) {
            String requestURI = null;
            ByteBuffer bb = this.getReadByteBuffer();
            try {
                requestURI = this.peekRequestURI((ReadTask)task, bb);
            }
            catch (Throwable t) {
                AsyncReadTask asyncRT = (AsyncReadTask)task;
                asyncRT.terminate(false);
                this.returnReadByteBuffer(bb);
                if (mLogger.isLoggable(Level.FINER)) {
                    mLogger.log(Level.FINER, "Client has closed the socket...");
                }
                return;
            }
            if (requestURI != null) {
                int port;
                Endpoint endpoint;
                if (mLogger.isLoggable(Level.FINER)) {
                    mLogger.log(Level.FINER, "Request URI is '" + requestURI + "'");
                }
                if ((endpoint = this.lifeCycle.getEndpointBeanForContext(requestURI, port = task.getSelectorThread().getPort())) != null && endpoint.getMaxConcurrencyLimit() > 0) {
                    int maxConcurrencyLimit = endpoint.getMaxConcurrencyLimit();
                    endpoint.setInboundRequestThrottlingController(this);
                    int pendingExchangeReplies = endpoint.getPendingExchangeReplies();
                    if (mLogger.isLoggable(Level.FINER)) {
                        mLogger.log(Level.FINER, "Found Endpoint for request URI '" + requestURI + "' and port '" + port + "'; maxConcurrencyLimit=" + maxConcurrencyLimit + ", pendingExchangeReplies=" + pendingExchangeReplies);
                    }
                    String key = requestURI + ":" + port;
                    if (maxConcurrencyLimit != -1 && pendingExchangeReplies >= maxConcurrencyLimit) {
                        task.getSelectionKey().attach(null);
                        this.st = task.getSelectorThread();
                        if (!this.suspendedKeys.containsKey(key)) {
                            this.suspendedKeys.put(key, new ConcurrentLinkedQueue());
                        }
                        ConcurrentLinkedQueue<SelectionKeyByteBuffer> linkQ = this.suspendedKeys.get(key);
                        SelectionKey sk = task.getSelectionKey();
                        SelectionKeyByteBuffer skbb = new SelectionKeyByteBuffer(sk, bb);
                        linkQ.offer(skbb);
                        task.recycle();
                        this.st.returnTask(task);
                        if (mLogger.isLoggable(Level.FINER)) {
                            mLogger.log(Level.FINER, "Request URI '" + requestURI + "', port '" + port + "'; SUSPENDED Selectionkey [" + sk + "], ByteBuffer [" + bb + "] from Task [" + task + "]; suspended size=" + linkQ.size());
                        }
                        return;
                    }
                }
                ((ReadTask)task).getByteBuffer().put(bb);
                if (mLogger.isLoggable(Level.FINER)) {
                    mLogger.log(Level.FINER, "ReadTask ByteBuffer [" + ((ReadTask)task).getByteBuffer() + "]");
                }
                ((ReadTask)task).setBytesAvailable(true);
                if (endpoint != null) {
                    endpoint.incrementPendingExchangeReplies();
                }
            }
            this.returnReadByteBuffer(bb);
        }
        super.addTask(task);
    }

    public void resumeSuspendedRequests(Endpoint endpoint) {
        if (this.resumeThreadPool == null) {
            this.resumeThreadPool = Executors.newCachedThreadPool();
        }
        this.resumeThreadPool.submit(new ResumerTask(this, endpoint));
    }

    public synchronized void cleanup() {
        if (this.resumeThreadPool != null) {
            this.resumeThreadPool.shutdown();
            if (mLogger.isLoggable(Level.FINER)) {
                mLogger.log(Level.FINER, "shutdown resume task thread pool");
            }
        }
        if (this.suspendedKeys != null && this.suspendedKeys.size() > 0) {
            for (String uriPort : this.suspendedKeys.keySet()) {
                String uri = uriPort.substring(0, uriPort.indexOf(":"));
                String port = uriPort.substring(uriPort.indexOf(":") + 1, uriPort.length());
                ConcurrentLinkedQueue<SelectionKeyByteBuffer> linkQ = this.suspendedKeys.remove(uri);
                if (linkQ != null && linkQ.size() > 0) {
                    Iterator<SelectionKeyByteBuffer> iter2 = linkQ.iterator();
                    while (iter2.hasNext()) {
                        SelectionKeyByteBuffer ssbb = linkQ.poll();
                        SelectionKey selkey = ssbb.getSelectionKey();
                        try {
                            ReadTask task = this.st.getReadTask(selkey);
                            task.cancelTask("No resources available.", HtmlHelper.OK);
                        }
                        catch (Throwable t) {
                            String error = mMessages.getString("HTTPBC-E00671.Exception_during_cancel_suspended_selectionkey", new Object[]{uri, port, selkey, t.getLocalizedMessage()});
                            mLogger.log(Level.WARNING, error, t);
                        }
                    }
                }
                if (!mLogger.isLoggable(Level.FINER)) continue;
                mLogger.log(Level.FINER, "cancelled all suspended selection key read tasks for URI '" + uri + "' on port '" + port + "'");
            }
        }
    }

    public void setHttpSoapBindingLifeCycle(HttpSoapBindingLifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    protected String peekRequestURI(ReadTask readTask, ByteBuffer byteBuffer) throws Exception {
        SocketChannel socketChannel = (SocketChannel)readTask.getSelectionKey().channel();
        String token = null;
        if (socketChannel.isOpen()) {
            socketChannel.read(byteBuffer);
            int limit = byteBuffer.limit();
            int position = byteBuffer.position();
            if (this.parse(byteBuffer)) {
                boolean slash;
                byte[] chars = new byte[byteBuffer.limit() - byteBuffer.position()];
                byteBuffer.get(chars);
                token = new String(chars);
                int index = token.indexOf(32);
                if (index != -1) {
                    token = token.substring(0, index);
                }
                if ((index = token.indexOf(QUERY_STRING)) != -1) {
                    token = token.substring(0, index);
                }
                if (slash = token.endsWith(PATH_STRING)) {
                    token = token.substring(0, token.length() - 1);
                }
            }
            byteBuffer.limit(limit);
            byteBuffer.position(position);
            byteBuffer.flip();
        }
        return token;
    }

    protected ByteBuffer getReadByteBuffer() {
        int size = 1028;
        ByteBuffer bb = this.bbPool.poll();
        if (bb == null) {
            bb = ByteBuffer.allocate(size);
        }
        return bb;
    }

    protected void returnReadByteBuffer(ByteBuffer bb) {
        bb.clear();
        this.bbPool.offer(bb);
    }

    protected void internalAddTask(Task task) {
        super.addTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(ByteBuffer byteBuffer) {
        boolean isFound = false;
        int curPosition = byteBuffer.position();
        int curLimit = byteBuffer.limit();
        if (byteBuffer.position() == 0) {
            return false;
        }
        byteBuffer.position(0);
        byteBuffer.limit(curPosition);
        int state = 0;
        int start = 0;
        int end = 0;
        try {
            block10: while (byteBuffer.hasRemaining()) {
                byte c = byteBuffer.get();
                switch (state) {
                    case 0: {
                        if (c != 32) continue block10;
                        state = 1;
                        start = byteBuffer.position();
                        continue block10;
                    }
                    case 1: {
                        if (c != 32) continue block10;
                        end = byteBuffer.position() - 1;
                        boolean bl = true;
                        return bl;
                    }
                }
                throw new IllegalArgumentException("Unexpected state");
            }
            boolean bl = false;
            return bl;
        }
        catch (BufferUnderflowException bue) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (end > 0) {
                byteBuffer.position(start);
                byteBuffer.limit(end);
            } else {
                byteBuffer.limit(curLimit);
                byteBuffer.position(curPosition);
            }
        }
    }

    class ResumerTask
    implements Runnable {
        LinkedListThrottlePipeline pipeline;
        Endpoint endpoint;

        ResumerTask(LinkedListThrottlePipeline pipeline, Endpoint endpoint) {
            this.pipeline = pipeline;
            this.endpoint = endpoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedListThrottlePipeline linkedListThrottlePipeline = this.pipeline;
            synchronized (linkedListThrottlePipeline) {
                String uri = this.endpoint.getUrlContext();
                int port = this.endpoint.getUrlPort();
                int resumeCount = this.endpoint.getMaxConcurrencyLimit() - this.endpoint.getPendingExchangeReplies();
                String key = uri + ":" + port;
                ConcurrentLinkedQueue<SelectionKeyByteBuffer> linkQ = this.pipeline.suspendedKeys.get(key);
                if (mLogger.isLoggable(Level.FINER)) {
                    mLogger.log(Level.FINER, "Resume SelectionKey(s) triggered; URI '" + uri + "', port '" + port + "'; resumeCount= " + resumeCount + ", suspended size=" + linkQ.size());
                }
                if (linkQ != null && linkQ.size() > 0) {
                    for (int i = 0; i < resumeCount; ++i) {
                        if (linkQ.size() <= 0) continue;
                        SelectionKeyByteBuffer skbb = linkQ.poll();
                        try {
                            SelectionKey sk = skbb.getSelectionKey();
                            ByteBuffer bb = skbb.getByteBuffer();
                            if (mLogger.isLoggable(Level.FINER)) {
                                mLogger.log(Level.FINER, "Request URI '" + uri + "', port '" + port + "'; got cached Selectionkey [" + sk + "] and cached ByteBuffer [" + bb + "]");
                            }
                            AsyncReadTask task = (AsyncReadTask)LinkedListThrottlePipeline.this.st.getReadTask(sk);
                            task.getByteBuffer().put(bb);
                            task.setBytesAvailable(true);
                            this.endpoint.incrementPendingExchangeReplies();
                            this.pipeline.internalAddTask((Task)task);
                            if (mLogger.isLoggable(Level.FINER)) {
                                mLogger.log(Level.FINER, "Request URI '" + uri + "', port '" + port + "'; RESUMED Selectionkey [" + task.getSelectionKey() + "],  ByteBuffer [" + task.getByteBuffer() + "] on Task [" + task + "]");
                            }
                            LinkedListThrottlePipeline.this.returnReadByteBuffer(bb);
                            continue;
                        }
                        catch (Throwable t) {
                            String error = mMessages.getString("HTTPBC-E00670.Exception_during_resume_suspended_selectionkey", new Object[]{uri, new Integer(port), skbb.getSelectionKey(), t.getLocalizedMessage()});
                            mLogger.log(Level.WARNING, error, t);
                        }
                    }
                    if (linkQ.size() == 0) {
                        this.pipeline.suspendedKeys.remove(key);
                    }
                }
            }
        }
    }

    class SelectionKeyByteBuffer {
        private SelectionKey sk;
        private ByteBuffer bb;

        SelectionKeyByteBuffer(SelectionKey sk, ByteBuffer bb) {
            this.sk = sk;
            this.bb = bb;
        }

        SelectionKey getSelectionKey() {
            return this.sk;
        }

        ByteBuffer getByteBuffer() {
            return this.bb;
        }
    }
}

