/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc;

import com.sun.jbi.httpsoapbc.HttpSoapEndpoint;
import com.sun.jbi.internationalization.Messages;
import com.sun.xml.ws.api.ResourceLoader;
import com.sun.xml.ws.api.server.Container;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSpiContainerImpl
extends Container {
    private static final Messages mMessages = Messages.getMessages(HttpSpiContainerImpl.class);
    private static final Logger mLog = Messages.getLogger(HttpSpiContainerImpl.class);
    private QName mServiceName;
    private String mServiceUnitID;
    private String mServiceUnitRoot;
    private File mServiceUnitRootPath;
    private ResourceLoader mHttpResourceLoader;

    public HttpSpiContainerImpl(HttpSoapEndpoint endpoint) throws Exception {
        this.mServiceUnitRoot = endpoint.getServiceUnitRootPath();
        this.mServiceName = endpoint.getServiceName();
        this.mServiceUnitID = endpoint.getServiceUnitID();
        try {
            this.mServiceUnitRootPath = new File(this.mServiceUnitRoot);
            this.mHttpResourceLoader = new ResourceLoaderImpl(this.mServiceUnitRootPath);
        }
        catch (Exception e) {
            throw new Exception(mMessages.getString("HTTPBC-E00362.Unable_to_retrieve_su_root", new Object[]{endpoint.getServiceUnitID(), this.mServiceUnitRoot}));
        }
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "HttpSpiContainerImpl created, service unit name = " + this.mServiceName.toString() + ", service unit ID = " + this.mServiceUnitID + ", service unit root path = " + this.mServiceUnitRootPath.getAbsolutePath());
        }
    }

    public <T> T getSPI(Class<T> spiType) {
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, "getSPI called with spiType = " + (spiType == null ? "null" : spiType.getName()));
        }
        if (spiType == ResourceLoader.class) {
            return spiType.cast(this.mHttpResourceLoader);
        }
        mLog.log(Level.FINE, "Service provider type: " + spiType + " not supported by HTTP BC");
        return null;
    }

    private static class ResourceLoaderImpl
    extends ResourceLoader {
        private Set<Locator> mLocators = new HashSet<Locator>();
        private File mRootPath;

        public ResourceLoaderImpl(File rootPath) {
            this.mRootPath = rootPath;
            this.mLocators.add(new FileLocatorImpl(this.mRootPath));
            this.mLocators.add(new ClassLocatorImpl(this.mRootPath));
        }

        public URL getResource(String resource) throws MalformedURLException {
            Locator locator;
            if (mLog.isLoggable(Level.FINE)) {
                mLog.log(Level.FINE, "Resource requested = " + resource);
            }
            URL resourceUrl = null;
            Iterator<Locator> i$ = this.mLocators.iterator();
            while (i$.hasNext() && (resourceUrl = (locator = i$.next()).locate(resource)) == null) {
            }
            if (resourceUrl != null) {
                mLog.log(Level.FINE, "resource [" + resource + "] URI: " + resourceUrl.toString() + "(" + resourceUrl.getClass().getName() + ")");
            } else {
                mLog.log(Level.FINE, "resourceUrl not located for resource: " + resource);
            }
            return resourceUrl;
        }

        private static class ClassLocatorImpl
        implements Locator {
            private File mRootPath;

            public ClassLocatorImpl(File rootPath) {
                this.mRootPath = rootPath;
            }

            public URL locate(Object key) {
                URL resourceUrl = null;
                if (key != null) {
                    String resource = String.valueOf(key);
                    String className = this.classname(resource);
                    String packageName = this.packagename(resource);
                    packageName = packageName.replace('.', '/');
                    if (!"".equals(className)) {
                        StringBuffer path = new StringBuffer();
                        if (!"".equals(packageName)) {
                            path.append(packageName).append("/");
                        }
                        path.append(className).append(".class");
                        File resourceFile = new File(this.mRootPath, path.toString());
                        if (resourceFile.exists()) {
                            try {
                                resourceUrl = this.mRootPath.toURL();
                            }
                            catch (MalformedURLException e) {
                                resourceUrl = null;
                            }
                        }
                    }
                }
                return resourceUrl;
            }

            private String classname(String resource) {
                String classname = resource;
                if (classname.indexOf(46) != -1) {
                    classname = classname.substring(classname.lastIndexOf(46) + 1);
                }
                return classname;
            }

            private String packagename(String resource) {
                String packagename = "";
                if (resource.indexOf(46) != -1) {
                    packagename = resource.substring(0, resource.lastIndexOf(46));
                }
                return packagename;
            }
        }

        private static class FileLocatorImpl
        implements Locator {
            private File mRootPath;

            public FileLocatorImpl(File rootPath) {
                this.mRootPath = rootPath;
            }

            public URL locate(Object key) {
                String resource;
                File resourceFile;
                URL resourceUrl = null;
                if (key != null && (resourceFile = new File(this.mRootPath, resource = String.valueOf(key))).exists()) {
                    try {
                        resourceUrl = resourceFile.toURL();
                    }
                    catch (MalformedURLException e) {
                        resourceUrl = null;
                    }
                }
                return resourceUrl;
            }
        }

        private static interface Locator {
            public URL locate(Object var1);
        }
    }
}

