/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.qos.config;

import com.sun.jbi.common.qos.config.ComponentConfig;
import com.sun.jbi.common.qos.config.Property;
import com.sun.jbi.common.util.Util;
import com.sun.jbi.common.xml.StackableParser;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConfigParser
extends StackableParser {
    private List<Property> mMetadata;
    private String mCurrentGroup;
    private ComponentConfig mConfig = new ComponentConfig();
    private boolean mParsingAppConfig;
    private Property mProperty;

    public ConfigParser() {
        this(null);
    }

    protected ConfigParser(StackableParser parent) {
        super(parent);
    }

    ComponentConfig getConfig() {
        return this.mConfig;
    }

    protected StackableParser newInstance(StackableParser parent) {
        if (parent != this) {
            this.setParent(parent);
        }
        return this;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ((qName = this.stripPrefix(qName)).equals("Property")) {
            this.mProperty = this.buildProperty(attributes);
            if (this.mCurrentGroup != null) {
                this.mProperty.setGroup(this.mCurrentGroup);
            }
        } else if (qName.equals("PropertyGroup")) {
            this.mCurrentGroup = attributes.getValue("name");
        } else if (!qName.equals("Constraint") && qName.equals("ApplicationConfiguration")) {
            this.mParsingAppConfig = true;
            this.mMetadata = new ArrayList<Property>();
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ((qName = this.stripPrefix(qName)).equals("Property")) {
            if (this.mParsingAppConfig) {
                this.mMetadata.add(this.mProperty);
            } else {
                this.mConfig.addProperty(this.mProperty);
            }
        } else if (qName.equals("PropertyGroup")) {
            this.mCurrentGroup = null;
        } else if (qName.equals("ApplicationConfiguration")) {
            this.mParsingAppConfig = false;
            int len = this.mMetadata.size();
            Property[] props = new Property[len];
            this.mMetadata.toArray(props);
            this.mConfig.initializeAppConfig(props);
        } else if (qName.equals("ApplicationVariable")) {
            this.mConfig.initializeAppVars();
        } else if (qName.equals("Configuration")) {
            // empty if block
        }
    }

    Property buildProperty(Attributes attributes) {
        String prop = attributes.getValue("name");
        String value = attributes.getValue("defaultValue");
        String rpts = attributes.getValue("maxOccurs");
        String type = attributes.getValue("type");
        String req = attributes.getValue("required");
        Property p = new Property(prop, value);
        if (!Util.isEmpty((String)rpts)) {
            p.setMaxOccurs(Util.parseInt((String)rpts, (int)1));
        }
        p.setType(this.resolveQName(type));
        p.setRequired(!Util.isEmpty((String)req) || Boolean.valueOf(req) != false);
        return p;
    }
}

