/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.proxy;

import com.sun.jbi.httpsoapbc.proxy.HttpProxy;
import com.sun.jbi.httpsoapbc.security.auth.HttpAuthenticator;
import com.sun.jbi.internationalization.Messages;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.net.www.protocol.http.Handler;

public class HttpProxyURLStreamHandler
extends Handler {
    private static final Messages mMessages = Messages.getMessages(HttpProxyURLStreamHandler.class);
    private static final Logger mLog = Messages.getLogger(HttpProxyURLStreamHandler.class);
    private HttpProxy hp;

    public HttpProxyURLStreamHandler(HttpProxy hp) {
        this.hp = hp;
    }

    public void register() {
        if (!this.hp.isUseJVMProxySettings()) {
            new HttpAuthenticator();
            HttpAuthenticator.registerHttpProxy(this.hp);
        }
    }

    protected URLConnection openConnection(URL u) throws IOException {
        if (this.hp.isUseJVMProxySettings()) {
            return super.openConnection(u);
        }
        if (!"http".equalsIgnoreCase(u.getProtocol())) {
            return super.openConnection(u);
        }
        String nonProxyHosts = this.hp.getNonProxyHosts();
        if (null != nonProxyHosts && 0 != nonProxyHosts.length()) {
            nonProxyHosts = nonProxyHosts.replaceAll(" ", "").toLowerCase();
            String host = u.getHost();
            if (null == host || nonProxyHosts.startsWith(host.toLowerCase() + "|") || nonProxyHosts.endsWith("|" + host.toLowerCase()) || nonProxyHosts.contains("|" + host.toLowerCase() + "|")) {
                return super.openConnection(u);
            }
        }
        if (mLog.isLoggable(Level.FINE)) {
            mLog.log(Level.FINE, mMessages.getString("Proxy is passed in."));
        }
        return super.openConnection(u, this.hp.getProxy());
    }
}

