/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.common.util;

import com.sun.jbi.common.util.I18n;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NDC {
    private static Logger mNDC = Logger.getLogger(NDC.class.getName());
    private static Logger mEnter = Logger.getLogger("com.sun.EnterContext");
    private static Logger mLeave = Logger.getLogger("com.sun.ExitContext");
    private final Object[] mCtx;

    protected NDC(Object ... ctx) {
        this.mCtx = ctx;
    }

    public static NDC enter(Object ... ctx) {
        return new NDC(ctx).enter();
    }

    public static void exit(Object ... ctx) {
        String str = NDC.buildString(ctx);
        mLeave.log(Level.FINE, str, ctx);
        if (mNDC.isLoggable(Level.FINEST)) {
            mNDC.log(Level.FINEST, "UTIL-1002: Exiting NDC " + str, ctx);
        }
    }

    protected NDC enter() {
        String str = NDC.buildString(this.mCtx);
        mEnter.log(Level.FINE, str, this.mCtx);
        if (mNDC.isLoggable(Level.FINEST)) {
            mNDC.log(Level.FINEST, "UTIL-1001: Entering NDC " + str, this.mCtx);
        }
        return this;
    }

    public void exit() {
        NDC.exit(this.mCtx);
    }

    private static String buildString(Object[] ctx) {
        StringBuffer buff = new StringBuffer();
        if (ctx == null || ctx.length == 0) {
            throw new IllegalArgumentException(I18n.loc("UTIL-6006: Invalid context, may not be NULL or zero length!", new Object[0]));
        }
        int len = ctx.length;
        if (len == 1) {
            if (ctx[0] == null) {
                throw new IllegalArgumentException(I18n.loc("UTIL-6006: Invalid context, may not be NULL or zero length!", new Object[0]));
            }
            buff.append("Context={0}");
        } else if (len % 2 == 0) {
            buff.append("Context: ");
            boolean comma = false;
            for (int i = len - 1; i >= 0; i -= 2) {
                if (comma) {
                    buff.append(",");
                }
                buff.append("{").append(i - 1).append("}={").append(i).append("}");
                comma = true;
            }
        } else {
            throw new IllegalArgumentException(I18n.loc("UTIL-6007: Invalid context, must be in key-value pairs!", new Object[0]));
        }
        return buff.toString();
    }
}

