/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.security.realm.impl;

import com.sun.appserv.security.ProgrammaticLogin;
import com.sun.enterprise.security.SecurityContext;
import com.sun.jbi.httpsoapbc.security.api.CredentialValidationException;
import com.sun.jbi.httpsoapbc.security.api.CredentialValidator;
import com.sun.jbi.internationalization.Messages;
import javax.security.auth.Subject;

public class SunRealmCredentialValidator
implements CredentialValidator {
    private static final Messages mMessages = Messages.getMessages(SunRealmCredentialValidator.class);
    private String realm;
    private ProgrammaticLogin progLogin;

    public SunRealmCredentialValidator(String realm) {
        this.realm = realm;
        this.progLogin = new ProgrammaticLogin();
    }

    public String getRealmName() {
        return this.realm;
    }

    public Subject validateCredential(String username, char[] password) throws CredentialValidationException {
        try {
            Boolean result = this.progLogin.login(username, String.valueOf(password), this.realm, true);
            if (result.booleanValue()) {
                return SecurityContext.getCurrent().getSubject();
            }
            throw new CredentialValidationException(mMessages.getString("HTTPBC-E01025.Failed_realm_authentication", new Object[]{username, this.realm}));
        }
        catch (Throwable t) {
            throw new CredentialValidationException(t);
        }
    }
}

