/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.httpsoapbc.util;

import com.sun.jbi.internationalization.Messages;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HttpUrlResolverUtil {
    private static final Messages mMessages = Messages.getMessages(HttpUrlResolverUtil.class);
    protected static final String TOKEN_START_SYMBOL = "${";
    protected static final String TOKEN_END_SYMBOL = "}";
    protected static final String HTTP_DEFAULT_PORT_TOKEN = "${HttpDefaultPort}";
    protected static final String HTTPS_DEFAULT_PORT_TOKEN = "${HttpsDefaultPort}";
    protected Map mApplicationVariables;

    public HttpUrlResolverUtil() {
        this.mApplicationVariables = new HashMap();
    }

    public HttpUrlResolverUtil(Map appVariables) {
        this.mApplicationVariables = appVariables;
    }

    public static boolean isAToken(String name) throws Exception {
        boolean isToken = false;
        if (name.startsWith(TOKEN_START_SYMBOL)) {
            if (name.endsWith(TOKEN_END_SYMBOL)) {
                isToken = true;
            } else {
                throw new Exception(mMessages.getString("HTTPBC-E00253.Token_name_invalid", (Object)name));
            }
        }
        return isToken;
    }

    public String resolveTokens(String url) throws Exception {
        return this.resolveEmbeddedTokens(url);
    }

    public String resolveEmbeddedTokensInURL(String aString, Integer httpDefaultPort, Integer httpsDefaultPort) throws Exception {
        String newString = aString;
        HashMap<String, String> unresolvedTokens = new HashMap<String, String>();
        TokenData tokenData = this.findNextToken(newString, 0);
        while (tokenData != null) {
            String tokenName = tokenData.getTokenName();
            String tokenValue = "";
            if (tokenName.equals(HTTP_DEFAULT_PORT_TOKEN)) {
                if (httpDefaultPort == null || httpDefaultPort != null && httpDefaultPort == -1) {
                    unresolvedTokens.put(HTTP_DEFAULT_PORT_TOKEN, "");
                } else {
                    tokenValue = httpDefaultPort.toString();
                }
            } else if (tokenName.equals(HTTPS_DEFAULT_PORT_TOKEN)) {
                if (httpsDefaultPort == null || httpDefaultPort != null && httpDefaultPort == -1) {
                    unresolvedTokens.put(HTTPS_DEFAULT_PORT_TOKEN, "");
                } else {
                    tokenValue = httpsDefaultPort.toString();
                }
            } else {
                String appVariableName = this.getApplicationVariableName(tokenName);
                String[] metadata = (String[])this.mApplicationVariables.get(appVariableName);
                if (metadata == null || metadata[0] == null) {
                    unresolvedTokens.put(tokenName, "");
                    this.mApplicationVariables.put(appVariableName, new String[]{null, "STRING"});
                } else {
                    tokenValue = metadata[0];
                }
            }
            if (tokenValue != null) {
                newString = newString.replace(tokenName, tokenValue);
            }
            tokenData.setEndIndex(tokenData.getStartIndex() + tokenValue.length());
            if (tokenData.getEndIndex() >= newString.length()) break;
            tokenData = this.findNextToken(newString, tokenData.getEndIndex());
        }
        if (unresolvedTokens.size() > 0) {
            StringBuffer unresolvedTokenNameList = new StringBuffer();
            Iterator it = unresolvedTokens.keySet().iterator();
            while (it.hasNext()) {
                unresolvedTokenNameList.append((String)it.next() + " ");
            }
            throw new Exception(mMessages.getString("HTTPBC-E00297.token_values_not_defined", (Object)unresolvedTokenNameList.toString()));
        }
        return newString;
    }

    public String resolveEmbeddedTokens(String aString) throws Exception {
        String newString = aString;
        TokenData tokenData = this.findNextToken(newString, 0);
        while (tokenData != null) {
            String tokenName = tokenData.getTokenName();
            String tokenValue = null;
            String[] metadata = (String[])this.mApplicationVariables.get(this.getApplicationVariableName(tokenName));
            if (metadata == null || metadata[0] == null) {
                throw new Exception(mMessages.getString("HTTPBC-E00252.Application_variable_not_defined", (Object)tokenName));
            }
            tokenValue = metadata[0];
            newString = newString.replace(tokenName, tokenValue);
            tokenData.setEndIndex(tokenData.getStartIndex() + tokenValue.length());
            if (tokenData.getEndIndex() >= newString.length()) break;
            tokenData = this.findNextToken(newString, tokenData.getEndIndex());
        }
        return newString;
    }

    public String resolveHostNameInUrl(String aLocation) throws Exception {
        String newLocation = aLocation;
        if (aLocation.toLowerCase().indexOf("localhost") > 0) {
            int localhostBeginIndex = newLocation.toLowerCase().indexOf("localhost");
            int localHostEndIndex = localhostBeginIndex + "localhost".length();
            newLocation = new StringBuffer(newLocation).replace(localhostBeginIndex, localHostEndIndex, InetAddress.getLocalHost().getCanonicalHostName()).toString();
        }
        return newLocation;
    }

    public void validateLocationURI(String aLocation) throws Exception {
        URI uri = new URI(aLocation);
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            throw new Exception(mMessages.getString("HTTPBC-E00292.Protocol_unsupported", new Object[]{scheme, aLocation}));
        }
        uri.toURL();
    }

    public void validateHttpUrl(String aUrlLocation) throws Exception {
        TokenData token = this.findNextToken(aUrlLocation, 0);
        if (token == null) {
            try {
                URL url = new URL(aUrlLocation);
            }
            catch (MalformedURLException e) {
                throw new Exception(mMessages.getString("HTTPBC-E01231.Invalid_http_url", (Object)aUrlLocation));
            }
        } else {
            int pathDelim;
            if (token.getTokenName().length() == aUrlLocation.length()) {
                return;
            }
            if (!aUrlLocation.toLowerCase().startsWith("http://") && !aUrlLocation.toLowerCase().startsWith("https://")) {
                throw new Exception(mMessages.getString("HTTPBC-E01231.Invalid_http_url", (Object)aUrlLocation));
            }
            boolean isSecure = aUrlLocation.toLowerCase().startsWith("https://");
            int n = pathDelim = isSecure ? aUrlLocation.indexOf("/", 8) : aUrlLocation.indexOf("/", 7);
            if (pathDelim > 0) {
                String hostPort = isSecure ? aUrlLocation.substring(8, pathDelim) : aUrlLocation.substring(7, pathDelim);
                this.validateHostPortInUrl(aUrlLocation, hostPort, isSecure);
            } else {
                String hostPort = isSecure ? aUrlLocation.substring(8) : aUrlLocation.substring(7);
                this.validateHostPortInUrl(aUrlLocation, hostPort, isSecure);
            }
        }
    }

    public void validateHostPortInUrl(String aUrlLocation, String hostPort, boolean isSecure) throws Exception {
        int colonIndex = hostPort.indexOf(":");
        if (colonIndex <= 0) {
            throw new Exception(mMessages.getString("HTTPBC-E01231.Invalid_http_url", (Object)aUrlLocation));
        }
        TokenData token = this.findNextToken(hostPort, 0);
        if (token != null) {
            if (token.getTokenName().length() != hostPort.length()) {
                if (hostPort.startsWith("$")) {
                    if (colonIndex != token.getEndIndex()) {
                        throw new Exception(mMessages.getString("HTTPBC-E01231.Invalid_http_url", (Object)aUrlLocation));
                    }
                    String port = hostPort.substring(colonIndex + 1);
                    if (HttpUrlResolverUtil.isAToken(port)) {
                        this.validateHttpPortTokens(port, isSecure);
                    }
                } else {
                    if (colonIndex != token.getStartIndex() - 1) {
                        throw new Exception(mMessages.getString("HTTPBC-E01231.Invalid_http_url", (Object)aUrlLocation));
                    }
                    String port = token.getTokenName();
                    this.validateHttpPortTokens(port, isSecure);
                }
            } else {
                throw new Exception(mMessages.getString("HTTPBC-E01234.Invalid_host_port_with_tokens", (Object)aUrlLocation));
            }
        }
    }

    public void validateHttpPortTokens(String httpPortToken, boolean isSecure) throws Exception {
        if (!httpPortToken.equals(HTTP_DEFAULT_PORT_TOKEN) && !httpPortToken.equals(HTTPS_DEFAULT_PORT_TOKEN)) {
            throw new Exception(mMessages.getString("HTTPBC-E01232.Invalid_http_port_tokens", (Object)httpPortToken));
        }
        if (isSecure && !httpPortToken.equals(HTTPS_DEFAULT_PORT_TOKEN)) {
            throw new Exception(mMessages.getString("HTTPBC-E01233.Address_protocol_mismatch", new Object[]{httpPortToken, "https://"}));
        }
        if (!isSecure && !httpPortToken.equals(HTTP_DEFAULT_PORT_TOKEN)) {
            throw new Exception(mMessages.getString("HTTPBC-E01233.Address_protocol_mismatch", new Object[]{httpPortToken, "http://"}));
        }
    }

    public TokenData findNextToken(String aString, int aStartIndex) {
        TokenData retVal = null;
        int start = aString.indexOf(TOKEN_START_SYMBOL, aStartIndex);
        int end = aString.indexOf(TOKEN_END_SYMBOL, aStartIndex);
        if (start >= 0 && end > 0 && start < end) {
            retVal = new TokenData(start, end + 1, aString.substring(start, end + 1));
        }
        return retVal;
    }

    public String getApplicationVariableName(String aToken) throws Exception {
        String tokenName = null;
        if (aToken == null || "".equals(aToken)) {
            throw new Exception(mMessages.getString("HTTPBC-E00253.Token_name_invalid", (Object)aToken));
        }
        tokenName = aToken.substring(2, aToken.length() - 1);
        if ("".equals(tokenName)) {
            throw new Exception(mMessages.getString("HTTPBC-E00253.Token_name_invalid", (Object)aToken));
        }
        return tokenName;
    }

    public class TokenData {
        private final String tokenName;
        private int startIndex;
        private int endIndex;

        public TokenData(int startIndex, int aIndex, String aName) {
            this.startIndex = startIndex;
            this.endIndex = aIndex;
            this.tokenName = aName;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String getTokenName() {
            return this.tokenName;
        }

        public void setStartIndex(int index) {
            this.startIndex = index;
        }

        public void setEndIndex(int index) {
            this.endIndex = index;
        }
    }
}

