#!/bin/bash

# for Web VMs

# if eth1 exists, and it is a ixgbevf device, then
# get eth0 ip/route, ifdown eth0, and configure
# eth1 with eth0's IP

if [ -e /sys/class/net/eth1 ]; then
   eth0_ip=`ip addr show dev eth0 | grep "inet " | awk '{print $2}' | awk -F/ '{print $1}'`
   if [ -z "$eth0_ip" ]; then
	echo "no ip address for eth0, exiting"
        exit 1
   fi
   def_route_gw=`ip route show | grep default | awk '{print $3}'`
   echo migrating eth0 ip $eth0_ip to eth2
   ifdown eth0
   ifconfig eth1 down
   ifconfig eth1 $eth0_ip netmask 255.255.0.0 up
   route add -net default gw $def_route_gw dev eth1
fi 

# if there is an eth2 device, set up a IP for a point-to-point network between web and infra
if [ -e /sys/class/net/eth2 ]; then
    # remove any old host/ip info
    sed -i /etc/hosts -e '/.*-infra.*/d' -e '/^$/d'

    # create new IPs for eth2 devices (web and infra)
    infra=`hostname -s | sed -e s/web/infra/`
    tile=`hostname -s | sed -e s/vg-webt// -e s/^0*//`
    web_eth2_ip="192.132.${tile}.1"
    infra_eth2_ip="192.132.${tile}.2"
    printf "$infra_eth2_ip\t\t$infra\n" >>/etc/hosts

    # bridge up eth2
    ifconfig eth2 $web_eth2_ip netmask 255.255.0.0 up
else
    # make sure there is no private network IPs for hostnames
    sed -i /etc/hosts -e '/.*-infra.*/d' -e '/^$/d'
fi

