# Various workload specific tunings 
# Called by rc.local

# This part is tuned on /etc/sysctl.conf
#ethno=$(ifconfig | grep "^eth" | wc -l)
#if [ $ethno -gt 1 ]; then
#	sysctl -w net.ipv4.conf.default.arp_filter=1
#	sysctl -w net.ipv4.conf.all.arp_filter=1
#fi

hostname | egrep -q "webserver|infraserver" && {
#	sysctl -w net.ipv4.tcp_fin_timeout=60
	sysctl -w net.ipv4.tcp_syn_retries=4
	sysctl -w net.ipv4.tcp_retries2=7
	sysctl -w net.ipv4.tcp_keepalive_time=120
	sysctl -w net.ipv4.tcp_tw_reuse=1 
}

hostname | egrep -q "webserver|appserver|idleserver" && {
	sysctl -w vm.swappiness=0
	sysctl -w vm.overcommit_memory=1
}

hostname | grep -q appserver && {
	#echo 768 > /proc/sys/vm/nr_hugepages
	#echo 500 > /proc/sys/vm/hugetlb_shm_group
        echo 658 > /proc/sys/vm/nr_hugepages
	id -g spec > /proc/sys/vm/hugetlb_shm_group

	mkdir /dev/hugepages
	mount -t hugetlbfs hugetlbfs /dev/hugepages
}

# RHEL6.1 has configured this in /etc/sysctl.conf
#hostname | egrep -q "appserver|dbserver" && {
#	sysctl -w kernel.msgmnb=65536
#	sysctl -w kernel.msgmax=65536
#	sysctl -w kernel.shmmax=68719476736
#	sysctl -w kernel.shmall=4294967296
#}

# Save some memory for the client
hostname | egrep -q "specclient" && {
        echo never > /sys/kernel/mm/redhat_transparent_hugepage/enabled
}

