#!/bin/bash

numactl --membind=11  --cpunodebind=11    nice -n -6 /usr/libexec/qemu-kvm  -M rhel6.2.0 \
	-cpu qemu64,+kvm_pv_eoi,+ssse3,+sse4_1,+sse4_2,+vme,+pat,+x2apic,+popcnt \
	-smp 1,sockets=1,cores=1,threads=1 \
	-enable-kvm -rtc clock=vm,base=localtime   \
	-m 2304\
	-mem-prealloc -mem-path /dev/hugepages/  \
	-redhat-disable-KSM \
	-name VM-app-server-tile-89 \
	-no-kvm-pit-reinjection \
	-drive if=none,id=drive0,cache=none,aio=native,format=raw,file=/mnt/datastore-tile-89/VM-app-server-tile-89/VM-app-server-tile-89.img -device virtio-blk,drive=drive0,scsi=off,x-data-plane=on \
	-daemonize \
	-net none -pcidevice host=82:1a.5 -pcidevice host=a1:1a.5 -k fr \
	-vnc :532 
