#!/bin/sh
#
#  ./SPECvirt_sc2013V1.1_p1_update.sh [SPECvirt_sc2013 install directory]
#
#
# This script will checkpoint the original files in the $WEBSOURCEDIR directory and apply the xdelta 
# patches to create updated versions of those files. The script assumes that the patch tarball
# was unpacked in the $WEBSOURCEDIR directory and the script is run from the same location. It is
# also assumed that the xdelta tool is installed on the system.
# 
#




REPORTER_MD5=1c0e6f2e3ea019836fd692380e9ed296
SPECWEB_MD5=19dc1335356bd24d57742ccf5e419a56
SPECWEB_CLIENT_MD5=4cf2661932bc45d3ecdfc93dd15e638a
VALIDATOR_CLASS_MD5=6728f9ca90a5898b4ca4421ea7f764d1
VALIDATOR_JAVA_MD5=c984486a7be89b6ab829cb106eeb902e


if [ -f specwebclient.jar ]; then

  # Checkpoint original v1.1 files
 
  echo "Checkpointing original files to *.orig"

  set -x
  mv reporter.jar reporter.jar.orig
  mv specwebclient.jar specwebclient.jar.orig
  mv specweb.jar specweb.jar.orig
  mv classes/org/spec/specweb/Validator.class classes/org/spec/specweb/Validator.class.orig
  mv src/org/spec/specweb/Validator.java src/org/spec/specweb/Validator.java.orig

# Apply xdelta patches
  set +x
  echo "Applying patches"

  set -x
  xdelta patch reporter.jar.patch reporter.jar.orig reporter.jar
  xdelta patch specwebclient.jar.patch specwebclient.jar.orig specwebclient.jar
  xdelta patch specweb.jar.patch specweb.jar.orig specweb.jar
  xdelta patch classes/org/spec/specweb/Validator.class.patch classes/org/spec/specweb/Validator.class.orig classes/org/spec/specweb/Validator.class
  xdelta patch src/org/spec/specweb/Validator.java.patch src/org/spec/specweb/Validator.java.orig src/org/spec/specweb/Validator.java


  set +x
  echo "Validating patches"

  set -x
  TEST=reporter.jar
  MD5SUM=`md5sum ${TEST} | awk '{ print $1 }'`
  if [ ${REPORTER_MD5} != ${MD5SUM} ]
  then
    echo "ERROR: MD5 miscompare"
    echo "File ${TEST} has an MD5 value of ${MD5SUM} which does not match the expected value of"
    echo "${REPORTER_MD5}. Please confirm original file was not corrupt."
    exit 1
  fi
   
  TEST=specwebclient.jar
  MD5SUM=`md5sum ${TEST} | awk '{ print $1 }'`
  if [ ${SPECWEB_CLIENT_MD5} != ${MD5SUM} ]
  then
    echo "ERROR: MD5 miscompare"
    echo "File ${TEST} has an MD5 value of ${MD5SUM} which does not match the expected value of"
    echo "${SPECWEB_CLIENT_MD5}. Please confirm original file was not corrupt."
    exit 1
  fi

  TEST=specweb.jar
  MD5SUM=`md5sum ${TEST} | awk '{ print $1 }'`
  if [ ${SPECWEB_MD5} != ${MD5SUM} ]
  then
    echo "ERROR: MD5 miscompare"
    echo "File ${TEST} has an MD5 value of ${MD5SUM} which does not match the expected value of"
    echo "${SPECWEB_MD5}. Please confirm original file was not corrupt."
    exit 1
  fi

  TEST=classes/org/spec/specweb/Validator.class
  MD5SUM=`md5sum ${TEST} | awk '{ print $1 }'`
  if [ ${VALIDATOR_CLASS_MD5} != ${MD5SUM} ]
  then
    echo "ERROR: MD5 miscompare"
    echo "File ${TEST} has an MD5 value of ${MD5SUM} which does not match the expected value of"
    echo "${VALIDATOR_CLASS_MD5}. Please confirm original file was not corrupt."
    exit 1
  fi

  TEST=src/org/spec/specweb/Validator.java
  MD5SUM=`md5sum ${TEST} | awk '{ print $1 }'`
  if [ ${VALIDATOR_JAVA_MD5} != ${MD5SUM} ]
  then
    echo "ERROR: MD5 miscompare"
    echo "File ${TEST} has an MD5 value of ${MD5SUM} which does not match the expected value of"
    echo "${VALIDATOR_JAVA_MD5}. Please confirm original file was not corrupt."
    exit 1
  fi

  set +x
  echo "Patch application complete!"


else
  echo "ERROR: Incorrect location."
  echo "The file specwebclient.jar was not found in the current directory. Please unpack the patch"
  echo "into your [SPECvirt_sc2013 installation dir]/SPECweb2005 directory and run the script"
  echo "from that location."
  exit 1
fi 


