#!/bin/sh
#######################################################################
#
# virt_sc2013_run.sh
#
# Sample run script for SPECbatch workload
#######################################################################
#
# This is a SAMPLE file which you can use to control the SPECbatch 
# workload operation. 
#
# The script uses standard Unix/Linux shell scripting. The 
# SPECvirt_sc harness will pass the run script two values: 
#
#   $1 = results output directory where a given benchmark run's
#   results will be staged; 
#
#   $2 = Number of times the 401.bzip2 workload will be executed. The 
#   number of jobs is defined in the SPECbatch/Test.config variable 
#   BATCH_COPY_COUNT. 
#
# NOTE: A compliant SPECbatch script must run the 401.bzip2 training 
# workload BATCH_COPY_COUNT times ($1) and move the resulting output 
# and log files to the directory location ($2) passed to the script.
# 
#######################################################################

#----------------------------------------------------------------------
# JOBS is the script's parameter that defines how many times the 
# 401.bzip2 workload needs to be executed. 
# 
# COUNT is the script's counter variable.
#----------------------------------------------------------------------

JOBS=${2}
COUNT=0

#----------------------------------------------------------------------
# The following two commands set up the SPEC CPU2006 environment. Refer
# to the SPEC CPU2006 documentation for how to set up the SPEC CPU2006
# environment on non-Unix platforms.
#----------------------------------------------------------------------

. ./shrc
bin/relocate

#----------------------------------------------------------------------
# The "ulimit" command sets the stack size for the SPECbatch workload
# to "unlimited" so that there is enough stack for the workload to
# run. This value can be adjusted as long as the workload validates
# properly.
#
# "a" is the number of CPU cores present in the batchserver VM. The 
# value is calculated by examining the linux /proc/cpuinfo file. This 
# variable can be set explicitly with the number of CPU cores or
# any other value to control how many concurrent 401.bzip2 copies are
# executed.
#----------------------------------------------------------------------

ulimit -s unlimited
a=`cat /proc/cpuinfo | grep processor | wc -l`

#----------------------------------------------------------------------
# The "rm" lines delete any old run directories and result files from
# the SPECbatch harness. This is done to ensure the output file names
# for the SPECbatch runs are the expected enumeration. 
#----------------------------------------------------------------------

rm -rf benchspec/CPU2006/*/run
rm -rf ${SPEC}/result/lock.CPU2006
rm -rf ${SPEC}/result/C*


#----------------------------------------------------------------------
# SEC is a counter used to calculate the elapsed time for the job
# execution loop. This is an optional variable
#----------------------------------------------------------------------

SEC=0

#----------------------------------------------------------------------
# The while-done loop below is the main execution portion of the 
# script. While the counter COUNT is less than the total number of 
# requested jobs, JOBS, the script will execute "a" number of 401.bzip2 
# concurrent copies. If the remaining number of jobs, REMAIN, is less 
# than "a" then only REMAIN number of concurrent jobs will be executed 
# on the final loop.
#----------------------------------------------------------------------

while [ ${COUNT} -lt ${JOBS} ]
do
  REMAIN=$(($JOBS-$COUNT))
  if [ ${REMAIN} -lt ${a} ]
  then
    RATE=${REMAIN}
    COUNT=$(($COUNT+$REMAIN))
  else
    RATE=${a}
    COUNT=$(($COUNT+$a))
  fi
  echo ${COUNT}

#----------------------------------------------------------------------
# The runspec command is the critical command for running the 401.bzip2 
# jobs for the SPECbatch workload. This syntax must be followed for all 
# invocations of runspec used to execute the SPECbatch workload. The
# only parameter that can be changed is "-r $RATE", which is the number
# of copies of 401.bzip2 executed per invocation.
#----------------------------------------------------------------------

  runspec -l -n 1 -i train -r $RATE -c cpu2006-virt.cfg -T base  -o asc 401

#----------------------------------------------------------------------
# The following four lines are merely calculating the execution time
# for the loop. This code provided for debugging and is not required
# for a compliant run.
#----------------------------------------------------------------------

  RUNNUM=`cat ${SPEC}/result/lock.CPU2006`
  RUNTIME=`grep "runspec finished" ${SPEC}/result/CPU2006.${RUNNUM}.log |awk {'print$9'}`
  SEC=`expr ${SEC} + ${RUNTIME}`
  echo ${SEC}
done

#----------------------------------------------------------------------
# The lines below create the result staging directory and copy the
# result files for all of the runs executed to complete the required
# number of 401.bzip2 jobs. The SPECvirt harness will locate these
# files when the prime controller collects the output at the end of
# a benchmark run. A compliant script must create this directory and
# copy the CPU2006 result files (output and logs) to the directory.
#----------------------------------------------------------------------

mkdir ${1}
mv ${SPEC}/result/C*  ${1}




