/*++

  Copyright (c) 1999 Microsoft Corporation   
  
    Module Name:
    logfile.HXX
      
    Author: Neel Jain (njain)
    
    Modified:
    TYHuang: for SPECweb99/VC++
          
--*/        



//
// Post log record structure
//


#ifndef _LOGFILE_HXX_
#define _LOGFILE_HXX_


#include "dualspinlock.hxx"
#include "spinlock.hxx"

//#include "isapireq.hxx"

//
// Buffer structure for the log
//
typedef struct _logBuf
{

    // offset into the log file
    unsigned __int64 logFileOffset;

    // file handle of the log file
    HANDLE logFile;

    // data buffer
    char *logData;
    
    // linked list pointer to next buffer
    _logBuf *next;

    // number of bytes used in this buffer
    long bytesUsed;

    // size of this daya buffer
    long bytesAvailable;

} logBuf;



//
// define post log record
//

typedef struct _postLogRd
{
	int		recordNum;
	int		timeStamp;
	int		pID;
	int		dirNum;
	int		classNum;
	int		fileNum;
	int		clientNum;
	char	fileName[61];
	int		myCookie;

} postLogRd;




//
// Log information. It needs to be laid out better --
// logLock, freeBufs and dirtyBuf should be on their own cache lines
//

struct _logInfo {
    
    // size of each log file. Once full, close it and open another one
    unsigned __int64 fileSize;

    // file handle of current log file
    HANDLE currentLogFile;

    // log entry counter
    ULONG   entryCounter;

    // base log file name = PostLog
    char *logFileBaseName;

    // pointer to the first buffer
    logBuf *firstBuffer;

    // linked list of free buffers
    logBuf *freeBuffers;

    // pointer to current log buffer in use 
    logBuf *currentBuffer;

    // linksed list of dirty buffer that need to be flusged to disk
    logBuf *dirtyBuffers;


    // size of each buffer
    ULONG bufferSize;

    // log file count for file name used
    ULONG fileCount;

    // lock
    DualSpinLock logLock;

	//lock for exclusive increment entryCounter and reserve the space for writing

	SpinLock  slLock;

    char separator;
    char terminator;
    char useLog;
};




UINT InitDefaultLog(char *);
UINT CleanupDefaultLog();

UINT WriteLogExclusive(postLogRd logRd);
UINT WriteLogShared(postLogRd logRd);

//UINT WriteLogExclusive(char **,  ULONG *, ULONG);
//UINT WriteLogShared(char **, ULONG *, ULONG);

UINT	FlushCachedData();
UINT	FlushCachedDataExclusive();

//copy log record to buffer
UINT copyLogRecord(char *pBuf, postLogRd logRd, int recordLen);

//transfer int to chars

void intToCharsNoReverse(char *pBuf, unsigned int inData);

#endif // IISDEFLOG_HXX
