#ifndef _NET_TUX_TUX_U_H
#define _NET_TUX_TUX_U_H

/*
 * TUX - Scalable Integrated Web Cache and Web Server
 *
 * Copyright (C) 2000, Ingo Molnar <mingo@redhat.com>
 *
 * tux.h: TUXAPI - TUX interface to user-space
 */

#define __KERNEL_SYSCALLS__

typedef enum http_versions {
        HTTP_1_0,
        HTTP_1_1
} http_version_t;

/*
 * Request methods known to TUX:
 */
typedef enum http_methods {
        METHOD_NONE,
        METHOD_GET,
        METHOD_HEAD,
        METHOD_POST,
        METHOD_PUT
} http_method_t;

enum tux_action {
	TUX_ACTION_STARTUP = 1,
	TUX_ACTION_SHUTDOWN = 2,
	TUX_ACTION_STARTTHREAD = 3,
	TUX_ACTION_STOPTHREAD = 4,
	TUX_ACTION_EVENTLOOP = 5,
	TUX_ACTION_GET_OBJECT = 6,
	TUX_ACTION_SEND_OBJECT = 7,
	TUX_ACTION_READ_OBJECT = 8,
	TUX_ACTION_FINISH_REQ = 9,
	MAX_TUX_ACTION
};

enum tux_ret {
	TUX_RETURN_USERSPACE_REQUEST = 0,
	TUX_RETURN_EXIT = 1,
	TUX_RETURN_SIGNAL = 2,
};

#define MAX_MODULENAME_LEN 16
#define MAX_URI_LEN 256
#define MAX_POST_DATA 1024
#define MAX_COOKIE_LEN 64

typedef struct user_req_s {
	int http_version;
	int http_method;
	int sock;
	int bytes_sent;
	int http_status;
	unsigned int client_host;
	unsigned int objectlen;
	char query[MAX_URI_LEN];
	char *object_addr;
	char objectname[MAX_URI_LEN];
	char modulename[MAX_MODULENAME_LEN];
	char post_data[MAX_POST_DATA];

	int cookies_len;
	char cookies[MAX_COOKIE_LEN];

	int event;
	int thread_nr;
	void *id;
	void *private;
} user_req_t;

extern char *TUXAPI_docroot;
extern char *TUXAPI_version;

extern int tux (unsigned int action, user_req_t *req);

#endif
