//
//  postlog.h
//
//  Author: Tai-Yi Huang (tyhuang)  June, 2000
//

#ifndef _W_POSTLOG_H
#define _W_POSTLOG_H

#include "lock.h"

#define     POSTLOG_FLUSH_INTERVAL      (60000)         // 60 seconds
#define     LOG_BUF_SIZE                (256 * KB)
#define     LOG_FILE_SIZE               (1 * GIG)
#define     COUNTER_LENGTH              (10)
#define     LOG_RECORD_LENGTH           (106)

typedef struct _LOG_BUFFER {

    // offset into the log file
    unsigned __int64    PostLogFileOffset;

    // data buffer
    PCHAR               LogData;

    // linked list to next buffer
    struct _LOG_BUFFER  *Next;

    // number of bytes used in this buffer
    ULONG               BytesUsed;

} LOG_BUFFER, *PLOG_BUFFER;

typedef struct _LOG_RECORD {

    ULONG               RecordNum;
    ULONG               TimeStamp;
    ULONG               Pid;
    ULONG               DirNum;
    ULONG               ClassNum;
    ULONG               FileNum;
    ULONG               ClientNum;
    ULONG               MyCookie;
    CHAR                FileName[64];

} LOG_RECORD, *PLOG_RECORD;

typedef struct _LOG_INFO {

    // Read-Write spinlock
    RWSpinLock          Lock;

    // Another lock that we need to investigate if we can remove it
    RWSpinLock          ShLock;

    // file handle of the postlog file
    HANDLE              LogFileHandle;

    // log entry counter
    ULONG               LogEntryCounter;

    // the first buffer
    PLOG_BUFFER         FirstBuffer;

    // the currently-used buffer
    PLOG_BUFFER         CurrentBuffer;

    // free buffer linked list
    PLOG_BUFFER         FreeBufferList;

    // dirty buffer linked listr
    PLOG_BUFFER         DirtyBufferList;

    CHAR                SeparatorChar;
    CHAR                TerminatorChar;

} LOG_INFO, *PLOG_INFO;

VOID        PostLogFlushThread(LPVOID Pars);
VOID        InitializePostLogInfo();
HANDLE      NewPostLogFile();
PLOG_BUFFER NewLogBuffer(unsigned __int64 FileOffset);
DWORD       WritePostLogShared(PLOG_RECORD Record);
DWORD       WritePostLogExclusive(PLOG_RECORD Record);
DWORD       FlushCachedDataExclusive();
DWORD       FlushCachedData();
VOID        ConvertNumberToStringWithSpace(PCHAR StrPtr, ULONG Number, ULONG DigitFields);

#endif // _W_POSTLOG_H

